/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MD3AnimConfig {
    public static final String DEATH_1 = "Death 1";
    public static final String DEAD_1 = "Death 1";
    public static final String DEATH_2 = "Death 2";
    public static final String DEAD_2 = "Dead 2";
    public static final String DEATH_3 = "Death 3";
    public static final String DEAD_3 = "Dead 3";
    public static final String GESTURE = "Gesture";
    public static final String ATTACK = "Attack";
    public static final String ATTACK_2 = "Attack 2";
    public static final String DROP = "Drop";
    public static final String RAISE = "Raise";
    public static final String STAND = "Stand";
    public static final String STAND_2 = "Stand 2";
    public static final String WALK_CR = "Walk CR";
    public static final String WALK = "Walk";
    public static final String RUN = "Run";
    public static final String BACK = "Back";
    public static final String SWIM = "Swim";
    public static final String JUMP = "Jump";
    public static final String LAND = "Land";
    public static final String JUMP_B = "Jump B";
    public static final String LAND_B = "Land B";
    public static final String IDLE = "Idle";
    public static final String IDLE_CR = "Idle CR";
    public static final String TURN = "Turn";
    public static final int BOTH = 1;
    public static final int TORSO = 2;
    public static final int LEGS = 3;
    private Anim[] anims = new Anim[]{new Anim("Death 1", 1), new Anim("Death 1", 1), new Anim("Death 2", 1), new Anim("Dead 2", 1), new Anim("Death 3", 1), new Anim("Dead 3", 1), new Anim("Gesture", 2), new Anim("Attack", 2), new Anim("Attack 2", 2), new Anim("Drop", 2), new Anim("Raise", 2), new Anim("Stand", 2), new Anim("Stand 2", 2), new Anim("Walk CR", 3), new Anim("Walk", 3), new Anim("Run", 3), new Anim("Back", 3), new Anim("Swim", 3), new Anim("Jump", 3), new Anim("Land", 3), new Anim("Jump B", 3), new Anim("Land B", 3), new Anim("Idle", 3), new Anim("Idle CR", 3), new Anim("Turn", 3)};
    private int anim = 0;
    private HashMap map = new HashMap();

    public MD3AnimConfig(DataInputStream in) throws IOException {
        int offset = -1;
        int firstTorso = -1;
        while (in.available() > 0) {
            StringTokenizer tokens;
            String line = in.readLine();
            if (line.equals("") || line.startsWith("//") || (tokens = new StringTokenizer(line)).countTokens() <= 4) continue;
            this.anims[this.anim].readAnim(tokens);
            if (this.anims[this.anim].type == 3) {
                if (offset == -1) {
                    offset = this.anims[this.anim].first - firstTorso;
                }
                this.anims[this.anim].first -= offset;
            }
            if (firstTorso == -1 && this.anims[this.anim].type == 2) {
                firstTorso = this.anims[this.anim].first;
            }
            ++this.anim;
        }
        int i = 0;
        while (i < this.anims.length) {
            this.map.put(this.anims[i].name, this.anims[i]);
            ++i;
        }
    }

    public int getFirstFrame(String animName) {
        Anim anim = (Anim)this.map.get(animName);
        if (anim != null) {
            return anim.first;
        }
        return 0;
    }

    public int getFrameCount(String animName) {
        Anim anim = (Anim)this.map.get(animName);
        if (anim != null) {
            return anim.count;
        }
        return 0;
    }

    public boolean isLooping(String animName) {
        Anim anim = (Anim)this.map.get(animName);
        if (anim != null) {
            return anim.looping != 0;
        }
        return false;
    }

    public String getAnimationForFrame(int f, int type) {
        int i = 0;
        while (i < this.anims.length) {
            if (f >= this.anims[i].first && f < this.anims[i].first + this.anims[i].count && (this.anims[i].type == type || this.anims[i].type == 1)) {
                return this.anims[i].name;
            }
            ++i;
        }
        return null;
    }

    static {
        DEATH_1 = "Death 1";
        DEAD_1 = "Death 1";
        DEATH_2 = DEATH_2;
        DEAD_2 = DEAD_2;
        DEATH_3 = DEATH_3;
        DEAD_3 = DEAD_3;
        GESTURE = GESTURE;
        ATTACK = ATTACK;
        ATTACK_2 = ATTACK_2;
        DROP = DROP;
        RAISE = RAISE;
        STAND = STAND;
        STAND_2 = STAND_2;
        WALK_CR = WALK_CR;
        WALK = WALK;
        RUN = RUN;
        BACK = BACK;
        SWIM = SWIM;
        JUMP = JUMP;
        LAND = LAND;
        JUMP_B = JUMP_B;
        LAND_B = LAND_B;
        IDLE = IDLE;
        IDLE_CR = IDLE_CR;
        TURN = TURN;
        BOTH = 1;
        TORSO = 2;
        LEGS = 3;
    }

    private class Anim {
        public String name;
        public int type;
        public int first;
        public int count;
        public int looping;
        public int fps;

        public Anim(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public void readAnim(StringTokenizer tokens) {
            this.first = Integer.parseInt(tokens.nextToken());
            this.count = Integer.parseInt(tokens.nextToken());
            this.looping = Integer.parseInt(tokens.nextToken());
            this.fps = Integer.parseInt(tokens.nextToken());
        }
    }
}

