/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.chunks;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import java.util.ArrayList;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class RotationChunk
extends Chunk {
    public static String ROTATION_TAG = "ROTATION_INTERPOLATOR";

    public void loadData(ChunkChopper chopper) {
        int flags = chopper.getUnsignedShort();
        chopper.getLong();
        int numKeys = chopper.getUnsignedInt();
        Quat4f previousQuat = null;
        ArrayList<Quat4f> quats = new ArrayList<Quat4f>();
        for (int i = 0; i < numKeys; ++i) {
            long frameNumber = chopper.getUnsignedInt();
            int accelerationData = chopper.getUnsignedShort();
            this.getSplineTerms(accelerationData, chopper);
            float angle = chopper.getFloat();
            Vector3f vector = chopper.getVector();
            Quat4f quat = this.getQuaternion(vector, angle);
            if (previousQuat != null) {
                quat.mul(previousQuat, quat);
            }
            previousQuat = quat;
            quats.add(quat);
            if (i != 0) continue;
            chopper.getKeyFramer().setRotation(quat);
        }
        chopper.getKeyFramer().setOrientationKeys(quats);
    }

    private void getSplineTerms(int accelerationData, ChunkChopper chopper) {
        int bits = accelerationData;
        for (int i = 0; i < 5; ++i) {
            if (((bits >>>= i) & 1) != 1) continue;
            chopper.getFloat();
        }
    }

    public Quat4f getQuaternion(Vector3f axis, float angle) {
        float sinA = (float)Math.sin(angle / 2.0f);
        float cosA = (float)Math.cos(angle / 2.0f);
        return new Quat4f(axis.x * sinA, axis.y * sinA, axis.z * sinA, cosA);
    }
}

