/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.AabbGeomNode;
import net.sf.nwn.loader.AnimEmitterNode;
import net.sf.nwn.loader.AnimNode;
import net.sf.nwn.loader.DanglymeshGeomNode;
import net.sf.nwn.loader.DummyGeomNode;
import net.sf.nwn.loader.EmitterNode;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.KeyAxisAngle;
import net.sf.nwn.loader.KeyFloat;
import net.sf.nwn.loader.KeyVector;
import net.sf.nwn.loader.Model;
import net.sf.nwn.loader.ModelAnimation;
import net.sf.nwn.loader.TrimeshGeomNode;

public final class ManualParser {
    private static final int BUF_SIZE = 4096;
    private static final int SYMBOL_SIZE = 256;
    private static final boolean[] whitespace = new boolean[256];
    private byte[] buf = new byte[4096];
    private int index;
    private int limit;
    private char[] symbol = new char[256];
    private int slimit;
    private int line = 1;
    private InputStream reader;
    public static ManualParser sharedParser;
    public static boolean internStrings;
    private KeyVector kv = new KeyVector();
    private KeyAxisAngle kaa = new KeyAxisAngle();
    public static final String FILEDEPENDANCY = "filedependancy";
    public static final String NEWMODEL = "newmodel";
    public static final String DONEMODEL = "donemodel";
    public static final String SETSUPERMODEL = "setsupermodel";
    public static final String CLASSIFICATION = "classification";
    public static final String SETANIMATIONSCALE = "setanimationscale";
    public static final String BEGINMODELGEOM = "beginmodelgeom";
    public static final String ENDMODELGEOM = "endmodelgeom";
    public static final String NEWANIM = "newanim";
    public static final String DONEANIM = "doneanim";
    public static final String NODE = "node";
    public static final String ENDNODE = "endnode";
    public static final String BITMAP = "bitmap";
    public static final String VERTS = "verts";
    public static final String FACES = "faces";
    public static final String TVERTS = "tverts";
    public static final String PARENT = "parent";
    public static final String POSITION = "position";
    public static final String ORIENTATION = "orientation";
    public static final String WIRECOLOR = "wirecolor";
    public static final String AMBIENT = "ambient";
    public static final String DIFFUSE = "diffuse";
    public static final String SPECULAR = "specular";
    public static final String SHININESS = "shininess";
    public static final String LENGTH = "length";
    public static final String TRANSTIME = "transtime";
    public static final String ANIMROOT = "animroot";
    public static final String POSITIONKEY = "positionkey";
    public static final String ORIENTATIONKEY = "orientationkey";
    public static final String ENDLIST = "endlist";
    public static final String EVENT = "event";
    public static final String COLORS = "colors";
    public static final String SCALE = "scale";
    public static final String SELFILLUMCOLOR = "selfillumcolor";
    public static final String ALPHA = "alpha";
    public static final String CONSTRAINTS = "constraints";
    public static final String AABB = "aabb";
    public static final String COLORSTART = "colorStart";
    public static final String COLOREND = "colorEnd";
    public static final String ALPHASTART = "alphaStart";
    public static final String ALPHAEND = "alphaEnd";
    public static final String SIZESTART = "sizeStart";
    public static final String SIZEEND = "sizeEnd";
    public static final String SIZESTART_Y = "sizeStart_y";
    public static final String SIZESEND_Y = "sizeEnd_y";
    public static final String FRAMESTART = "frameStart";
    public static final String FRAMEEND = "frameEnd";
    public static final String BIRTHRATE = "birthrate";
    public static final String LIFEEXP = "lifeExp";
    public static final String MASS = "mass";
    public static final String SPREAD = "spread";
    public static final String VELOCITY = "velocity";
    public static final String RANDVEL = "randvel";
    public static final String FPS = "fps";
    public static final String BLEND = "Blend";
    public static final String TEXTURE = "texture";
    public static final String XGRID = "xgrid";
    public static final String YGRID = "ygrid";
    public static final String PARTICLEROT = "particleRot";
    public static final String XSIZE = "xsize";
    public static final String YSIZE = "ysize";
    public static final String RENDER = "render";
    public static final String P2P_TYPE = "p2p_type";
    public static final String DRAG = "drag";
    public static final String GRAV = "grav";
    public static final String INHERIT = "inherit";
    public static final String INHERIT_LOCAL = "inherit_local";
    public static final String INHERIT_PART = "inherit_part";
    public static final String UPDATE = "update";
    public static final String BIRTHRATEKEY = "birthratekey";

    public ManualParser() {
    }

    public ManualParser(InputStream inputStream) {
        this.reinit(inputStream);
    }

    public ManualParser reinit(InputStream inputStream) {
        this.index = 0;
        this.limit = 0;
        this.slimit = 0;
        this.line = 1;
        boolean bl = false;
        this.reader = inputStream;
        return this;
    }

    private void fillBuffer() {
        try {
            System.arraycopy(this.buf, this.index, this.buf, 0, this.limit - this.index);
            int n = this.reader.read(this.buf, this.limit - this.index, 4096 - this.limit);
            if (n < 0) {
                this.reader = null;
                this.limit -= this.index;
                this.index = 0;
            } else {
                this.limit = this.limit - this.index + n;
                this.index = 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.reader = null;
        }
    }

    public void fillSymbol() {
        byte by;
        if (this.limit - this.index < 256 && this.reader != null) {
            this.fillBuffer();
        }
        this.slimit = 0;
        while (whitespace[by = this.buf[this.index]]) {
            if (by == 10) {
                ++this.line;
            }
            ++this.index;
        }
        if (this.buf[this.index] == 35) {
            while (this.buf[this.index] != 10) {
                ++this.index;
            }
            this.fillSymbol();
            return;
        }
        while (!whitespace[by = this.buf[this.index]]) {
            this.symbol[this.slimit] = (char)by;
            ++this.index;
            ++this.slimit;
        }
    }

    public boolean isSymbol(String string) {
        if (this.slimit != string.length()) {
            return false;
        }
        for (int i = 0; i < this.slimit; ++i) {
            if (string.charAt(i) == this.symbol[i]) continue;
            return false;
        }
        return true;
    }

    public void readSymbol(String string) {
        this.fillSymbol();
        this.assertSymbol(string);
    }

    public void assertSymbol(String string) {
        if (!this.isSymbol(string)) {
            throw new RuntimeException("Expected " + string + " got " + this.getString() + " at line " + this.line);
        }
    }

    public void unexpectedToken() {
        throw new RuntimeException("Unexpected token " + this.getString() + " at line " + this.line);
    }

    public void check(boolean bl, String string) {
        if (!bl) {
            System.err.println("WARN: Line " + this.line + ":" + string);
        }
    }

    public void checkId(String string, String string2) {
        if (!string.equalsIgnoreCase(string2)) {
            System.err.println("WARN: Line " + this.line + ":" + " Identifier mismatch - expected '" + string + "' got '" + string2 + "' ");
        }
    }

    public float getFloat() {
        char c;
        float f = 0.0f;
        int n = 1;
        char[] cArray = this.symbol;
        int n2 = this.slimit;
        int n3 = 0;
        int n4 = 0;
        if (cArray[0] == '-') {
            n = -1;
            ++n3;
        } else if (cArray[0] == '+') {
            ++n3;
        }
        while (n3 < n2 && (c = cArray[n3]) != '.') {
            n4 = n4 * 10 + (c - 48);
            ++n3;
        }
        ++n3;
        f = n4;
        float f2 = 10.0f;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (c2 == 'e' || c2 == 'E') {
                n4 = 0;
                int n5 = 1;
                if (cArray[++n3] == '-') {
                    n5 = -1;
                    ++n3;
                } else if (cArray[n3] == '+') {
                    ++n3;
                }
                while (n3 < n2) {
                    c2 = cArray[n3];
                    n4 = n4 * 10 + (c2 - 48);
                    ++n3;
                }
                f = (float)((double)f * Math.pow(10.0, n4 * n5));
                break;
            }
            f += (float)(c2 - 48) / f2;
            f2 *= 10.0f;
            ++n3;
        }
        return f * (float)n;
    }

    public float readFloat() {
        this.fillSymbol();
        return this.getFloat();
    }

    public int getInt() {
        int n = 1;
        char[] cArray = this.symbol;
        int n2 = this.slimit;
        int n3 = 0;
        int n4 = 0;
        if (cArray[0] == '-') {
            n = -1;
            ++n3;
        } else if (cArray[0] == '+') {
            ++n3;
        }
        while (n3 < n2) {
            char c = cArray[n3];
            n4 = n4 * 10 + (c - 48);
            ++n3;
        }
        return n4;
    }

    public int readInt() {
        this.fillSymbol();
        return this.getInt();
    }

    public String getString() {
        if (internStrings) {
            return new String(this.symbol, 0, this.slimit).intern();
        }
        return new String(this.symbol, 0, this.slimit);
    }

    public String readString() {
        this.fillSymbol();
        return this.getString();
    }

    public Point3f readPoint() {
        return new Point3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public Vector3f readVector() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public Color3f readColor() {
        return new Color3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public AxisAngle4f readAxisa() {
        return new AxisAngle4f(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
    }

    public Model definition() {
        while (true) {
            this.fillSymbol();
            if (!this.isSymbol(FILEDEPENDANCY)) break;
            this.readString();
        }
        this.assertSymbol(NEWMODEL);
        Model model = new Model(this.readString());
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(DONEMODEL)) break;
            if (this.isSymbol(SETSUPERMODEL)) {
                this.checkId(model.getName(), this.readString());
                model.setSupermodelName(this.readString());
                continue;
            }
            if (this.isSymbol(SETANIMATIONSCALE)) {
                model.setAnimationScale(this.readFloat());
                continue;
            }
            if (this.isSymbol(CLASSIFICATION)) {
                model.setClassification(this.readString());
                continue;
            }
            if (this.isSymbol(BEGINMODELGEOM)) {
                model.setModelGeometry(this.modelGeometry());
                continue;
            }
            if (this.isSymbol(NEWANIM)) {
                model.addModelAnimation(this.modelAnimation());
                continue;
            }
            this.unexpectedToken();
        }
        this.checkId(model.getName(), this.readString());
        return model;
    }

    public GeomNode modelGeometry() {
        String string = this.readString();
        GeomNode geomNode = null;
        HashMap<String, GeomNode> hashMap = new HashMap<String, GeomNode>();
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(ENDMODELGEOM)) break;
            if (this.isSymbol(NODE)) {
                GeomNode geomNode2 = this.geomNode(hashMap);
                hashMap.put(geomNode2.getName(), geomNode2);
                if (geomNode2.getSupernode() != null) continue;
                geomNode = geomNode2;
                continue;
            }
            this.unexpectedToken();
        }
        this.checkId(string, this.readString());
        return geomNode;
    }

    public GeomNode geomNode(Map map) {
        DummyGeomNode dummyGeomNode = null;
        TrimeshGeomNode trimeshGeomNode = null;
        EmitterNode emitterNode = null;
        DanglymeshGeomNode danglymeshGeomNode = null;
        AabbGeomNode aabbGeomNode = null;
        boolean bl = false;
        String string = this.readString();
        String string2 = this.readString();
        this.readSymbol(PARENT);
        String string3 = this.readString();
        GeomNode geomNode = null;
        if (!string3.equalsIgnoreCase("NULL") && (geomNode = (GeomNode)map.get(string3.toLowerCase())) == null) {
            this.check(geomNode != null, "Cannot find supernode " + geomNode);
        }
        if (string.equals("trimesh")) {
            trimeshGeomNode = new TrimeshGeomNode(geomNode);
            dummyGeomNode = trimeshGeomNode;
        } else if (string.equals("danglymesh")) {
            danglymeshGeomNode = new DanglymeshGeomNode(geomNode);
            trimeshGeomNode = danglymeshGeomNode;
            dummyGeomNode = trimeshGeomNode;
        } else if (string.equals(AABB)) {
            aabbGeomNode = new AabbGeomNode(geomNode);
            trimeshGeomNode = aabbGeomNode;
            dummyGeomNode = aabbGeomNode;
        } else if (string.equals("dummy") || string.equals("patch")) {
            dummyGeomNode = new DummyGeomNode(geomNode);
        } else if (string.equals("emitter")) {
            emitterNode = new EmitterNode(geomNode);
            dummyGeomNode = emitterNode;
        } else if (string.equals("reference") || string.equals("light") || string.equals(AABB)) {
            System.err.println("Ignoring node " + string);
            dummyGeomNode = new DummyGeomNode(geomNode);
            bl = true;
        } else {
            throw new RuntimeException("Unsupported node " + string);
        }
        dummyGeomNode.setName(string2);
        if (geomNode != null) {
            geomNode.addChild(dummyGeomNode);
        }
        this.fillSymbol();
        while (!this.isSymbol(ENDNODE)) {
            if (this.isSymbol(POSITION)) {
                dummyGeomNode.setPosition(this.readVector());
            } else if (this.isSymbol(ORIENTATION)) {
                dummyGeomNode.setOrientation(this.readAxisa());
            } else if (this.isSymbol(WIRECOLOR)) {
                dummyGeomNode.setWirecolor(this.readColor());
            } else if (this.isSymbol(SCALE)) {
                dummyGeomNode.setScale(this.readFloat());
            } else if (trimeshGeomNode != null) {
                if (this.isSymbol(AMBIENT)) {
                    trimeshGeomNode.setAmbient(this.readColor());
                } else if (this.isSymbol(DIFFUSE)) {
                    trimeshGeomNode.setDiffuse(this.readColor());
                } else if (this.isSymbol(SPECULAR)) {
                    trimeshGeomNode.setSpecular(this.readColor());
                } else if (this.isSymbol(SHININESS)) {
                    trimeshGeomNode.setShininess(this.readFloat());
                } else if (this.isSymbol(SELFILLUMCOLOR)) {
                    trimeshGeomNode.setEmissive(this.readColor());
                } else if (this.isSymbol(BITMAP)) {
                    trimeshGeomNode.setBitmap(this.readString());
                } else if (this.isSymbol(ALPHA)) {
                    trimeshGeomNode.setAlpha(this.readFloat());
                } else if (this.isSymbol(VERTS)) {
                    this.vertList(trimeshGeomNode, this.readInt());
                } else if (this.isSymbol(FACES)) {
                    this.faceList(trimeshGeomNode, this.readInt());
                } else if (this.isSymbol(TVERTS)) {
                    this.tvertList(trimeshGeomNode, this.readInt());
                } else if (this.isSymbol(COLORS)) {
                    this.colorsList(trimeshGeomNode, this.readInt());
                } else if (danglymeshGeomNode != null) {
                    if (this.isSymbol(CONSTRAINTS)) {
                        this.constraintsList(danglymeshGeomNode, this.readInt());
                    } else {
                        System.err.println("Ignoring " + this.getString());
                    }
                } else if (aabbGeomNode != null) {
                    if (this.isSymbol(AABB)) {
                        this.aabbList(aabbGeomNode);
                        continue;
                    }
                    System.err.println("Ignoring " + this.getString());
                } else {
                    System.err.println("Ignoring " + this.getString());
                }
            } else if (emitterNode != null) {
                if (this.isSymbol(COLORSTART)) {
                    emitterNode.setColorStart(this.readColor());
                } else if (this.isSymbol(COLOREND)) {
                    emitterNode.setColorEnd(this.readColor());
                } else if (this.isSymbol(ALPHASTART)) {
                    emitterNode.setAlphaStart(this.readFloat());
                } else if (this.isSymbol(ALPHAEND)) {
                    emitterNode.setAlphaEnd(this.readFloat());
                } else if (this.isSymbol(SIZESTART)) {
                    emitterNode.setSizeStart(this.readFloat());
                } else if (this.isSymbol(SIZEEND)) {
                    emitterNode.setSizeEnd(this.readFloat());
                } else if (this.isSymbol(SIZESTART_Y)) {
                    emitterNode.setSizeStart_y(this.readFloat());
                } else if (this.isSymbol(SIZESEND_Y)) {
                    emitterNode.setSizeEnd_y(this.readFloat());
                } else if (this.isSymbol(FRAMESTART)) {
                    emitterNode.setFrameStart(this.readInt());
                } else if (this.isSymbol(FRAMEEND)) {
                    emitterNode.setFrameEnd(this.readInt());
                } else if (this.isSymbol(BIRTHRATE)) {
                    emitterNode.setBirthrate(this.readFloat());
                } else if (this.isSymbol(LIFEEXP)) {
                    emitterNode.setLifeExp(this.readFloat());
                } else if (this.isSymbol(MASS)) {
                    emitterNode.setMass(this.readFloat());
                } else if (this.isSymbol(SPREAD)) {
                    emitterNode.setSpread(this.readFloat());
                } else if (this.isSymbol(VELOCITY)) {
                    emitterNode.setVelocity(this.readFloat());
                } else if (this.isSymbol(FPS)) {
                    emitterNode.setFps(this.readFloat());
                } else if (this.isSymbol(RANDVEL)) {
                    emitterNode.setRandvel(this.readFloat());
                } else if (this.isSymbol(BLEND)) {
                    emitterNode.setBlend(this.readString());
                } else if (this.isSymbol(TEXTURE)) {
                    emitterNode.setTexture(this.readString());
                } else if (this.isSymbol(XGRID)) {
                    emitterNode.setXgrid(this.readInt());
                } else if (this.isSymbol(YGRID)) {
                    emitterNode.setYgrid(this.readInt());
                } else if (this.isSymbol(PARTICLEROT)) {
                    emitterNode.setParticleRot(this.readFloat());
                } else if (this.isSymbol(XSIZE)) {
                    emitterNode.setXsize(this.readFloat());
                } else if (this.isSymbol(YSIZE)) {
                    emitterNode.setYsize(this.readFloat());
                } else if (this.isSymbol(RENDER)) {
                    emitterNode.setRender(this.readString());
                } else if (this.isSymbol(P2P_TYPE)) {
                    emitterNode.setP2pType(this.readString());
                } else if (this.isSymbol(DRAG)) {
                    emitterNode.setDrag(this.readFloat());
                } else if (this.isSymbol(GRAV)) {
                    emitterNode.setGrav(this.readFloat());
                } else if (this.isSymbol(INHERIT)) {
                    emitterNode.setInherit(this.readInt());
                } else if (this.isSymbol(INHERIT_LOCAL)) {
                    emitterNode.setInherit_local(this.readInt());
                } else if (this.isSymbol(INHERIT_PART)) {
                    emitterNode.setInherit_part(this.readInt());
                } else if (this.isSymbol(UPDATE)) {
                    emitterNode.setUpdate(this.readString());
                } else {
                    System.err.println("Ignoring " + this.getString());
                }
            } else if (bl) {
                System.err.print(this.getString() + " ");
            } else {
                this.unexpectedToken();
            }
            this.fillSymbol();
        }
        return dummyGeomNode;
    }

    public void vertList(TrimeshGeomNode trimeshGeomNode, int n) {
        while (n-- > 0) {
            trimeshGeomNode.addVert(this.readPoint());
        }
    }

    public void tvertList(TrimeshGeomNode trimeshGeomNode, int n) {
        while (n-- > 0) {
            trimeshGeomNode.addTvert(new TexCoord2f(this.readFloat(), this.readFloat()));
            this.fillSymbol();
        }
    }

    public void colorsList(TrimeshGeomNode trimeshGeomNode, int n) {
        while (n-- > 0) {
            trimeshGeomNode.addColor(this.readColor());
        }
    }

    public void faceList(TrimeshGeomNode trimeshGeomNode, int n) {
        while (n-- > 0) {
            trimeshGeomNode.addFace(this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readInt());
        }
    }

    public void constraintsList(DanglymeshGeomNode danglymeshGeomNode, int n) {
        while (n-- > 0) {
            danglymeshGeomNode.addConstraint(this.readFloat());
        }
    }

    public void aabbList(AabbGeomNode aabbGeomNode) {
        while (true) {
            this.fillSymbol();
            if (Character.isLetter(this.symbol[0])) {
                return;
            }
            aabbGeomNode.addAabbEntry(this.getFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readInt());
        }
    }

    public ModelAnimation modelAnimation() {
        String string = this.readString();
        String string2 = this.readString();
        ModelAnimation modelAnimation = new ModelAnimation(string, string2);
        this.readSymbol(LENGTH);
        modelAnimation.setLength(this.readFloat());
        this.readSymbol(TRANSTIME);
        modelAnimation.setTransTime(this.readFloat());
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(DONEANIM)) break;
            if (this.isSymbol(ANIMROOT)) {
                this.readString();
                continue;
            }
            if (this.isSymbol(NODE)) {
                AnimNode animNode = this.animNode();
                modelAnimation.addNode(animNode);
                continue;
            }
            if (this.isSymbol(EVENT)) {
                this.readFloat();
                this.readString();
                continue;
            }
            this.unexpectedToken();
        }
        this.readString();
        this.readString();
        return modelAnimation;
    }

    public AnimNode animNode() {
        AnimNode animNode;
        String string = this.readString();
        String string2 = this.readString();
        AnimEmitterNode animEmitterNode = null;
        if (string.equals("emitter")) {
            animEmitterNode = new AnimEmitterNode(string2);
            animNode = animEmitterNode;
        } else if (string.equals("dummy") || string.equals("trimesh")) {
            animNode = new AnimNode(string2);
        } else {
            this.check(false, "Unknown anim node type " + string);
            animNode = new AnimNode(string2);
        }
        this.readSymbol(PARENT);
        animNode.setParent(this.readString());
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(ENDNODE)) break;
            if (this.isSymbol(POSITIONKEY)) {
                this.pklist(animNode);
                continue;
            }
            if (this.isSymbol(ORIENTATIONKEY)) {
                this.oklist(animNode);
                continue;
            }
            if (animEmitterNode != null) {
                if (!this.isSymbol(BIRTHRATEKEY)) continue;
                this.singleFloatList(animEmitterNode.getBirthratekeyList());
                continue;
            }
            this.check(false, "Unknown animnode component " + this.getString());
        }
        animNode.trimSlack();
        return animNode;
    }

    public void pklist(AnimNode animNode) {
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(ENDLIST)) break;
            this.kv.setKey(this.getFloat());
            this.kv.set(this.readFloat(), this.readFloat(), this.readFloat());
            animNode.addPositionKey(this.kv);
        }
    }

    public void oklist(AnimNode animNode) {
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(ENDLIST)) break;
            animNode.addOrientationKey(this.getFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
        }
    }

    public void singleFloatList(List list) {
        while (true) {
            this.fillSymbol();
            if (this.isSymbol(ENDLIST)) break;
            float f = this.getFloat();
            list.add(new KeyFloat(this.readFloat(), f));
        }
    }

    static {
        ManualParser.whitespace[10] = true;
        ManualParser.whitespace[13] = true;
        ManualParser.whitespace[9] = true;
        ManualParser.whitespace[32] = true;
        sharedParser = new ManualParser();
        internStrings = true;
    }
}

