/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md2.MD2GLCommands;
import org.newdawn.j3d.loaders.md2.MD2Header;

public class MD2GLCommandList {
    private ArrayList setList = new ArrayList();

    public MD2GLCommandList(byte[] b, MD2Header header) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(new ByteArrayInputStream(b)));
        in.skip(header.getGLCommandsOffset());
        boolean finishedCommands = false;
        while (!finishedCommands) {
            int i = in.readInt();
            if (i == 0) {
                finishedCommands = true;
                continue;
            }
            MD2GLCommands commands = new MD2GLCommands(in, i);
            this.setList.add(commands);
        }
    }

    public int getCommandSetCount() {
        return this.setList.size();
    }

    public MD2GLCommands getCommandSet(int i) {
        return (MD2GLCommands)this.setList.get(i);
    }
}

