/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.io.IOException;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md3.MD3Mesh;

public class MD3MeshFrame {
    public static final double SCALE = 0.015625;
    private double[][] verts;
    private byte[][] env;
    private MD3Mesh mesh;

    public MD3MeshFrame(MD3Mesh mesh, LittleEndianDataInputStream in) throws IOException {
        int vertexNum = mesh.getVertexNum();
        this.mesh = mesh;
        this.verts = new double[vertexNum][3];
        this.env = new byte[vertexNum][2];
        int i = 0;
        while (i < vertexNum) {
            this.verts[i][0] = (double)in.readShort() * 0.015625;
            this.verts[i][1] = (double)in.readShort() * 0.015625;
            this.verts[i][2] = (double)in.readShort() * 0.015625;
            this.env[i][0] = in.readByte();
            this.env[i][1] = in.readByte();
            ++i;
        }
    }

    public void render(TriangleArray array, int[][] tris, float[][] uv) {
        int count = this.mesh.getTriangleCount();
        int i = 0;
        while (i < count) {
            if (tris[i][0] <= 10000 && tris[i][1] <= 10000 && tris[i][2] <= 10000) {
                array.setCoordinate(i * 3 + 2, new Point3d(this.verts[tris[i][0]][0], this.verts[tris[i][0]][1], this.verts[tris[i][0]][2]));
                array.setTextureCoordinate(i * 3 + 2, new Point2f(uv[tris[i][0]][0], -uv[tris[i][0]][1]));
                array.setCoordinate(i * 3 + 1, new Point3d(this.verts[tris[i][1]][0], this.verts[tris[i][1]][1], this.verts[tris[i][1]][2]));
                array.setTextureCoordinate(i * 3 + 1, new Point2f(uv[tris[i][1]][0], -uv[tris[i][1]][1]));
                array.setCoordinate(i * 3, new Point3d(this.verts[tris[i][2]][0], this.verts[tris[i][2]][1], this.verts[tris[i][2]][2]));
                array.setTextureCoordinate(i * 3, new Point2f(uv[tris[i][2]][0], -uv[tris[i][2]][1]));
            }
            ++i;
        }
    }

    static {
        SCALE = 0.015625;
    }
}

