package jp.sourceforge.acerola3d.a3editor;

import jp.sourceforge.acerola3d.a3.*;
import java.net.URL;
import javax.media.j3d.*;
import javax.vecmath.*;

/**
 * 回転の操作をした時に、素直に回転してくれるように物体の中心が
 * オブジェクトの中心となるように移動させて表示するVRML表示用
 * オブジェクト。
 */
public class CenteredVRML extends A3Object {
    //以下のoffsetはもともとのVRMLをスケールと回転の変更無しで考えた時に
    //どう移動すれば物体の中心を原点にもってこれるかを示すベクトル
    Vector3d offset;
    public CenteredVRML(String url) throws Exception {
        super(new A3InitData("jp.sourceforge.acerola3d.a3editor.CenteredVRML"));

        offset = new Vector3d();
        URL u = new URL(url);
        Node n = Util.loadVRML_B(u);
        Bounds b = n.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            offset.set(p);
            offset.scale(-1.0);
            //offset.set(0.0,0.0,0.0);//gaha
        } else {
            offset.set(0.0,0.0,0.0);
        }

        Transform3D t = new Transform3D();
        t.set(offset);
        TransformGroup tg = new TransformGroup(t);
        tg.addChild(n);

        setNode(tg);
    }
    /**
     * 物体の位置を指定するためのメソッドだけど、物体の中心ではなく、
     * もともとのVRMLの原点を指定の座標に移動させるメソッド。
     * スケールや回転を設定してから、このメソッドを使わないと
     * 計算があわなくなります。
     */
    public void setLoc2(double x,double y,double z) {
        setLoc2(new Vector3d(x,y,z));
    }
    /**
     * 物体の位置を指定するためのメソッドだけど、物体の中心ではなく、
     * もともとのVRMLの原点を指定の座標に移動させるメソッド。
     * スケールや回転を設定してから、このメソッドを使わないと
     * 計算があわなくなります。
     */
    public void setLoc2(Vector3d v) {
        Vector3d vv = new Vector3d(offset);
        Quat4d q = getQuat();
        vv = Util.trans(q,vv);
        vv.scale(-1.0*getScale());
        vv.add(v);
        setLoc(vv);
    }
    /**
     * 物体の位置を取得するためのメソッドだけど、物体の中心ではなく、
     * もともとのVRMLの原点の座標を取得するメソッド。
     * このオブジェクトに設定されている現在のスケールや回転の
     * 値をもとに計算されます。
     */
    public Vector3d getLoc2() {
        Vector3d v = new Vector3d(offset);
        Quat4d q = getQuat();
        v = Util.trans(q,v);
        v.scale(getScale());
        v.add(getLoc());
        return v;
    }
}
