/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Point3f;
import org.newdawn.j3d.loaders.bsp.BSPHeader;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;

public class BSPVertexLump {
    private float[][] verts;

    public BSPVertexLump(BSPHeader header, InputStream file) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(file));
        int len = header.getLength(2);
        this.verts = new float[3][len / 12];
        int offset = header.getOffset(2);
        in.skip(offset);
        int i = 0;
        while (i < this.verts[0].length) {
            this.verts[0][i] = -in.readFloat();
            this.verts[2][i] = in.readFloat();
            this.verts[1][i] = in.readFloat();
            ++i;
        }
        in.close();
    }

    public Point3f getPoint(int i) {
        return new Point3f(this.verts[0][i], this.verts[1][i], this.verts[2][i]);
    }
}

