/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import com.sun.j3d.utils.image.TextureLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import org.newdawn.j3d.loaders.DefaultNodeFactory;
import org.newdawn.j3d.loaders.ModelLoadingException;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.cio.ByteArrayBuilder;
import org.newdawn.j3d.loaders.md2.MD2Frame;
import org.newdawn.j3d.loaders.md2.MD2Frames;
import org.newdawn.j3d.loaders.md2.MD2GLCommand;
import org.newdawn.j3d.loaders.md2.MD2GLCommandList;
import org.newdawn.j3d.loaders.md2.MD2GLCommands;
import org.newdawn.j3d.loaders.md2.MD2Header;
import org.newdawn.j3d.loaders.md2.MD2Model;
import org.newdawn.j3d.loaders.md2.MD2RenderedFrame;
import org.newdawn.j3d.loaders.pcx.PCXLoader;

public class MD2Loader {
    public MD2Model loadWithPCX(String f, String texture) throws ModelLoadingException {
        return this.loadWithPCX(f, texture, (NodeFactory)new DefaultNodeFactory());
    }

    public MD2Model loadWithPCX(String f, String texture, NodeFactory nodeFactory, ArrayList filter) throws ModelLoadingException {
        return this.loadWithPCX(ClassLoader.getSystemResourceAsStream(f), ClassLoader.getSystemResourceAsStream(texture), nodeFactory, filter);
    }

    public MD2Model loadWithPCX(String f, String texture, NodeFactory nodeFactory) throws ModelLoadingException {
        return this.loadWithPCX(ClassLoader.getSystemResourceAsStream(f), ClassLoader.getSystemResourceAsStream(texture), nodeFactory);
    }

    public MD2Model loadWithPCX(InputStream f, InputStream texture) throws ModelLoadingException {
        return this.loadWithPCX(f, texture, (NodeFactory)new DefaultNodeFactory());
    }

    public MD2Model loadWithPCX(InputStream f, InputStream texture, NodeFactory factory) throws ModelLoadingException {
        return this.loadWithPCX(f, texture, factory, null);
    }

    public MD2Model loadWithPCX(InputStream f, InputStream texture, NodeFactory factory, ArrayList filter) throws ModelLoadingException {
        Appearance app = new Appearance();
        boolean yup = false;
        try {
            Texture tex = new PCXLoader(texture).getTexture(yup);
            app.setTexture(tex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            byte[] b = ByteArrayBuilder.fromStream(f);
            f.close();
            MD2Header header = new MD2Header(b);
            MD2Frames frames = new MD2Frames(b, header);
            MD2GLCommandList list = new MD2GLCommandList(b, header);
            int frameCount = header.getFrameCount();
            MD2RenderedFrame[] rendered = new MD2RenderedFrame[frameCount];
            int i = 0;
            while (i < frameCount) {
                if (this.validFrame(frames.getFrame(i).getName(), filter) || i == 0) {
                    rendered[i] = this.render(frames.getFrame(i), list, app, factory);
                }
                ++i;
            }
            return new MD2Model(rendered);
        }
        catch (IOException e) {
            throw new ModelLoadingException(e.getMessage());
        }
    }

    private boolean validFrame(String frameName, ArrayList filter) {
        if (filter == null) {
            return true;
        }
        int i = 0;
        while (i < filter.size()) {
            String f = (String)filter.get(i);
            if (frameName.startsWith(f)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MD2Model load(String f, String texture) throws ModelLoadingException {
        return this.load(f, texture, new DefaultNodeFactory());
    }

    public MD2Model load(String f, String texture, ArrayList filter) throws ModelLoadingException {
        return this.load(ClassLoader.getSystemResourceAsStream(f), ClassLoader.getSystemResource(texture), new DefaultNodeFactory(), filter);
    }

    public MD2Model load(String f, String texture, NodeFactory nodeFactory) throws ModelLoadingException {
        return this.load(ClassLoader.getSystemResourceAsStream(f), ClassLoader.getSystemResource(texture), nodeFactory, null);
    }

    public MD2Model load(InputStream f, URL texture) throws ModelLoadingException {
        return this.load(f, texture, new DefaultNodeFactory(), null);
    }

    public MD2Model load(InputStream f, URL texture, NodeFactory factory, ArrayList filter) throws ModelLoadingException {
        Appearance app = new Appearance();
        try {
            if (texture == null) {
                throw new ModelLoadingException("Skin not found, check class path.");
            }
            Texture tex = new TextureLoader(texture, "RGBA", null).getTexture();
            app.setTexture(tex);
            byte[] b = ByteArrayBuilder.fromStream(f);
            f.close();
            MD2Header header = new MD2Header(b);
            MD2Frames frames = new MD2Frames(b, header);
            MD2GLCommandList list = new MD2GLCommandList(b, header);
            int frameCount = header.getFrameCount();
            MD2RenderedFrame[] rendered = new MD2RenderedFrame[frameCount];
            int i = 0;
            while (i < frameCount) {
                if (this.validFrame(frames.getFrame(i).getName(), filter) || i == 0) {
                    rendered[i] = this.render(frames.getFrame(i), list, app, factory);
                }
                ++i;
            }
            return new MD2Model(rendered);
        }
        catch (Exception e) {
            throw new ModelLoadingException(e.getMessage());
        }
    }

    private MD2RenderedFrame render(MD2Frame frame, MD2GLCommandList commandList, Appearance app, NodeFactory factory) {
        BranchGroup group = new BranchGroup();
        int format = 35;
        int stripCount = 0;
        int stripVertexCount = 0;
        int fanCount = 0;
        int fanVertexCount = 0;
        int i = 0;
        while (i < commandList.getCommandSetCount()) {
            MD2GLCommands commands = commandList.getCommandSet(i);
            if (commands.getType() == 1) {
                stripVertexCount += commands.getCount();
                ++stripCount;
            }
            if (commands.getType() == 2) {
                fanVertexCount += commands.getCount();
                ++fanCount;
            }
            ++i;
        }
        int[] stripCounts = new int[stripCount];
        int stripIndex = 0;
        int[] fanCounts = new int[fanCount];
        int fanIndex = 0;
        int i2 = 0;
        while (i2 < commandList.getCommandSetCount()) {
            MD2GLCommands commands = commandList.getCommandSet(i2);
            if (commands.getType() == 1) {
                stripCounts[stripIndex] = commands.getCount();
                ++stripIndex;
            }
            if (commands.getType() == 2) {
                fanCounts[fanIndex] = commands.getCount();
                ++fanIndex;
            }
            ++i2;
        }
        TriangleStripArray stripArray = new TriangleStripArray(stripVertexCount, format, stripCounts);
        stripIndex = 0;
        TriangleFanArray fanArray = new TriangleFanArray(fanVertexCount, format, fanCounts);
        fanIndex = 0;
        int i3 = 0;
        while (i3 < commandList.getCommandSetCount()) {
            MD2GLCommand command;
            int j;
            int[] vertCounts;
            MD2GLCommands commands = commandList.getCommandSet(i3);
            if (commands.getType() == 1) {
                vertCounts = new int[]{commands.getCount()};
                j = 0;
                while (j < commands.getCount()) {
                    command = commands.getCommand(j);
                    stripArray.setCoordinate(stripIndex, frame.getVertex(command.getVertexIndex()).getFloats());
                    stripArray.setTextureCoordinate(stripIndex, command.getTextureCoordinates());
                    ++stripIndex;
                    ++j;
                }
            }
            if (commands.getType() == 2) {
                vertCounts = new int[]{commands.getCount()};
                j = 0;
                while (j < commands.getCount()) {
                    command = commands.getCommand(j);
                    fanArray.setCoordinate(fanIndex, frame.getVertex(command.getVertexIndex()).getFloats());
                    fanArray.setTextureCoordinate(fanIndex, command.getTextureCoordinates());
                    ++fanIndex;
                    ++j;
                }
            }
            ++i3;
        }
        return new MD2RenderedFrame(frame.getName(), fanArray, stripArray, app, factory);
    }
}

