/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.pak;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.pak.PAKHeader;

public class PAKListing {
    private HashMap map = new HashMap();

    public PAKListing(PAKHeader header, File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        byte[] data = new byte[header.getListingLength()];
        fin.skip(header.getListingOffset());
        fin.read(data);
        fin.close();
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
        int i = 0;
        while (i < header.getListingLength() / 64) {
            this.readFileIndex(in);
            ++i;
        }
        in.close();
    }

    private void readFileIndex(LittleEndianDataInputStream in) throws IOException {
        byte[] name = new byte[56];
        in.read(name);
        int i = 0;
        while (i < 56) {
            if (name[i] == 0) break;
            ++i;
        }
        String filename = new String(name, 0, i);
        FileIndex index = new FileIndex(in.readInt(), in.readInt());
        this.map.put(filename, index);
    }

    public int getFileOffset(String name) {
        FileIndex index = (FileIndex)this.map.get(name);
        if (index != null) {
            return index.offset;
        }
        return -1;
    }

    public int getFileLength(String name) {
        FileIndex index = (FileIndex)this.map.get(name);
        if (index != null) {
            return index.length;
        }
        return -1;
    }

    private class FileIndex {
        public int offset;
        public int length;

        public FileIndex(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

