/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.chunks;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import javax.vecmath.Color3f;

public class ColorChunk
extends Chunk {
    protected int currentColorType;
    private static final int FLOAT_COLOR = 16;
    private static final int BYTE_COLOR = 17;
    private static final int BYTE_COLOR_GAMMA = 18;
    private static final int FLOAT_COLOR_GAMMA = 19;

    public void loadData(ChunkChopper chopper) {
        int colorType = this.getColorType(chopper);
        if (colorType == 17) {
            float r = (float)chopper.getUnsignedByte() / 255.0f;
            float g = (float)chopper.getUnsignedByte() / 255.0f;
            float b = (float)chopper.getUnsignedByte() / 255.0f;
            Color3f color = new Color3f(r, g, b);
            chopper.pushData(chopper.getID(), color);
        } else if (colorType == 16) {
            Color3f color = new Color3f(chopper.getFloat(), chopper.getFloat(), chopper.getFloat());
            chopper.pushData(chopper.getID(), color);
        } else {
            throw new IllegalArgumentException("Only RGB colors are enabled. ChunkID=" + Integer.toHexString((byte)chopper.getID().intValue()) + " Color type = " + Integer.toHexString((byte)colorType));
        }
    }

    protected int getColorType(ChunkChopper chopper) {
        return chopper.getID();
    }
}

