/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import a3vrml.BaseNode;
import a3vrml.InvalidVRMLSyntaxException;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import org.jdesktop.j3d.loaders.vrml97.impl.BindableNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFColor;
import org.jdesktop.j3d.loaders.vrml97.impl.MFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.MFString;
import org.jdesktop.j3d.loaders.vrml97.impl.RGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFTime;

public class Background
extends BindableNode {
    MFFloat groundAngle;
    MFColor groundColor;
    MFString backUrl;
    MFString bottomUrl;
    MFString frontUrl;
    MFString leftUrl;
    MFString rightUrl;
    MFString topUrl;
    MFFloat skyAngle;
    MFColor skyColor;
    double[] thetas = new double[]{0.0, 0.2526477262845635, 0.3582612185126168, 0.4399759547909189, 0.509443848811893, 0.5711684985655375, 0.6274557729231908, 0.6796738189082439, 0.7287134507434055, 0.7751933733103613, 0.8195643276682608, 0.8621670552325126, 0.9032668821590636, 0.9430755091369839, 0.9817653565786227, 1.019479357663014, 1.0563378512337098, 1.092443562145639, 1.1278852827212575, 1.162740649493618, 1.1970782758519827, 1.2309594173407747, 1.2644392922379775, 1.2975681442542588, 1.3303921100256373, 1.3629539374415498, 1.3952935892191738, 1.4274487578895312, 1.4594553124539327, 1.4913476927097593, 1.5231592641704934, 1.5549226443049409, 1.5866700092848522, 1.6184333894192997, 1.6502449608800338, 1.6821373411358607, 1.714143895700262, 1.7462990643706193, 1.7786387161482433, 1.811200543564156, 1.8440245093355343, 1.8771533613518159, 1.9106332362490184, 1.9445143777378107, 1.978852004096175, 2.0137073708685356, 2.0491490914441544, 2.0852548023560833, 2.122113295926779, 2.1598272970111703, 2.198517144452809, 2.2383257714307296, 2.2794255983572804, 2.3220283259215324, 2.366399280279432, 2.412879202846388, 2.461918834681549, 2.5141368806666025, 2.5704241550242557, 2.6321488047779003, 2.7016166987988743, 2.7833314350771765, 2.8889449273052294, Math.PI};
    private static final boolean GROUND = true;
    private static final boolean SKY = false;
    BranchGroup backgroundImpl;
    javax.media.j3d.Background background;
    Bounds bound;

    public Background(Loader loader) {
        super(loader, loader.getBackgroundStack());
        this.groundAngle = new MFFloat();
        this.groundColor = new MFColor();
        this.backUrl = new MFString();
        this.bottomUrl = new MFString();
        this.frontUrl = new MFString();
        this.leftUrl = new MFString();
        this.rightUrl = new MFString();
        this.topUrl = new MFString();
        this.skyAngle = new MFFloat();
        float[] color = new float[]{0.3f, 0.3f, 0.3f};
        this.skyColor = new MFColor(color);
        loader.addBackground(this);
        this.initFields();
    }

    public Background(Loader loader, SFBool bind, SFTime bindTime, SFBool isBound, MFFloat groundAngle, MFColor groundColor, MFString backUrl, MFString bottomUrl, MFString frontUrl, MFString leftUrl, MFString rightUrl, MFString topUrl, MFFloat skyAngle, MFColor skyColor) {
        super(loader, loader.getBackgroundStack(), bind, bindTime, isBound);
        this.groundAngle = groundAngle;
        this.groundColor = groundColor;
        this.backUrl = backUrl;
        this.bottomUrl = bottomUrl;
        this.frontUrl = frontUrl;
        this.leftUrl = leftUrl;
        this.rightUrl = rightUrl;
        this.topUrl = topUrl;
        this.skyAngle = skyAngle;
        this.skyColor = skyColor;
        loader.addBackground(this);
        this.initFields();
    }

    void initImpl() {
        int i = this.backUrl.getSize() + this.bottomUrl.getSize() + this.frontUrl.getSize() + this.leftUrl.getSize() + this.rightUrl.getSize() + this.topUrl.getSize();
        if (i == 0) {
            this.addColorBackground();
        } else {
            this.addImageBackground();
        }
        this.background.setApplicationBounds(this.loader.infiniteBounds);
        this.backgroundImpl = new RGroup();
        this.backgroundImpl.addChild((Node)this.background);
        this.implReady = true;
    }

    void addColorBackground() {
        if (this.skyAngle.mfloat.length > 0) {
            int[] bkg = this.createBkgGrad(this.skyColor, this.skyAngle, false);
            if (this.groundAngle.mfloat.length > 0) {
                int[] grndBkg = this.createBkgGrad(this.groundColor, this.groundAngle, true);
                for (int i = 0; i < 32; ++i) {
                    bkg[i + 31] = grndBkg[31 - i];
                }
            }
            Texture2D img = this.getImageBkg(bkg);
            this.background = new javax.media.j3d.Background();
            Appearance app = new Appearance();
            app.setTexture((Texture)img);
            PolygonAttributes pa = new PolygonAttributes();
            pa.setCullFace(0);
            pa.setBackFaceNormalFlip(true);
            app.setPolygonAttributes(pa);
            Sphere sphere = new Sphere(1.0f, 2, 20, app);
            BranchGroup bkgGeom = new BranchGroup();
            bkgGeom.addChild((Node)sphere);
            this.background.setGeometry(bkgGeom);
        } else {
            this.background = new javax.media.j3d.Background(this.skyColor.vals[0], this.skyColor.vals[1], this.skyColor.vals[2]);
        }
    }

    void addImageBackground() {
        TexCoord2f[] txcoords;
        Point3d[] vertices;
        this.background = new javax.media.j3d.Background();
        BranchGroup bkgGeom = new BranchGroup();
        if (this.backUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(-0.577, -0.577, -0.577), new Point3d(0.577, -0.577, -0.577), new Point3d(0.577, 0.577, -0.577), new Point3d(-0.577, 0.577, -0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.backUrl, bkgGeom);
        }
        if (this.bottomUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(-0.577, -0.577, 0.577), new Point3d(0.577, -0.577, 0.577), new Point3d(0.577, -0.577, -0.577), new Point3d(-0.577, -0.577, -0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.bottomUrl, bkgGeom);
        }
        if (this.frontUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(0.577, -0.577, 0.577), new Point3d(-0.577, -0.577, 0.577), new Point3d(-0.577, 0.577, 0.577), new Point3d(0.577, 0.577, 0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.frontUrl, bkgGeom);
        }
        if (this.leftUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(-0.577, -0.577, 0.577), new Point3d(-0.577, -0.577, -0.577), new Point3d(-0.577, 0.577, -0.577), new Point3d(-0.577, 0.577, 0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.leftUrl, bkgGeom);
        }
        if (this.rightUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(0.577, -0.577, -0.577), new Point3d(0.577, -0.577, 0.577), new Point3d(0.577, 0.577, 0.577), new Point3d(0.577, 0.577, -0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.rightUrl, bkgGeom);
        }
        if (this.topUrl.getSize() > 0) {
            vertices = new Point3d[]{new Point3d(0.577, 0.577, 0.577), new Point3d(-0.577, 0.577, 0.577), new Point3d(-0.577, 0.577, -0.577), new Point3d(0.577, 0.577, -0.577)};
            txcoords = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
            this.addImage(vertices, txcoords, this.topUrl, bkgGeom);
        }
        this.background.setGeometry(bkgGeom);
    }

    void addImage(Point3d[] vertices, TexCoord2f[] txcoords, MFString url, BranchGroup bkgGeom) {
        QuadArray geom = new QuadArray(vertices.length, 35);
        geom.setCoordinates(0, vertices);
        geom.setTextureCoordinates(0, 0, txcoords);
        Appearance app = new Appearance();
        URL bgImage = null;
        try {
            bgImage = this.loader.stringToURL(url.get1Value(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TextureLoader tex = new TextureLoader(bgImage, "RGB", 6, null);
        if (tex != null) {
            app.setTexture(tex.getTexture());
        }
        Shape3D shape = new Shape3D((Geometry)geom, app);
        bkgGeom.addChild((Node)shape);
    }

    int[] createBkgGrad(MFColor colors, MFFloat angles, boolean dome) throws InvalidVRMLSyntaxException {
        float[] clrs0 = new float[3];
        float[] clrs1 = new float[3];
        int c0dex = 0;
        int c1dex = 1;
        int maxdex = angles.mfloat.length;
        boolean mindex = false;
        int span = dome ? 32 : 64;
        int[] gradients = new int[span];
        if (maxdex != colors.vals.length / 3 - 1) {
            throw new InvalidVRMLSyntaxException("Background: there shall be one less angle than colors");
        }
        colors.get1Value(0, clrs0);
        gradients[0] = (int)(clrs0[0] * 255.0f) << 24 | (int)(clrs0[1] * 255.0f) << 16 | (int)(clrs0[2] * 255.0f) << 8 | 0xFF;
        for (int i = 1; i < span; ++i) {
            if (c1dex <= maxdex) {
                if (c1dex != maxdex && this.thetas[i] >= (double)angles.get1Value(c1dex)) {
                    c0dex = c1dex++;
                }
                colors.get1Value(c0dex, clrs0);
                colors.get1Value(c1dex, clrs1);
                float i0 = (1.0f - (float)Math.cos(this.thetas[i])) * 0.5f;
                float i1 = 1.0f - i0;
                int r = (int)((clrs0[0] * i0 + clrs1[0] * i1) * 255.0f);
                int g = (int)((clrs0[1] * i0 + clrs1[1] * i1) * 255.0f);
                int b = (int)((clrs0[2] * i0 + clrs1[2] * i1) * 255.0f);
                gradients[i] = r << 24 | g << 16 | b << 8 | 0xFF;
                continue;
            }
            gradients[i] = gradients[i - 1];
        }
        return gradients;
    }

    Texture2D getImageBkg(int[] gradients) {
        DirectColorModel cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
        WritableRaster raster = ((ColorModel)cm).createCompatibleWritableRaster(1, 64);
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        System.arraycopy(gradients, 0, data, 0, gradients.length);
        BufferedImage bufIm = new BufferedImage(cm, raster, false, null);
        ImageComponent2D component2D = new ImageComponent2D(2, bufIm);
        Texture2D tex = new Texture2D(1, 5, 1, 64);
        tex.setMinFilter(3);
        tex.setMagFilter(3);
        tex.setImage(0, (ImageComponent)component2D);
        tex.setEnable(true);
        return tex;
    }

    public BranchGroup getBackgroundImpl() {
        return this.backgroundImpl;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("bind")) {
            super.notifyMethod("bind", time);
        } else if (eventInName.equals("skyColor")) {
            if (this.skyColor.vals.length == 3) {
                this.background.setColor(this.skyColor.vals[0], this.skyColor.vals[1], this.skyColor.vals[2]);
            } else {
                System.err.println("Background: unexpected number of colors");
            }
        } else if (eventInName.equals("route_skyColor")) {
            this.background.setCapability(17);
        } else if (!eventInName.equals("route_bind")) {
            System.err.println("Background: unexpected notify " + eventInName);
        }
    }

    public String getType() {
        return "Background";
    }

    public Object clone() {
        return new Background(this.loader, (SFBool)this.bind.clone(), (SFTime)this.bindTime.clone(), (SFBool)this.isBound.clone(), (MFFloat)this.groundAngle.clone(), (MFColor)this.groundColor.clone(), (MFString)this.backUrl.clone(), (MFString)this.bottomUrl.clone(), (MFString)this.frontUrl.clone(), (MFString)this.leftUrl.clone(), (MFString)this.rightUrl.clone(), (MFString)this.topUrl.clone(), (MFFloat)this.skyAngle.clone(), (MFColor)this.skyColor.clone());
    }

    void initFields() {
        this.initBindableFields();
        this.groundAngle.init(this, this.FieldSpec, 3, "groundAngle");
        this.groundColor.init(this, this.FieldSpec, 3, "groundColor");
        this.backUrl.init(this, this.FieldSpec, 3, "backUrl");
        this.bottomUrl.init(this, this.FieldSpec, 3, "bottomUrl");
        this.frontUrl.init(this, this.FieldSpec, 3, "frontUrl");
        this.leftUrl.init(this, this.FieldSpec, 3, "leftUrl");
        this.rightUrl.init(this, this.FieldSpec, 3, "rightUrl");
        this.topUrl.init(this, this.FieldSpec, 3, "topUrl");
        this.skyAngle.init(this, this.FieldSpec, 3, "skyAngle");
        this.skyColor.init(this, this.FieldSpec, 3, "skyColor");
    }

    public BaseNode wrap() {
        return new org.jdesktop.j3d.loaders.vrml97.node.Background(this);
    }
}

