/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Stack;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFTime;

public abstract class BindableNode
extends Node {
    SFBool bind;
    SFTime bindTime;
    SFBool isBound;
    Stack stack;

    BindableNode(Loader loader, Stack initStack) {
        super(loader);
        this.stack = initStack;
        this.bind = new SFBool(false);
        this.bindTime = new SFTime();
        this.isBound = new SFBool(false);
    }

    BindableNode(Loader loader, Stack initStack, SFBool bind, SFTime bindTime, SFBool isBound) {
        super(loader);
        this.stack = initStack;
        this.bind = bind;
        this.bindTime = bindTime;
        this.isBound = isBound;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("bind")) {
            if (this.bind.getValue()) {
                if (this.stack != null) {
                    BindableNode top = this.stack.empty() ? null : (BindableNode)this.stack.peek();
                    if (top != this) {
                        if (this.stack.contains(this)) {
                            this.stack.removeElement(this);
                        }
                        this.stack.push(this);
                        this.browser.bindableChanged(this.stack);
                        this.bindTime.setValue(time);
                    }
                } else if (this.loader.debug) {
                    System.out.println("Bind called on bindable with null stack");
                }
                this.isBound.setValue(true);
            } else {
                if (this.stack != null) {
                    if ((BindableNode)this.stack.peek() == this) {
                        this.stack.pop();
                        BindableNode top = (BindableNode)this.stack.peek();
                        if (top != null) {
                            top.bind.setValue(true);
                            top.isBound.setValue(true);
                        }
                        this.browser.bindableChanged(this.stack);
                    } else if (this.stack.contains(this)) {
                        this.stack.removeElement(this);
                    }
                }
                this.isBound.setValue(false);
            }
        }
    }

    void initBindableFields() {
        this.bind.init(this, this.FieldSpec, 1, "bind");
        this.bindTime.init(this, this.FieldSpec, 2, "bindTime");
        this.isBound.init(this, this.FieldSpec, 2, "isBound");
    }

    public javax.media.j3d.Node getImplNode() {
        return this.implNode;
    }
}

