/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.DirectionalLight;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.NonSharedNode;
import org.jdesktop.j3d.loaders.vrml97.impl.ProtoInstance;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.VrmlSensor;

public abstract class GroupBase
extends NonSharedNode {
    MFNode addChildren;
    MFNode removeChildren;
    MFNode children;
    SFVec3f bboxCenter;
    SFVec3f bboxSize;
    Group implGroup;

    public GroupBase(Loader loader) {
        super(loader);
        this.children = new MFNode();
        this.bboxCenter = new SFVec3f();
        this.bboxSize = new SFVec3f(-1.0f, -1.0f, -1.0f);
        this.addChildren = new MFNode();
        this.removeChildren = new MFNode();
        this.initGroupBaseFields();
    }

    GroupBase(Loader loader, MFNode children, SFVec3f bboxCenter, SFVec3f bboxSize) {
        super(loader);
        this.children = children;
        this.bboxCenter = bboxCenter;
        this.bboxSize = bboxSize;
        this.addChildren = new MFNode();
        this.removeChildren = new MFNode();
        this.initGroupBaseFields();
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("addChildren")) {
            MFNode newKids = (MFNode)this.FieldSpec.get(eventInName);
            this.doAddChildren(newKids);
        } else if (eventInName.equals("removeChildren")) {
            MFNode badKids = (MFNode)this.FieldSpec.get(eventInName);
            this.doRemoveChildren(badKids);
        } else if (eventInName.equals("children")) {
            this.replaceChildren();
        } else if (eventInName.equals("route_children")) {
            this.implGroup.setCapability(12);
            this.implGroup.setCapability(13);
            this.implGroup.setCapability(14);
        } else {
            System.out.println("GroupBase: unknown eventInName: " + eventInName);
        }
    }

    void replaceChildren() {
        int i;
        int numChildren = this.implGroup.numChildren();
        if (numChildren != 0) {
            for (i = 0; i < numChildren; ++i) {
                this.implGroup.removeChild(0);
            }
        }
        for (i = 0; i < this.children.nodes.length; ++i) {
            BaseNode child = this.children.nodes[i];
            child.updateParent((Node)this.implGroup);
            child.parent = this;
            boolean doit = false;
            if (child instanceof VrmlSensor) {
                doit = true;
            }
            if (child instanceof ProtoInstance && ((ProtoInstance)child).containsSensor) {
                Enumeration e = ((ProtoInstance)child).sensors.elements();
                while (e.hasMoreElements()) {
                    BaseNode vs = (BaseNode)e.nextElement();
                    vs.updateParent((Node)this.implGroup);
                }
                doit = true;
            }
            if (doit) {
                this.implGroup.setCapability(1);
                this.implGroup.setCapability(3);
                this.implGroup.setCapability(9);
                this.implGroup.setCapability(11);
                this.implGroup.setPickable(true);
            }
            Node implNode = child.getImplNode();
            if (this.loader.debug) {
                System.out.println(this.toStringId() + ":  index = " + i + " child node type is " + child.getType() + " " + child.toStringId() + " gets implNoded to " + implNode);
            }
            if (implNode == null) continue;
            if (implNode.getParent() == null) {
                this.implGroup.addChild(implNode);
            } else {
                this.implGroup.addChild(implNode.cloneNode(true));
            }
            if (!(child instanceof DirectionalLight)) continue;
            DirectionalLight dirLight = (DirectionalLight)child;
            dirLight.setScope(this.implGroup);
        }
    }

    public int getNumTris() {
        int numTris = 0;
        for (int i = 0; i < this.children.nodes.length; ++i) {
            BaseNode child = this.children.nodes[i];
            numTris += child.getNumTris();
        }
        return numTris;
    }

    void doAddChildren(MFNode newChildren) {
        int i;
        BaseNode[] newCh = newChildren.getValue();
        BaseNode[] oldCh = this.children.getValue();
        Vector<BaseNode> v = new Vector<BaseNode>(newCh.length + oldCh.length);
        for (i = 0; i < oldCh.length; ++i) {
            v.addElement(oldCh[i]);
        }
        for (i = 0; i < newCh.length; ++i) {
            if (this.loader.debug) {
                System.out.println(this + " doAddChildren " + newCh[i]);
            }
            v.addElement(newCh[i]);
        }
        Object[] newFamily = new BaseNode[newCh.length + oldCh.length];
        v.copyInto(newFamily);
        this.children = new MFNode((BaseNode[])newFamily);
        this.FieldSpec.remove("children");
        this.children.init(this, this.FieldSpec, 3, "children");
        this.replaceChildren();
    }

    void doRemoveChildren(MFNode removeChildren) {
        int i;
        BaseNode[] oldCh = this.children.getValue();
        BaseNode[] removeCh = removeChildren.getValue();
        Vector<BaseNode> v = new Vector<BaseNode>(this.children.getValue().length);
        for (i = 0; i < oldCh.length; ++i) {
            v.addElement(oldCh[i]);
        }
        for (i = 0; i < removeCh.length; ++i) {
            if (this.loader.debug) {
                System.out.println("doRemoveChildren " + removeCh[i]);
            }
            v.removeElement(removeCh[i]);
        }
        Object[] newFamily = new BaseNode[this.children.getSize() - removeCh.length];
        v.copyInto(newFamily);
        this.children = new MFNode((BaseNode[])newFamily);
        this.FieldSpec.remove("children");
        this.FieldSpec.put("children", this.children);
        this.replaceChildren();
    }

    public String getType() {
        return "Group";
    }

    void initFields() {
    }

    void initGroupBaseFields() {
        this.addChildren.init(this, this.FieldSpec, 1, "addChildren");
        this.removeChildren.init(this, this.FieldSpec, 1, "removeChildren");
        this.children.init(this, this.FieldSpec, 3, "children");
        this.bboxCenter.init(this, this.FieldSpec, 0, "bboxCenter");
        this.bboxSize.init(this, this.FieldSpec, 0, "bboxSize");
    }

    public String toStringBodyS() {
        String retval = "children " + this.children;
        if ((double)this.bboxCenter.value[0] != 0.0 || (double)this.bboxCenter.value[1] != 0.0 || (double)this.bboxCenter.value[2] != 0.0) {
            retval = retval + "bboxCenter " + this.bboxCenter;
        }
        if ((double)this.bboxSize.value[0] != -1.0 || (double)this.bboxSize.value[1] != -1.0 || (double)this.bboxSize.value[2] != -1.0) {
            retval = retval + "bboxSize " + this.bboxSize;
        }
        return retval;
    }
}

