/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.ConstField;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Namespace;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.Proto;
import org.jdesktop.j3d.loaders.vrml97.impl.Route;

public class ProtoInstance
extends Node
implements Namespace {
    String name;
    Proto proto;
    Hashtable defTable = new Hashtable();
    BaseNode instanceNode;
    Vector routes;
    Hashtable fieldMapping = new Hashtable();
    Hashtable nodeMapping = new Hashtable();
    boolean containsSensor = false;
    Vector sensors;

    ProtoInstance(Loader loader, String name, Proto proto) {
        super(loader);
        this.name = name;
        this.proto = proto;
        this.routes = proto.routes;
    }

    Field addField(Field field) {
        Field newField;
        if (!this.fieldMapping.containsKey(field)) {
            newField = (Field)field.clone();
            this.fieldMapping.put(field, newField);
            newField.init(this, this.FieldSpec, field.fieldType, field.fieldName);
        } else {
            newField = (Field)this.fieldMapping.get(field);
        }
        return newField;
    }

    void initFields() {
        Enumeration e = this.proto.FieldSpec.keys();
        while (e.hasMoreElements()) {
            Field newField;
            String fieldName = (String)e.nextElement();
            Field field = (Field)this.proto.FieldSpec.get(fieldName);
            if (field instanceof ConstField) {
                newField = this.addField(((ConstField)field).ownerField);
                this.FieldSpec.put(fieldName, newField.constify());
                continue;
            }
            newField = this.addField(field);
            this.FieldSpec.put(fieldName, newField);
        }
    }

    public void define(String defName, BaseNode node) {
        this.defTable.put(defName, node);
    }

    public BaseNode use(String defName) {
        BaseNode retval = (BaseNode)this.defTable.get(defName);
        retval.registerUse(this.loader.scene);
        return retval;
    }

    BaseNode updateNode(BaseNode node) {
        if (node == null) {
            return this;
        }
        BaseNode retval = (BaseNode)this.nodeMapping.get(node);
        if (retval == null) {
            System.err.println("ProtoInstance: Unable to update node reference: " + node.toStringId());
        }
        return retval;
    }

    void applyRoutes() {
        Enumeration e = this.routes.elements();
        while (e.hasMoreElements()) {
            Route route = (Route)e.nextElement();
            BaseNode fromNode = this.updateNode(route.fromNode);
            BaseNode toNode = this.updateNode(route.toNode);
            if (route.fromField.equals("?") || route.toField.equals("?")) continue;
            this.loader.connect(fromNode, route.fromField, toNode, route.toField, false);
        }
    }

    BaseNode instanceNode() {
        return this.instanceNode;
    }

    public javax.media.j3d.Node getImplNode() {
        return this.instanceNode.getImplNode();
    }

    public void notifyMethod(String eventInName, double time) {
    }

    public String getType() {
        return this.name;
    }

    public Object clone() {
        System.err.println("Warning: clone called on a ProtoInstance!");
        return null;
    }

    public String toStringBody() {
        return "PROTO " + this.name + " {\n" + "}\n";
    }
}

