/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.ac3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import org.newdawn.j3d.loaders.ac3d.AC3DObject;

public class AC3DSurface {
    public static final double FLAT_CREASE_ANGLE = 0.0;
    public static final double SMOOTH_CREASE_ANGLE = Math.PI;
    private org.newdawn.loaders.ac3d.AC3DSurface surface;
    private AC3DObject parentObject;
    private Geometry geometry = null;

    public AC3DSurface(org.newdawn.loaders.ac3d.AC3DSurface surface, AC3DObject parentObject) {
        this.surface = surface;
        this.parentObject = parentObject;
    }

    public void rebuildGeometry() {
        int i;
        float[][] surfTextCoords = this.surface.getTextureCoordinates();
        int[] vertexReferences = this.surface.getVertexReferences();
        int coordNum = vertexReferences.length;
        float textureOffsetX = this.parentObject.getTextureOffsetX();
        float textureOffsetY = this.parentObject.getTextureOffsetY();
        float textureRepeatX = this.parentObject.getTextureRepeatX();
        float textureRepeatY = this.parentObject.getTextureRepeatY();
        Point3f[] surfVerts = this.parentObject.getAdjustedVertecies();
        Point3f[] verts = this.surface.getType() == 1 ? new Point3f[coordNum + 1] : new Point3f[coordNum];
        if (surfVerts == null) {
            System.out.println("surfVerts is null");
        }
        for (i = 0; i < coordNum; ++i) {
            verts[i] = surfVerts[vertexReferences[i]];
        }
        if (this.surface.getType() == 1) {
            verts[coordNum] = surfVerts[0];
        }
        TexCoord2f[] textCoords = new TexCoord2f[surfTextCoords.length];
        for (i = 0; i < surfTextCoords.length; ++i) {
            textCoords[i] = new TexCoord2f(surfTextCoords[i][0] * textureRepeatX + textureOffsetX, surfTextCoords[i][1] * textureRepeatY + textureOffsetY);
        }
        if (this.isLine()) {
            LineArray line = new LineArray(coordNum, 33);
            line.setCoordinates(0, verts);
            line.setTextureCoordinates(0, 0, textCoords);
            this.geometry = line;
        } else {
            GeometryInfo geoInfo = new GeometryInfo(5);
            geoInfo.setCoordinates(verts);
            geoInfo.setTextureCoordinateParams(1, 2);
            geoInfo.setTextureCoordinates(0, textCoords);
            geoInfo.setStripCounts(new int[]{coordNum});
            if (this.surface.isShaded()) {
                Vector3f[] smoothedNormals = this.parentObject.getSmoothedNormals();
                Vector3f[] normals = new Vector3f[verts.length];
                for (int i2 = 0; i2 < coordNum; ++i2) {
                    normals[i2] = smoothedNormals[vertexReferences[i2]];
                }
                geoInfo.setNormals(normals);
            } else {
                new NormalGenerator(0.0).generateNormals(geoInfo);
            }
            new Stripifier().stripify(geoInfo);
            this.geometry = geoInfo.getGeometryArray();
        }
    }

    public boolean isLine() {
        return this.surface.getType() != 0;
    }

    public boolean isTwoSided() {
        return this.surface.isTwoSided();
    }

    public int getMaterial() {
        return this.surface.getMaterial();
    }

    public Geometry getGeometry() {
        this.rebuildGeometry();
        return this.geometry;
    }
}

