/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.lame;

import java.io.UnsupportedEncodingException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TDebug;

public class Lame {
    private static final int MPEG_VERSION_2 = 0;
    private static final int MPEG_VERSION_1 = 1;
    private static final int MPEG_VERSION_2DOT5 = 2;
    public static final int QUALITY_LOWEST = 9;
    public static final int QUALITY_LOW = 7;
    public static final int QUALITY_MIDDLE = 5;
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_HIGHEST = 1;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int CHANNEL_MODE_AUTO = -1;
    public static final int BITRATE_AUTO = -1;
    private static final int DEFAULT_PCM_BUFFER_SIZE = 32768;
    private static boolean libAvailable = false;
    private static String linkError = "";
    private static int DEFAULT_QUALITY = 5;
    private static int DEFAULT_BITRATE = -1;
    private static int DEFAULT_CHANNEL_MODE = -1;
    private static boolean DEFAULT_VBR = false;
    private static final int OUT_OF_MEMORY = -300;
    private static final int NOT_INITIALIZED = -301;
    private static final int LAME_ENC_NOT_FOUND = -302;
    private static final String PROPERTY_PREFIX = "tritonus.lame.";
    private long m_lNativeGlobalFlags;
    private int effQuality;
    private int effBitRate;
    private int effVbr;
    private int effChMode;
    private int effSampleRate;
    private int effEncoding;

    private void handleNativeException(int resultCode) {
        this.close();
        if (resultCode == -300) {
            throw new OutOfMemoryError("out of memory");
        }
        if (resultCode == -301) {
            throw new RuntimeException("not initialized");
        }
        if (resultCode == -302) {
            libAvailable = false;
            linkError = "lame_enc.dll not found";
            throw new IllegalArgumentException(linkError);
        }
    }

    public Lame(AudioFormat sourceFormat) {
        this.initParams(sourceFormat);
    }

    public Lame(AudioFormat sourceFormat, int bitRate, int channelMode, int quality, boolean VBR) {
        this.initParams(sourceFormat, bitRate, channelMode, quality, VBR);
    }

    private void initParams(AudioFormat sourceFormat) {
        this.readParameters();
        this.initParams(sourceFormat, DEFAULT_BITRATE, DEFAULT_CHANNEL_MODE, DEFAULT_QUALITY, DEFAULT_VBR);
    }

    private void initParams(AudioFormat sourceFormat, int bitRate, int channelMode, int quality, boolean VBR) {
        block5: {
            int result;
            if (sourceFormat.getSampleRate() < 32000.0f && bitRate > 160) {
                bitRate = 160;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)("LAME parameters: channels=" + sourceFormat.getChannels() + "  sample rate=" + Math.round(sourceFormat.getSampleRate()) + "Hz" + "  bitrate=" + bitRate + "KBit/s"));
                TDebug.out((String)("                 channelMode=" + this.chmode2string(channelMode) + "   quality=" + this.quality2string(quality) + "   VBR=" + VBR + "  bigEndian=" + sourceFormat.isBigEndian()));
            }
            if ((result = this.nInitParams(sourceFormat.getChannels(), Math.round(sourceFormat.getSampleRate()), bitRate, channelMode, quality, VBR, sourceFormat.isBigEndian())) < 0) {
                this.handleNativeException(result);
                throw new IllegalArgumentException("parameters not supported by LAME (returned " + result + ")");
            }
            try {
                System.setProperty("tritonus.lame.effective.quality", this.quality2string(this.getEffectiveQuality()));
                System.setProperty("tritonus.lame.effective.bitrate", String.valueOf(this.getEffectiveBitRate()));
                System.setProperty("tritonus.lame.effective.chmode", this.chmode2string(this.getEffectiveChannelMode()));
                System.setProperty("tritonus.lame.effective.vbr", String.valueOf(this.getEffectiveVBR()));
                System.setProperty("tritonus.lame.effective.samplerate", String.valueOf(this.getEffectiveSampleRate()));
                System.setProperty("tritonus.lame.effective.encoding", this.getEffectiveEncoding().toString());
                System.setProperty("tritonus.lame.encoder.version", this.getEncoderVersion());
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block5;
                TDebug.out((Throwable)t);
            }
        }
    }

    private native int nInitParams(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    private native int nGetEncoderVersion(byte[] var1);

    public String getEncoderVersion() {
        byte[] string = new byte[300];
        int res = this.nGetEncoderVersion(string);
        if (res < 0) {
            if (res == -1) {
                throw new RuntimeException("Unexpected error in Lame.getEncoderVersion()");
            }
            this.handleNativeException(res);
        }
        String sRes = "";
        if (res > 0) {
            try {
                sRes = new String(string, 0, res, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out((Throwable)uee);
                }
                sRes = new String(string, 0, res);
            }
        }
        return sRes;
    }

    private native int nGetPCMBufferSize(int var1);

    public int getPCMBufferSize() {
        int ret = this.nGetPCMBufferSize(32768);
        if (ret < 0) {
            this.handleNativeException(ret);
            throw new RuntimeException("Unknown error in Lame.nGetPCMBufferSize(). Resultcode=" + ret);
        }
        return ret;
    }

    public int getMP3BufferSize() {
        return this.getPCMBufferSize() / 2 + 1024;
    }

    private native int nEncodeBuffer(byte[] var1, int var2, int var3, byte[] var4);

    public int encodeBuffer(byte[] pcm, int offset, int length, byte[] encoded) throws ArrayIndexOutOfBoundsException {
        if (length < 0 || offset + length > pcm.length) {
            throw new IllegalArgumentException("inconsistent parameters");
        }
        int result = this.nEncodeBuffer(pcm, offset, length, encoded);
        if (result < 0) {
            if (result == -1) {
                throw new ArrayIndexOutOfBoundsException("Encode buffer too small");
            }
            this.handleNativeException(result);
            throw new RuntimeException("crucial error in encodeBuffer.");
        }
        return result;
    }

    private native int nEncodeFinish(byte[] var1);

    public int encodeFinish(byte[] encoded) {
        return this.nEncodeFinish(encoded);
    }

    private native void nClose();

    public void close() {
        this.nClose();
    }

    public static boolean isLibAvailable() {
        return libAvailable;
    }

    public static String getLinkError() {
        return linkError;
    }

    public int getEffectiveQuality() {
        if (this.effQuality >= 9) {
            return 9;
        }
        if (this.effQuality >= 7) {
            return 7;
        }
        if (this.effQuality >= 5) {
            return 5;
        }
        if (this.effQuality >= 2) {
            return 2;
        }
        return 1;
    }

    public int getEffectiveBitRate() {
        return this.effBitRate;
    }

    public int getEffectiveChannelMode() {
        return this.effChMode;
    }

    public boolean getEffectiveVBR() {
        return this.effVbr != 0;
    }

    public int getEffectiveSampleRate() {
        return this.effSampleRate;
    }

    public AudioFormat.Encoding getEffectiveEncoding() {
        if (this.effEncoding == 0) {
            if (this.getEffectiveSampleRate() < 16000) {
                return new AudioFormat.Encoding("MPEG2DOT5L3");
            }
            return new AudioFormat.Encoding("MPEG2L3");
        }
        if (this.effEncoding == 2) {
            return new AudioFormat.Encoding("MPEG2DOT5L3");
        }
        return new AudioFormat.Encoding("MPEG1L3");
    }

    private void readParameters() {
        block2: {
            String v = Lame.getStringProperty("quality", this.quality2string(DEFAULT_QUALITY));
            DEFAULT_QUALITY = this.string2quality(v.toLowerCase(), DEFAULT_QUALITY);
            DEFAULT_BITRATE = Lame.getIntProperty("bitrate", DEFAULT_BITRATE);
            v = Lame.getStringProperty("chmode", this.chmode2string(DEFAULT_CHANNEL_MODE));
            DEFAULT_CHANNEL_MODE = this.string2chmode(v.toLowerCase(), DEFAULT_CHANNEL_MODE);
            DEFAULT_VBR = Lame.getBooleanProperty("vbr", DEFAULT_VBR);
            try {
                System.setProperty("tritonus.lame.quality", this.quality2string(DEFAULT_QUALITY));
                System.setProperty("tritonus.lame.bitrate", String.valueOf(DEFAULT_BITRATE));
                System.setProperty("tritonus.lame.chmode", this.chmode2string(DEFAULT_CHANNEL_MODE));
                System.setProperty("tritonus.lame.vbr", String.valueOf(DEFAULT_VBR));
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out((Throwable)t);
            }
        }
    }

    private String quality2string(int quality) {
        if (quality >= 9) {
            return "lowest";
        }
        if (quality >= 7) {
            return "low";
        }
        if (quality >= 5) {
            return "middle";
        }
        if (quality >= 2) {
            return "high";
        }
        return "highest";
    }

    private int string2quality(String quality, int def) {
        if (quality.equals("lowest")) {
            return 9;
        }
        if (quality.equals("low")) {
            return 7;
        }
        if (quality.equals("middle")) {
            return 5;
        }
        if (quality.equals("high")) {
            return 2;
        }
        if (quality.equals("highest")) {
            return 1;
        }
        return def;
    }

    private String chmode2string(int chmode) {
        if (chmode == 0) {
            return "stereo";
        }
        if (chmode == 1) {
            return "jointstereo";
        }
        if (chmode == 2) {
            return "dual";
        }
        if (chmode == 3) {
            return "mono";
        }
        if (chmode == -1) {
            return "auto";
        }
        return "auto";
    }

    private int string2chmode(String chmode, int def) {
        if (chmode.equals("stereo")) {
            return 0;
        }
        if (chmode.equals("jointstereo")) {
            return 1;
        }
        if (chmode.equals("dual")) {
            return 2;
        }
        if (chmode.equals("mono")) {
            return 3;
        }
        if (chmode.equals("auto")) {
            return -1;
        }
        return def;
    }

    private static boolean getBooleanProperty(String strName, boolean def) {
        String strValue;
        block3: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            strValue = def ? "true" : "false";
            try {
                strValue = System.getProperty(strPropertyName, strValue);
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out((Throwable)t);
            }
        }
        strValue = strValue.toLowerCase();
        boolean bValue = false;
        if (strValue.length() > 0) {
            bValue = def ? strValue.charAt(0) != 'f' && strValue.charAt(0) != 'n' && !strValue.equals("off") : strValue.charAt(0) == 't' || strValue.charAt(0) == 'y' || strValue.equals("on");
        }
        return bValue;
    }

    private static String getStringProperty(String strName, String def) {
        String strValue;
        block2: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            strValue = def;
            try {
                strValue = System.getProperty(strPropertyName, def);
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out((Throwable)t);
            }
        }
        return strValue;
    }

    private static int getIntProperty(String strName, int def) {
        int value;
        block2: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            value = def;
            try {
                String strValue = System.getProperty(strPropertyName, String.valueOf(def));
                value = new Integer(strValue);
            }
            catch (Throwable e) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out((Throwable)e);
            }
        }
        return value;
    }

    static {
        try {
            System.loadLibrary("lametritonus");
            libAvailable = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out((Throwable)e);
            }
            linkError = e.getMessage();
        }
    }
}

