/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.viewer;

import java.awt.BorderLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.nwn.loader.AnimationBehavior;

public class AnimPanel
extends JPanel
implements ListSelectionListener {
    private JList list;
    private AnimationBehavior anim;
    private String lastAnim;
    private boolean animationLoop;
    private boolean inChange;

    public AnimPanel() {
        this.setLayout(new BorderLayout());
        this.list = new JList();
        this.list.addListSelectionListener(this);
        this.add("Center", new JScrollPane(this.list));
    }

    public void setAnimationBehavior(AnimationBehavior animationBehavior) {
        this.anim = animationBehavior;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Object[] objectArray = AnimPanel.this.anim == null ? new Object[]{} : AnimPanel.this.anim.getAllAnimationNames().toArray();
                Arrays.sort(objectArray);
                AnimPanel.this.list.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        return objectArray.length;
                    }

                    @Override
                    public Object getElementAt(int n) {
                        return objectArray[n];
                    }
                });
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.inChange) {
            return;
        }
        String string = (String)this.list.getSelectedValue();
        if (string == null || string == this.lastAnim) {
            return;
        }
        this.lastAnim = string;
        this.anim.playAnimation(string, this.animationLoop);
    }

    public boolean getAnimationLoop() {
        return this.animationLoop;
    }

    public void setAnimationLoop(boolean bl) {
        this.animationLoop = bl;
    }

    public void showDefaultAnimations() {
        if (this.anim == null) {
            return;
        }
        this.inChange = true;
        this.list.clearSelection();
        ListModel listModel = this.list.getModel();
        List list = this.anim.getDefaultAnimations();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!list.contains(listModel.getElementAt(i))) continue;
            this.list.addSelectionInterval(i, i);
        }
        this.inChange = false;
    }

    public void setDefaultAnimations() {
        if (this.anim == null) {
            return;
        }
        this.anim.setDefaultAnimations(Arrays.asList(this.list.getSelectedValues()));
    }
}

