/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.viewer;

import com.sun.j3d.demos.utils.scenegraph.traverser.ProcessNodeInterface;
import com.sun.j3d.demos.utils.scenegraph.traverser.TreeScan;
import com.sun.j3d.loaders.Scene;
import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransformGroup;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.nwn.loader.AnimationBehavior;
import net.sf.nwn.loader.Model;
import net.sf.nwn.loader.NWNLoader;
import net.sf.nwn.loader.Walkmesh;
import net.sf.nwn.viewer.AnimPanel;
import net.sf.nwn.viewer.ControlPanel;
import net.sf.nwn.viewer.Display;

public class FilePanel
extends JPanel
implements ListSelectionListener {
    private Display display;
    private AnimPanel anim;
    private ControlPanel control;
    private URL base;
    private JList list;
    private Object lastSelected;
    private Model currentModel;
    private NWNLoader nwn = new NWNLoader();
    private static ProcessNodeInterface capabilityProcessor = new ProcessNodeInterface(){

        @Override
        public void processNode(Node node) {
            if (node instanceof Group) {
                node.setCapability(12);
                if (node instanceof TransformGroup) {
                    node.setCapability(11);
                }
            } else if (node instanceof Shape3D) {
                Shape3D shape3D = (Shape3D)node;
                shape3D.setCapability(14);
                Appearance appearance = shape3D.getAppearance();
                appearance.setCapability(20);
                appearance.clearCapabilityIsFrequent(20);
                appearance.setCapability(15);
                appearance.clearCapabilityIsFrequent(15);
                appearance.setCapability(13);
                appearance.clearCapabilityIsFrequent(13);
                int n = shape3D.getAppearance().getTextureUnitCount();
                for (int i = 0; i < n; ++i) {
                    TextureUnitState textureUnitState = shape3D.getAppearance().getTextureUnitState(i);
                    if (textureUnitState == null) continue;
                    textureUnitState.setCapability(0);
                    textureUnitState.getTexture().setCapability(1);
                    textureUnitState.getTextureAttributes().setCapability(1);
                    textureUnitState.getTexture().clearCapabilityIsFrequent(1);
                    textureUnitState.getTextureAttributes().clearCapabilityIsFrequent(1);
                }
            }
        }
    };

    public FilePanel(Display display, AnimPanel animPanel, ControlPanel controlPanel, URL uRL, String[] stringArray) {
        this.nwn.enableModelCache(true);
        this.display = display;
        this.anim = animPanel;
        this.control = controlPanel;
        this.setLayout(new BorderLayout());
        this.base = uRL;
        this.list = new JList<String>(stringArray);
        this.list.addListSelectionListener(this);
        this.add("Center", new JScrollPane(this.list));
    }

    public void setCurrentModel(final URL uRL) {
        new Thread("Model Loader"){

            @Override
            public void run() {
                try {
                    FilePanel.this.control.setAnimationBehavior(null, null);
                    FilePanel.this.anim.setAnimationBehavior(null);
                    FilePanel.this.display.getModelGroup().removeAllChildren();
                    FilePanel.this.currentModel = null;
                    FilePanel.this.display.addLoadingMessage();
                    this.setPriority(5);
                    1.sleep(100L);
                    long l = System.currentTimeMillis();
                    Scene scene = FilePanel.this.nwn.load(uRL);
                    BranchGroup branchGroup = scene.getSceneGroup();
                    FilePanel.this.setCapabilities(branchGroup);
                    branchGroup.compile();
                    AnimationBehavior animationBehavior = (AnimationBehavior)((Object)scene.getNamedObjects().get("AnimationBehavior"));
                    Walkmesh walkmesh = (Walkmesh)((Object)scene.getNamedObjects().get("%WALKMESH%"));
                    FilePanel.this.anim.setAnimationBehavior(animationBehavior);
                    FilePanel.this.control.setAnimationBehavior(animationBehavior, walkmesh);
                    FilePanel.this.display.removeLoadingMessage();
                    FilePanel.this.display.getModelGroup().addChild((Node)branchGroup);
                    System.err.println("Loaded in " + (System.currentTimeMillis() - l) + "ms");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(FilePanel.this, exception, "Error during load " + uRL, 0);
                    FilePanel.this.display.removeLoadingMessage();
                }
            }
        }.start();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.list.getSelectedValue();
        if (e == null || e == this.lastSelected) {
            return;
        }
        this.lastSelected = e;
        try {
            URL uRL = new URL(this.base, e + ".mdl");
            this.setCurrentModel(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            JOptionPane.showMessageDialog(this, malformedURLException, "Error during load " + e, 0);
            this.display.removeLoadingMessage();
        }
    }

    public void setCapabilities(BranchGroup branchGroup) {
        TreeScan.findNode((Node)branchGroup, new Class[]{Group.class, Shape3D.class}, capabilityProcessor, false, false);
    }
}

