/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.utils.geometry.Box;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;

public class A3Text3D
extends A3Object {
    String text = "dummy";
    String fontName = "Sanserif";
    Font font;
    FontRenderContext frc;
    Text3D text3D;
    Transform3D t;
    TransformGroup tg;
    Align align = Align.CENTER;
    Color3f textColor = new Color3f(0.8f, 0.8f, 0.8f);
    Material textMat;
    Color3f boardColor = new Color3f(0.0f, 0.0f, 1.0f);
    Material boardMat;
    boolean boardVisible = true;
    BranchGroup rootGroup;
    BranchGroup boardGroup;
    public static final Align LEFT = Align.LEFT;
    public static final Align CENTER = Align.CENTER;
    public static final Align RIGHT = Align.RIGHT;

    public A3Text3D(String s) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Text3D"));
        this.text = s;
        this.realConstructor();
    }

    public A3Text3D(String text, String fontName) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Text3D"));
        this.text = text;
        this.fontName = fontName;
        this.realConstructor();
    }

    public A3Text3D(String text, Font font) {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.A3Text3D"));
        this.text = text;
        this.font = font;
        this.realConstructor();
    }

    public A3Text3D(A3InitData d) {
        super(d);
        this.text = d.getString(0);
        if (d.getDataCount() >= 2) {
            this.fontName = d.getString(1);
        }
        if (d.getDataCount() >= 3) {
            if (d.getString(2).equals("LEFT")) {
                this.align = LEFT;
            } else if (d.getString(2).equals("CENTER")) {
                this.align = CENTER;
            } else if (d.getString(2).equals("RIGHT")) {
                this.align = RIGHT;
            }
        }
        if (d.getDataCount() >= 4) {
            this.textColor = (Color3f)d.get(3);
        }
        if (d.getDataCount() >= 5) {
            this.boardColor = (Color3f)d.get(4);
        }
        if (d.getDataCount() >= 6) {
            this.boardVisible = d.getBoolean(5);
        }
        this.realConstructor();
    }

    void realConstructor() {
        if (this.font == null) {
            this.font = new Font(this.fontName, 0, 1);
        }
        this.frc = new FontRenderContext(this.font.getTransform(), false, true);
        Font3D f3d = new Font3D(this.font, new FontExtrusion());
        this.text3D = new Text3D(f3d, "dummy", new Point3f());
        this.text3D.setCapability(3);
        this.text3D.setCapability(5);
        Shape3D textShape = new Shape3D();
        textShape.setGeometry((Geometry)this.text3D);
        Appearance ap = new Appearance();
        this.textMat = new Material();
        this.textMat.setCapability(1);
        this.textMat.setSpecularColor(new Color3f(0.0f, 0.0f, 0.0f));
        ap.setMaterial(this.textMat);
        textShape.setAppearance(ap);
        ap = new Appearance();
        this.boardMat = new Material();
        this.boardMat.setCapability(1);
        this.boardMat.setSpecularColor(new Color3f(0.0f, 0.0f, 0.0f));
        ap.setMaterial(this.boardMat);
        Box box = new Box();
        box.setAppearance(ap);
        this.t = new Transform3D();
        this.tg = new TransformGroup(this.t);
        this.tg.setCapability(18);
        this.tg.addChild((Node)box);
        this.boardGroup = new BranchGroup();
        this.boardGroup.setCapability(17);
        this.boardGroup.addChild((Node)this.tg);
        this.rootGroup = new BranchGroup();
        this.rootGroup.setCapability(13);
        this.rootGroup.setCapability(14);
        this.rootGroup.addChild((Node)textShape);
        this.rootGroup.addChild((Node)this.boardGroup);
        this.setAll();
        this.setNode((Node)this.rootGroup);
    }

    void setAll() {
        Rectangle2D r = this.font.getStringBounds(this.text, this.frc);
        Point3f p = new Point3f(0.0f, (float)(-r.getHeight() / 2.0), 0.0f);
        Vector3d v = new Vector3d(0.0, -0.3, 0.0);
        if (this.align == Align.LEFT) {
            p.x = 0.0f;
            v.x = r.getWidth() / 2.0;
        } else if (this.align == Align.CENTER) {
            p.x = (float)(-r.getWidth() / 2.0);
            v.x = 0.0;
        } else if (this.align == Align.RIGHT) {
            p.x = (float)(-r.getWidth());
            v.x = -r.getWidth() / 2.0;
        }
        final Vector3d scale = new Vector3d(r.getWidth() / 2.0 + 0.2, r.getHeight() / 2.0 + 0.2, 0.1);
        final Point3f pp = new Point3f(p);
        final Vector3d vv = new Vector3d(v);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                A3Text3D.this.text3D.setPosition(pp);
                A3Text3D.this.text3D.setString(A3Text3D.this.text);
                A3Text3D.this.textMat.setDiffuseColor(A3Text3D.this.textColor);
                A3Text3D.this.boardMat.setDiffuseColor(A3Text3D.this.boardColor);
                A3Text3D.this.t.setTranslation(vv);
                A3Text3D.this.t.setScale(scale);
                A3Text3D.this.tg.setTransform(A3Text3D.this.t);
                if (A3Text3D.this.boardVisible) {
                    if (A3Text3D.this.rootGroup.indexOfChild((Node)A3Text3D.this.boardGroup) == -1) {
                        A3Text3D.this.rootGroup.addChild((Node)A3Text3D.this.boardGroup);
                    }
                } else if (A3Text3D.this.rootGroup.indexOfChild((Node)A3Text3D.this.boardGroup) != -1) {
                    A3Text3D.this.rootGroup.removeChild((Node)A3Text3D.this.boardGroup);
                }
            }
        };
        this.runInBehavior(run);
    }

    public void setString(String s) {
        this.text = s;
        this.setAll();
    }

    public void setAlign(Align a) {
        this.align = a;
        this.setAll();
    }

    public void setTextColor(Color3f c) {
        this.textColor = c;
        this.setAll();
    }

    public void setBoardColor(Color3f c) {
        this.boardColor = c;
        this.setAll();
    }

    public void setBoardVisible(boolean b) {
        this.boardVisible = b;
        this.setAll();
    }

    @Override
    public void update(A3UpdateData d) {
        super.update(d);
        this.text = d.getString(0);
        if (d.getDataCount() >= 2) {
            if (d.getString(1).equals("LEFT")) {
                this.align = LEFT;
            } else if (d.getString(1).equals("CENTER")) {
                this.align = CENTER;
            } else if (d.getString(1).equals("RIGHT")) {
                this.align = RIGHT;
            }
        }
        if (d.getDataCount() >= 3) {
            this.textColor = (Color3f)d.get(2);
        }
        if (d.getDataCount() >= 4) {
            this.boardColor = (Color3f)d.get(3);
        }
        if (d.getDataCount() >= 5) {
            this.boardVisible = d.getBoolean(4);
        }
        this.setAll();
    }

    static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

