/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;
import jp.sourceforge.acerola3d.sound.A3SoundType;

public class LongSound
implements A3Sound {
    static int BUFFER_SIZE = 65536;
    static int NUM_BUFFERS = 4;
    String file;
    A3SoundSystem soundSystem;
    float segnoTime;
    A3SoundType type;
    float gain;
    boolean loop = false;
    long sleepTime = 0L;
    byte[] inputBytes;
    AudioInputStream ais;
    int[] buffers = new int[NUM_BUFFERS];
    int[] source = new int[1];
    boolean sourceInit = false;
    int format;
    int numChannels;
    int rate;
    Vector3f offset = new Vector3f();
    Vector3f loc = new Vector3f();
    Quat4d quat = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3f orgDir = new Vector3f(0.0f, 0.0f, 1.0f);
    Vector3f dir = new Vector3f(0.0f, 0.0f, 1.0f);
    boolean stopRequest = false;
    boolean isScheduled = false;

    LongSound() {
    }

    @Override
    public void init(String file, A3SoundSystem ss, float segno, A3SoundType t, float g, boolean l, Vector3d offset, Vector3d dir) throws Exception {
        this.file = file;
        this.soundSystem = ss;
        this.segnoTime = segno;
        this.type = t;
        this.gain = g;
        this.loop = l;
        this.offset.set((Tuple3d)offset);
        this.orgDir.set((Tuple3d)dir);
        this.dir.set((Tuple3d)dir);
        this.initBuffer1();
        this.initBuffer2();
    }

    void initBuffer1() throws Exception {
        URL url = new URL(this.file);
        InputStream is = url.openStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int cnt = 0;
        while ((cnt = is.read(b)) != -1) {
            baos.write(b, 0, cnt);
        }
        this.inputBytes = baos.toByteArray();
    }

    void initBuffer2() throws Exception {
        if (this.soundSystem.al == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.inputBytes);
        this.ais = AudioSystem.getAudioInputStream(bais);
        AudioFormat audioFormat = this.ais.getFormat();
        audioFormat = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, false);
        this.ais = AudioSystem.getAudioInputStream(audioFormat, this.ais);
        audioFormat = this.ais.getFormat();
        this.numChannels = audioFormat.getChannels();
        int numBytesPerSample = 2;
        this.format = this.numChannels == 1 ? 4353 : 4355;
        this.rate = (int)audioFormat.getSampleRate();
        this.sleepTime = (long)(1000.0 * (double)BUFFER_SIZE / (double)numBytesPerSample / (double)this.numChannels / (double)this.rate / 10.0);
        this.sleepTime = (this.sleepTime + 10L) / 10L * 10L;
        this.soundSystem.al.alGenBuffers(NUM_BUFFERS, this.buffers, 0);
        this.check(1);
    }

    void initSource() {
        if (this.soundSystem.al == null) {
            return;
        }
        this.soundSystem.al.alGenSources(1, this.source, 0);
        this.check(2);
        this.sourceInit = true;
        this.soundSystem.al.alSourcef(this.source[0], 4099, 1.0f);
        this.soundSystem.al.alSourcef(this.source[0], 4106, 1.0f);
        Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
        v.add((Tuple3d)new Vector3d(this.loc));
        this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
        this.soundSystem.al.alSourcef(this.source[0], 4106, this.gain);
        if (this.type == A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 0.0f);
            this.loc.set(0.0f, 0.0f, 0.0f);
        }
        if (this.type == A3SoundType.ConeSound) {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 1350.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        }
        this.check(3);
    }

    boolean alIsSource() {
        return this.sourceInit;
    }

    @Override
    public void start() {
        if (!this.alIsSource()) {
            this.initSource();
        }
        this.stopRequest = false;
        if (this.isScheduled) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LongSound.this.playLoop();
            }
        };
        this.soundSystem.executor.schedule(r, 0L, TimeUnit.MILLISECONDS);
        this.isScheduled = true;
    }

    @Override
    public void segno() {
        if (!this.alIsSource()) {
            return;
        }
        this.resetStream();
        int numBytesPerSample = 2;
        int skipBytes = (int)(this.segnoTime * (float)numBytesPerSample * (float)this.numChannels * (float)this.rate);
        try {
            int i;
            byte[] dummy = new byte[1024];
            for (int sum = 0; sum < skipBytes && (i = this.ais.read(dummy, 0, 1024)) > 0; sum += i) {
            }
        }
        catch (IOException e) {
            System.out.println("???1");
        }
        if (!this.isScheduled) {
            this.stopRequest = false;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LongSound.this.playLoop();
                }
            };
            this.soundSystem.executor.schedule(r, 0L, TimeUnit.MILLISECONDS);
            this.isScheduled = true;
        }
    }

    @Override
    public void stop() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.stopRequest = true;
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.soundSystem.al.alSourcei(this.source[0], 4105, 0);
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.sourceInit = false;
        this.resetStream();
    }

    @Override
    public void pause() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.stopRequest = true;
        this.soundSystem.al.alSourcePause(this.source[0]);
    }

    @Override
    public void rewind() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.stopRequest = true;
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.soundSystem.al.alSourcei(this.source[0], 4105, 0);
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.sourceInit = false;
        this.resetStream();
    }

    @Override
    public void setLoc(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        if (this.type != A3SoundType.BackgroundSound) {
            this.loc.set(x, y, z);
            if (this.alIsSource()) {
                Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
                v.add((Tuple3d)new Vector3d(this.loc));
                this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
            }
        }
    }

    @Override
    public void setLoc(Vector3d v) {
        this.setLoc((float)v.x, (float)v.y, (float)v.z);
    }

    @Override
    public void setRot(float x, float y, float z) {
        Quat4d q = Util.euler2quat(x, y, z);
        this.setQuat(q);
    }

    @Override
    public void setRot(Vector3d r) {
        Quat4d q = Util.euler2quat(r);
        this.setQuat(q);
    }

    @Override
    public void setQuat(Quat4d q) {
        if (this.soundSystem.al == null) {
            return;
        }
        if (this.type != A3SoundType.BackgroundSound) {
            this.quat.set((Tuple4d)q);
            Vector3d v = Util.trans(q, new Vector3d(this.orgDir));
            this.dir.set((Tuple3d)v);
            if (this.alIsSource()) {
                this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
            }
        }
    }

    @Override
    public void setVel() {
    }

    @Override
    public void setGain(float g) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.gain = g;
        if (this.alIsSource()) {
            this.soundSystem.al.alSourcef(this.source[0], 4106, g);
        }
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public void setDirection(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.orgDir.set(x, y, z);
        Vector3d v = Util.trans(this.quat, new Vector3d(this.orgDir));
        this.dir.set((Tuple3d)v);
        if (this.alIsSource()) {
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        }
    }

    @Override
    public void setDirection(Vector3d d) {
        this.setDirection((float)d.x, (float)d.y, (float)d.z);
    }

    @Override
    public void setOffset(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.offset.set(x, y, z);
        if (this.alIsSource()) {
            Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
            v.add((Tuple3d)new Vector3d(this.loc));
            this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
        }
    }

    @Override
    public void setOffset(Vector3d o) {
        this.setOffset((float)o.x, (float)o.y, (float)o.z);
    }

    @Override
    public void setLoop(boolean l) {
        this.loop = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        if (this.soundSystem.al == null) {
            return;
        }
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.empty();
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.sourceInit = false;
        this.soundSystem.al.alDeleteBuffers(1, this.buffers, 0);
        ArrayList<A3Sound> arrayList = this.soundSystem.sounds;
        synchronized (arrayList) {
            this.soundSystem.sounds.remove(this);
        }
    }

    @Override
    public void setType(A3SoundType t) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.type = t;
        if (!this.alIsSource()) {
            return;
        }
        if (t == A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 0.0f);
        } else if (t == A3SoundType.ConeSound) {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 135.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        } else {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
        }
    }

    @Override
    public void setSegno(float s) {
        this.segnoTime = s;
    }

    int read(byte[] buffer) throws Exception {
        int bytesRead = 0;
        int cnt = 0;
        while (bytesRead < buffer.length) {
            cnt = this.ais.read(buffer, bytesRead, buffer.length - bytesRead);
            if (cnt <= 0) {
                if (!this.loop) break;
                this.resetStream();
                continue;
            }
            bytesRead += cnt;
        }
        return bytesRead;
    }

    boolean playback() {
        if (this.playing()) {
            return true;
        }
        for (int i = 0; i < NUM_BUFFERS; ++i) {
            if (this.stream(this.buffers[i])) continue;
            return false;
        }
        this.soundSystem.al.alSourceQueueBuffers(this.source[0], NUM_BUFFERS, this.buffers, 0);
        this.soundSystem.al.alSourcePlay(this.source[0]);
        return true;
    }

    boolean playing() {
        int[] state = new int[1];
        this.soundSystem.al.alGetSourcei(this.source[0], 4112, state, 0);
        return state[0] == 4114;
    }

    boolean update() {
        int[] processed = new int[1];
        boolean active = true;
        this.soundSystem.al.alGetSourcei(this.source[0], 4118, processed, 0);
        while (processed[0] > 0) {
            int[] buffer = new int[1];
            this.soundSystem.al.alSourceUnqueueBuffers(this.source[0], 1, buffer, 0);
            this.check(4);
            active = this.stream(buffer[0]);
            this.soundSystem.al.alSourceQueueBuffers(this.source[0], 1, buffer, 0);
            this.check(5);
            processed[0] = processed[0] - 1;
        }
        return active;
    }

    boolean stream(int buffer) {
        byte[] pcm = new byte[BUFFER_SIZE];
        int size = 0;
        try {
            size = this.read(pcm);
            if (size <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        ByteBuffer data = ByteBuffer.wrap(pcm, 0, size);
        this.soundSystem.al.alBufferData(buffer, this.format, (Buffer)data, size, this.rate);
        this.check(6);
        return true;
    }

    void empty() {
        int[] queued = new int[1];
        this.soundSystem.al.alGetSourcei(this.source[0], 4117, queued, 0);
        while (queued[0] > 0) {
            int[] buffer = new int[1];
            this.soundSystem.al.alSourceUnqueueBuffers(this.source[0], 1, buffer, 0);
            this.check(7);
            queued[0] = queued[0] - 1;
        }
    }

    void playLoop() {
        if (this.stopRequest) {
            this.isScheduled = false;
            return;
        }
        if (!this.playing()) {
            if (!this.playback()) {
                System.out.println("???2");
                this.isScheduled = false;
                return;
            }
        } else if (!this.update()) {
            this.isScheduled = false;
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LongSound.this.playLoop();
            }
        };
        this.soundSystem.executor.schedule(r, this.sleepTime, TimeUnit.MILLISECONDS);
        this.isScheduled = true;
    }

    void resetStream() {
        try {
            this.ais.close();
            this.ais = null;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.inputBytes);
            this.ais = AudioSystem.getAudioInputStream(bais);
            AudioFormat audioFormat = this.ais.getFormat();
            audioFormat = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, false);
            this.ais = AudioSystem.getAudioInputStream(audioFormat, this.ais);
        }
        catch (Exception e) {
            System.out.println("???3");
        }
    }

    @Override
    public A3Sound copy() {
        LongSound ret = new LongSound();
        ret.file = this.file;
        ret.soundSystem = this.soundSystem;
        ret.segnoTime = this.segnoTime;
        ret.type = this.type;
        ret.gain = this.gain;
        ret.loop = this.loop;
        ret.sleepTime = this.sleepTime;
        ret.inputBytes = this.inputBytes;
        ret.format = this.format;
        ret.rate = this.rate;
        ret.offset.set((Tuple3f)this.offset);
        ret.orgDir.set((Tuple3f)this.orgDir);
        ret.dir.set((Tuple3f)this.dir);
        try {
            ret.initBuffer2();
        }
        catch (Exception e) {
            System.out.println("???4");
        }
        return ret;
    }

    void check(int i) {
        int e = this.soundSystem.al.alGetError();
        if (e == 0) {
            return;
        }
        String s = "??????";
        switch (e) {
            case 40961: {
                s = "AL_INVALID_NAME";
                break;
            }
            case 40962: {
                s = "AL_INVALID_ENUM";
                break;
            }
            case 40963: {
                s = "AL_INVALID_VALUE";
                break;
            }
            case 40964: {
                s = "AL_INVALID_OPERATION";
                break;
            }
            case 40965: {
                s = "AL_OUT_OF_MEMORY";
            }
        }
        System.out.println("----------LongSound----------");
        System.out.println("OpenAL error raised..." + s + i);
        System.out.println("-----------------------------\n");
    }
}

