/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import jp.sourceforge.acerola3d.A23;

class ResURLConnection
extends URLConnection {
    String resStr = null;
    int size = -1;
    String enc = null;
    InputStream inputStream = null;

    public ResURLConnection(URL url) {
        super(url);
        this.resStr = url.getPath();
        if (this.resStr.startsWith("/")) {
            this.resStr = this.resStr.substring(1);
        }
    }

    @Override
    public void connect() throws IOException {
        int len;
        URL retURL = A23.classLoader.getResource(this.resStr);
        URLConnection c = retURL.openConnection();
        this.enc = c.getContentEncoding();
        BufferedInputStream bis = new BufferedInputStream(c.getInputStream());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        byte[] buf = new byte[1024];
        while ((len = bis.read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        bos.flush();
        bos.close();
        bis.close();
        byte[] b = baos.toByteArray();
        this.size = b.length;
        this.inputStream = new BufferedInputStream(new ByteArrayInputStream(b));
        this.connected = true;
    }

    @Override
    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.inputStream == null) {
            throw new IOException();
        }
        return this.inputStream;
    }

    @Override
    public String getContentEncoding() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.enc;
    }
}

