/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import a3vrml.InvalidVRMLSyntaxException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Group;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFString;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;

public class Inline
extends Group {
    MFString url;
    SFVec3f bboxCenter;
    SFVec3f bboxSize;

    public Inline(Loader loader) {
        super(loader);
        this.url = new MFString();
        this.bboxCenter = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.bboxSize = new SFVec3f(-1.0f, -1.0f, -1.0f);
        this.initInlineFields();
    }

    Inline(Loader loader, MFString url, SFVec3f bboxCenter, SFVec3f bboxSize) {
        super(loader);
        this.url = url;
        this.bboxCenter = bboxCenter;
        this.bboxSize = bboxSize;
        this.initInlineFields();
    }

    void initImpl() {
        this.implGroup = this.impl = new javax.media.j3d.Group();
        this.implNode = this.implGroup;
        this.impl.setUserData(new Vector());
        this.loadURL();
        this.implReady = true;
    }

    void loadURL() {
        URL loadURL;
        Scene scene = null;
        try {
            loadURL = this.loader.stringToURL(this.url.strings[0]);
        }
        catch (MalformedURLException ue) {
            InvalidVRMLSyntaxException i = new InvalidVRMLSyntaxException("Bad URL readling Inline: " + this.url.strings[0]);
            i.initCause(ue);
            throw i;
        }
        try {
            scene = this.loader.load(loadURL);
        }
        catch (IOException e) {
            InvalidVRMLSyntaxException i = new InvalidVRMLSyntaxException("IOException reading Inline:" + loadURL);
            i.initCause(e);
            throw i;
        }
        BaseNode[] nodes = new BaseNode[scene.objects.size()];
        int i = 0;
        Enumeration e = scene.objects.elements();
        while (e.hasMoreElements()) {
            nodes[i] = (BaseNode)e.nextElement();
            ++i;
        }
        this.children.nodes = nodes;
        this.replaceChildren();
        this.loader.scene.viewpoints.addAll(scene.viewpoints);
        this.loader.scene.navInfos.addAll(scene.navInfos);
        this.loader.scene.backgrounds.addAll(scene.backgrounds);
        this.loader.scene.fogs.addAll(scene.fogs);
        this.loader.scene.lights.addAll(scene.lights);
        this.loader.scene.sharedGroups.addAll(scene.sharedGroups);
        this.loader.scene.timeSensors.addAll(scene.timeSensors);
        this.loader.scene.visibilitySensors.addAll(scene.visibilitySensors);
        this.loader.scene.touchSensors.addAll(scene.touchSensors);
        this.loader.scene.audioClips.addAll(scene.audioClips);
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("url")) {
            this.loadURL();
        }
    }

    public Object clone() {
        return new Inline(this.loader, (MFString)this.url.clone(), (SFVec3f)this.bboxSize.clone(), (SFVec3f)this.bboxCenter.clone());
    }

    public String getType() {
        return "Inline";
    }

    void initFields() {
        super.initFields();
        this.initInlineFields();
    }

    void initInlineFields() {
        this.url.init(this, this.FieldSpec, 3, "url");
        this.bboxCenter.init(this, this.FieldSpec, 0, "bboxCenter");
        this.bboxSize.init(this, this.FieldSpec, 0, "bboxSize");
    }
}

