/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Balloon;
import jp.sourceforge.acerola3d.a3.A3Behavior;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Label;
import jp.sourceforge.acerola3d.a3.A3Selected;
import jp.sourceforge.acerola3d.a3.A3UpdateData;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Component2DContainerInterface;
import jp.sourceforge.acerola3d.a3.Util;

public abstract class A3Object {
    static BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
    A3Behavior behavior = null;
    Component2DContainerInterface component2DContainer = null;
    A3Label label = null;
    A3Balloon balloon = null;
    A3Selected selected = null;
    boolean isSelected = false;
    Object userData = null;
    boolean lockedA3 = false;
    boolean pickable = true;
    boolean isEmphasized = false;
    boolean isPolygonized = false;
    Vector3d upperVector = new Vector3d(0.0, 1.0, 0.0);

    public A3Object(A3InitData d) {
        this.behavior = new A3Behavior(this);
        this.behavior.setSchedulingBounds((Bounds)bs);
        this.setEnableBehavior(d.getEnableBehavior());
        this.setAutoDirectionControl(d.getAutoDirectionControl());
        if (d.loc != null) {
            this.setLocImmediately(d.loc);
        }
        if (d.quat != null) {
            this.setQuatImmediately(d.quat);
        }
        this.setScaleImmediately(d.scale);
        if (d.label != null) {
            this.setLabel(d.label);
        }
        if (d.balloon != null) {
            this.setBalloon(d.balloon);
        }
        this.upperVector = d.upperVector;
        this.pickable = d.pickable;
    }

    protected void init() {
        this.behavior.init();
    }

    public final void setEnableBehavior(boolean b) {
        this.behavior.setEnableBehavior(b);
    }

    public void setInterpolateRatio(double ir) {
        this.behavior.setInterpolateRatio(ir);
    }

    public final void setAutoDirectionControl(boolean b) {
        this.behavior.setAutoDirectionControl(b);
    }

    public final void setBillboardControl(boolean b) {
        this.behavior.setBillboardControl(b);
    }

    public void setUpperVector(Vector3d v) {
        this.upperVector.set((Tuple3d)v);
    }

    public Vector3d getUpperVector() {
        return new Vector3d(this.upperVector);
    }

    protected void setNode(Node n) {
        this.behavior.setNode(n);
    }

    public Node getNode() {
        return this.behavior.topGroup;
    }

    public void update(A3UpdateData d) {
        if (d.loc != null) {
            this.setLoc(d.loc);
        }
        if (d.quat != null) {
            this.setQuat(d.quat);
        }
        this.setScale(d.scale);
        this.setLabel(d.label);
        this.setBalloon(d.balloon);
    }

    void setComponent2DContainerInterface(Component2DContainerInterface cci) {
        this.component2DContainer = cci;
        if (this.component2DContainer == null) {
            return;
        }
        this.behavior.setA3VirtualUniverse(cci.getA3VirtualUniverse());
        if (this instanceof Action3D) {
            ((Action3D)this).actionBehavior.setA3VirtualUniverse(cci.getA3VirtualUniverse());
        }
        if (this.label != null) {
            this.component2DContainer.add(this.label);
        }
        if (this.balloon != null) {
            this.component2DContainer.add(this.balloon);
        }
        if (this.selected != null) {
            this.component2DContainer.add(this.selected);
        }
    }

    final A3BranchGroup getA3BranchGroup() {
        return this.behavior.topGroup;
    }

    public final void move(Vector3d v, Quat4d q, double s) {
        this.behavior.move(v, q, s);
    }

    public final void move(Vector3d loc, Vector3d rot, double scale) {
        this.move(loc, Util.euler2quat(rot), scale);
    }

    public final void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.behavior.moveImmediately(v, q, s);
    }

    public final void moveImmediately(Vector3d loc, Vector3d rot, double scale) {
        this.moveImmediately(loc, Util.euler2quat(rot), scale);
    }

    public final void setLoc(Vector3d v) {
        this.behavior.setLoc(v);
    }

    public final void setLoc(double x, double y, double z) {
        this.setLoc(new Vector3d(x, y, z));
    }

    public final void setLocImmediately(Vector3d v) {
        this.behavior.setLocImmediately(v);
    }

    public final void setLocImmediately(double x, double y, double z) {
        this.setLocImmediately(new Vector3d(x, y, z));
    }

    public final void addLoc(Vector3d v) {
        this.behavior.addLoc(v);
    }

    public final void addLoc(double x, double y, double z) {
        this.addLoc(new Vector3d(x, y, z));
    }

    public final void addLocImmediately(Vector3d v) {
        this.behavior.addLocImmediately(v);
    }

    public final void addLocImmediately(double x, double y, double z) {
        this.addLocImmediately(new Vector3d(x, y, z));
    }

    public final Vector3d getLoc() {
        return this.behavior.getLoc();
    }

    public final Vector3d getTargetLoc() {
        return this.behavior.getTargetLoc();
    }

    public final void setQuat(Quat4d q) {
        this.behavior.setQuat(q);
    }

    public final void setQuat(double x, double y, double z, double w) {
        this.setQuat(new Quat4d(x, y, z, w));
    }

    public final void setQuatImmediately(Quat4d q) {
        this.behavior.setQuatImmediately(q);
    }

    public final void setQuatImmediately(double x, double y, double z, double w) {
        this.setQuatImmediately(new Quat4d(x, y, z, w));
    }

    public final void mulQuat(Quat4d q) {
        this.behavior.mulQuat(q);
    }

    public final void mulQuat(double x, double y, double z, double w) {
        this.mulQuat(new Quat4d(x, y, z, w));
    }

    public final void mulQuatImmediately(Quat4d q) {
        this.behavior.mulQuatImmediately(q);
    }

    public final void mulQuatImmediately(double x, double y, double z, double w) {
        this.setQuatImmediately(new Quat4d(x, y, z, w));
    }

    public final Quat4d getQuat() {
        return this.behavior.getQuat();
    }

    public final Quat4d getTargetQuat() {
        return this.behavior.getTargetQuat();
    }

    public final void setRot(Vector3d rot) {
        this.setQuat(Util.euler2quat(rot));
    }

    public final void setRot(double x, double y, double z) {
        this.setQuat(Util.euler2quat(x, y, z));
    }

    public final void setRotImmediately(Vector3d rot) {
        this.setQuatImmediately(Util.euler2quat(rot));
    }

    public final void setRotImmediately(double x, double y, double z) {
        this.setQuatImmediately(Util.euler2quat(x, y, z));
    }

    public final void mulRot(Vector3d rot) {
        this.mulQuat(Util.euler2quat(rot));
    }

    public final void mulRot(double x, double y, double z) {
        this.mulQuat(Util.euler2quat(x, y, z));
    }

    public final void mulRotImmediately(Vector3d rot) {
        this.mulQuatImmediately(Util.euler2quat(rot));
    }

    public final void mulRotImmediately(double x, double y, double z) {
        this.mulQuatImmediately(Util.euler2quat(x, y, z));
    }

    public final Vector3d getRot() {
        return Util.quat2euler(this.getQuat());
    }

    public final Vector3d getTargetRot() {
        return Util.quat2euler(this.getTargetQuat());
    }

    public final void setRev(Vector3d rev) {
        this.setQuat(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public final void setRev(double x, double y, double z) {
        this.setQuat(Util.euler2quat(x * Math.PI / 180.0, y * Math.PI / 180.0, z * Math.PI / 180.0));
    }

    public final void setRevImmediately(Vector3d rev) {
        this.setQuatImmediately(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public final void setRevImmediately(double x, double y, double z) {
        this.setQuatImmediately(Util.euler2quat(x * Math.PI / 180.0, y * Math.PI / 180.0, z * Math.PI / 180.0));
    }

    public final void mulRev(Vector3d rev) {
        this.mulQuat(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public final void mulRev(double x, double y, double z) {
        this.mulQuat(Util.euler2quat(x * Math.PI / 180.0, y * Math.PI / 180.0, z * Math.PI / 180.0));
    }

    public final void mulRevImmediately(Vector3d rev) {
        this.mulQuatImmediately(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public final void mulRevImmediately(double x, double y, double z) {
        this.mulQuatImmediately(Util.euler2quat(x * Math.PI / 180.0, y * Math.PI / 180.0, z * Math.PI / 180.0));
    }

    public final Vector3d getRev() {
        Vector3d rev = Util.quat2euler(this.getQuat());
        rev.scale(57.29577951308232);
        return rev;
    }

    public final Vector3d getTargetRev() {
        Vector3d rev = Util.quat2euler(this.getTargetQuat());
        rev.scale(57.29577951308232);
        return rev;
    }

    public final void setLookAtPoint(Vector3d lookAt) {
        this.behavior.setLookAtPoint(lookAt);
    }

    public final void setLookAtPointImmediately(Vector3d lookAt) {
        this.behavior.setLookAtPointImmediately(lookAt);
    }

    public final void setLookAtPoint(double x, double y, double z) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.behavior.setLookAtPoint(lookAt);
    }

    public final void setLookAtPointImmediately(double x, double y, double z) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.behavior.setLookAtPointImmediately(lookAt);
    }

    public final void setScale(double s) {
        this.behavior.setScale(s);
    }

    public final void setScaleImmediately(double s) {
        this.behavior.setScaleImmediately(s);
    }

    public final void mulScale(double s) {
        this.behavior.mulScale(s);
    }

    public final void mulScaleImmediately(double s) {
        this.behavior.mulScaleImmediately(s);
    }

    public final void setScaleX(double sx) {
        this.behavior.setScaleX(sx);
    }

    public final void setScaleY(double sy) {
        this.behavior.setScaleY(sy);
    }

    public final void setScaleZ(double sz) {
        this.behavior.setScaleZ(sz);
    }

    public final void setScale(Vector3d sv) {
        this.behavior.setScale(sv);
    }

    public final void setScaleXImmediately(double sx) {
        this.behavior.setScaleXImmediately(sx);
    }

    public final void setScaleYImmediately(double sy) {
        this.behavior.setScaleYImmediately(sy);
    }

    public final void setScaleZImmediately(double sz) {
        this.behavior.setScaleZImmediately(sz);
    }

    public final void setScaleImmediately(Vector3d sv) {
        this.behavior.setScaleImmediately(sv);
    }

    public final void mulScaleX(double sx) {
        this.behavior.mulScaleX(sx);
    }

    public final void mulScaleY(double sy) {
        this.behavior.mulScaleY(sy);
    }

    public final void mulScaleZ(double sz) {
        this.behavior.mulScaleZ(sz);
    }

    public final void mulScale(Vector3d sv) {
        this.behavior.mulScale(sv);
    }

    public final void mulScaleXImmediately(double sx) {
        this.behavior.mulScaleXImmediately(sx);
    }

    public final void mulScaleYImmediately(double sy) {
        this.behavior.mulScaleYImmediately(sy);
    }

    public final void mulScaleZImmediately(double sz) {
        this.behavior.mulScaleZImmediately(sz);
    }

    public final void mulScaleImmediately(Vector3d sv) {
        this.behavior.mulScaleImmediately(sv);
    }

    public final double getScale() {
        return this.behavior.getScale();
    }

    public final double getScaleX() {
        return this.behavior.getScaleX();
    }

    public final double getScaleY() {
        return this.behavior.getScaleY();
    }

    public final double getScaleZ() {
        return this.behavior.getScaleZ();
    }

    public final Vector3d getScaleV() {
        return this.behavior.getScaleV();
    }

    public final double getTargetScale() {
        return this.behavior.getTargetScale();
    }

    public final double getTargetScaleX() {
        return this.behavior.getTargetScale();
    }

    public final double getTargetScaleY() {
        return this.behavior.getTargetScaleY();
    }

    public final double getTargetScaleZ() {
        return this.behavior.getTargetScaleZ();
    }

    public final Vector3d getTargetScaleV() {
        return this.behavior.getTargetScaleV();
    }

    public final void moveForward(double l) {
        this.behavior.moveForward(l);
    }

    public final void moveForwardImmediately(double l) {
        this.behavior.moveForwardImmediately(l);
    }

    public final void moveBackward(double l) {
        this.behavior.moveBackward(l);
    }

    public final void moveBackwardImmediately(double l) {
        this.behavior.moveBackwardImmediately(l);
    }

    public final void moveRight(double l) {
        this.behavior.moveRight(l);
    }

    public final void moveRightImmediately(double l) {
        this.behavior.moveRightImmediately(l);
    }

    public final void moveLeft(double l) {
        this.behavior.moveLeft(l);
    }

    public final void moveLeftImmediately(double l) {
        this.behavior.moveLeftImmediately(l);
    }

    public final void moveUp(double l) {
        this.behavior.moveUp(l);
    }

    public final void moveUpImmediately(double l) {
        this.behavior.moveUpImmediately(l);
    }

    public final void moveDown(double l) {
        this.behavior.moveDown(l);
    }

    public final void moveDownImmediately(double l) {
        this.behavior.moveDownImmediately(l);
    }

    public final Vector3d getUnitVecX() {
        return this.behavior.getUnitVecX();
    }

    public final Vector3d getUnitVecY() {
        return this.behavior.getUnitVecY();
    }

    public final Vector3d getUnitVecZ() {
        return this.behavior.getUnitVecZ();
    }

    public void dispose() {
        if (this.component2DContainer != null) {
            if (this.label != null) {
                this.component2DContainer.del(this.label);
            }
            if (this.balloon != null) {
                this.component2DContainer.del(this.balloon);
            }
            if (this.selected != null) {
                this.component2DContainer.del(this.selected);
            }
            this.component2DContainer = null;
        }
    }

    public void setLabel(String l) {
        if (this.label == null) {
            this.label = new A3Label(l, this);
        }
        if (l != null) {
            this.label.setString(l);
            if (this.component2DContainer != null) {
                this.component2DContainer.add(this.label);
            }
        } else if (this.component2DContainer != null) {
            this.component2DContainer.del(this.label);
        }
    }

    public void setLabelLoc(double x, double y) {
        if (this.label == null) {
            this.label = new A3Label("", this);
        }
        this.label.setOffset(x, y);
    }

    public void getLabelLoc(double[] ret) {
        if (this.label == null) {
            ret[1] = 0.0;
            ret[0] = 0.0;
        } else {
            this.label.getOffset(ret);
        }
    }

    public void setBalloon(String s) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon(s, this);
        }
        if (s != null) {
            this.balloon.setString(s);
            if (this.component2DContainer != null) {
                this.component2DContainer.add(this.balloon);
            }
        } else if (this.component2DContainer != null) {
            this.component2DContainer.del(this.balloon);
        }
    }

    public void setBalloonLoc(BalloonDir d, double x, double y) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon("", this);
        }
        this.balloon.setOffset(d, x, y);
    }

    public void getBalloonLoc(BalloonDir d, double[] ret) {
        if (this.balloon == null) {
            ret[1] = 0.0;
            ret[0] = 0.0;
        } else {
            this.balloon.getOffset(d, ret);
        }
    }

    public void setBalloonDir(BalloonDir d) {
        if (this.balloon == null) {
            this.balloon = new A3Balloon("", this);
        }
        this.balloon.setDir(d);
    }

    public final void setSelected(boolean b) {
        this.isSelected = b;
        if (this.selected == null) {
            this.selected = new A3Selected(this);
        }
        if (b) {
            if (this.component2DContainer != null) {
                this.component2DContainer.add(this.selected);
            }
        } else if (this.component2DContainer != null) {
            this.component2DContainer.del(this.selected);
        }
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setUserData(Object o) {
        this.userData = o;
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final double getSpeed() {
        return this.behavior.getSpeed();
    }

    public void setPickable(boolean b) {
        this.pickable = b;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public static void setSelected3DMarker(Node n) {
        A3Behavior.setSelected3DMarker(n);
    }

    public void setSelected3D(boolean b) {
        this.behavior.setSelected3D(b);
    }

    public boolean isSelected3D() {
        return this.behavior.isSelected3D();
    }

    public void emphasize() {
        this.component2DContainer.getA3VirtualUniverse().emphasize(this);
        this.isEmphasized = true;
        if (this.isPolygonized) {
            this.unpolygonize();
            this.isPolygonized = false;
        }
    }

    public void unemphasize() {
        this.component2DContainer.getA3VirtualUniverse().unemphasize(this);
        this.isEmphasized = false;
    }

    public boolean isEmphasized() {
        return this.isEmphasized;
    }

    public void polygonize() {
        this.component2DContainer.getA3VirtualUniverse().polygonize(this);
        this.isPolygonized = true;
        if (this.isEmphasized) {
            this.unemphasize();
            this.isEmphasized = false;
        }
    }

    public void unpolygonize() {
        this.component2DContainer.getA3VirtualUniverse().unpolygonize(this);
        this.isPolygonized = false;
    }

    public boolean isPolygonized() {
        return this.isPolygonized;
    }

    public void setVisible(boolean b) {
        this.behavior.setVisible(b);
    }

    protected void runInBehavior(Runnable r) {
        this.behavior.addRunnable(r);
    }

    public static enum BalloonDir {
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

    }

    public static enum UpperDirection {
        Y,
        Z;

    }
}

