/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AlternateAppearance;
import javax.media.j3d.Appearance;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3Widget;
import jp.sourceforge.acerola3d.a3.Action3DData;
import jp.sourceforge.acerola3d.a3.CameraBehavior;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.JA3Canvas;
import jp.sourceforge.acerola3d.a3.JA3Canvas2;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.ProjectionMode;
import jp.sourceforge.acerola3d.a3.Scene;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;

class A3VirtualUniverse
extends VirtualUniverse
implements A3CanvasInterface {
    A3CanvasInterface canvas = null;
    Canvas3D canvas3d = null;
    Locale locale;
    View view;
    BranchGroup rootGroup;
    TransformGroup tGroup;
    Transform3D transform;
    BranchGroup vpGroup;
    ViewPlatform vp;
    HashMap<Integer, Scene> scenes = new HashMap();
    Scene scene;
    TimerBehavior timerBehavior;
    PickingBehavior pickingBehavior;
    CameraBehavior cameraBehavior;
    Light headLight;
    AlternateAppearance emphasizerAA;
    AlternateAppearance polygonizerAA;
    long elapsedTime = 33L;

    A3VirtualUniverse(A3CanvasInterface c) {
        this.canvas = c;
        if (this.canvas instanceof A3Canvas) {
            this.init((Canvas3D)c);
        } else if (this.canvas instanceof JA3Canvas) {
            this.init(((JA3Canvas)this.canvas).getOffscreenCanvas3D());
        } else if (this.canvas instanceof A3Widget) {
            this.init(((A3Widget)this.canvas).tCanvas.getOffscreenCanvas3D());
        } else if (this.canvas instanceof JA3Canvas2) {
            this.init(((JA3Canvas2)this.canvas).getOffscreenCanvas3D());
        }
    }

    void init(Canvas3D c3d) {
        this.canvas3d = c3d;
        this.locale = new Locale((VirtualUniverse)this);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(this.canvas3d);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.view.setFrontClipDistance(0.1);
        this.view.setBackClipDistance(100.0);
        this.view.setUserHeadToVworldEnable(true);
        this.view.setProjectionPolicy(1);
        this.view.setDepthBufferFreezeTransparent(true);
        this.vpGroup = new BranchGroup();
        this.tGroup = new TransformGroup();
        this.tGroup.setCapability(18);
        this.tGroup.setCapability(17);
        this.tGroup.setCapability(14);
        this.tGroup.setCapability(13);
        this.vpGroup.addChild((Node)this.tGroup);
        this.transform = new Transform3D();
        this.tGroup.setTransform(this.transform);
        this.timerBehavior = new TimerBehavior(this);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.timerBehavior.setSchedulingBounds((Bounds)bs);
        this.tGroup.addChild((Node)this.timerBehavior);
        this.vp = new ViewPlatform();
        this.tGroup.addChild((Node)this.vp);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.headLight.setEnable(true);
        this.tGroup.addChild((Node)this.headLight);
        this.view.attachViewPlatform(this.vp);
        this.pickingBehavior = new PickingBehavior(this.canvas, this.locale);
        this.vpGroup.addChild((Node)this.pickingBehavior);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.pickingBehavior.setSchedulingBounds((Bounds)sb);
        this.cameraBehavior = new CameraBehavior(this);
        this.vpGroup.addChild((Node)this.cameraBehavior);
        this.cameraBehavior.setSchedulingBounds((Bounds)sb);
        BranchGroup emphasizerAABG = new BranchGroup();
        Appearance a = new Appearance();
        Material m = new Material();
        m.setCapability(1);
        a.setMaterial(m);
        this.emphasizerAA = new AlternateAppearance(a);
        this.emphasizerAA.setCapability(17);
        this.emphasizerAA.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.emphasizerAA.addScope(new Group());
        emphasizerAABG.addChild((Node)this.emphasizerAA);
        this.timerBehavior.setEmphasizerMaterial(m);
        BranchGroup polygonizerAABG = new BranchGroup();
        Appearance a2 = new Appearance();
        PolygonAttributes attr = new PolygonAttributes();
        attr.setPolygonMode(1);
        a2.setPolygonAttributes(attr);
        this.polygonizerAA = new AlternateAppearance(a2);
        this.polygonizerAA.setCapability(17);
        this.polygonizerAA.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
        this.polygonizerAA.addScope(new Group());
        polygonizerAABG.addChild((Node)this.polygonizerAA);
        this.rootGroup = new BranchGroup();
        this.rootGroup.setCapability(14);
        this.rootGroup.setCapability(13);
        this.rootGroup.addChild((Node)this.vpGroup);
        this.rootGroup.addChild((Node)emphasizerAABG);
        this.rootGroup.addChild((Node)polygonizerAABG);
        this.locale.addBranchGraph(this.rootGroup);
        JavaSoundMixer mixer = null;
        String mixerClassName = AccessController.doPrivilegedWithCombiner(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("j3d.audiodevice");
            }
        });
        if (mixerClassName != null) {
            try {
                Class<?> c = Class.forName(mixerClassName);
                Class<AudioDevice> mixerClass = c.asSubclass(AudioDevice.class);
                Constructor<AudioDevice> constructor = mixerClass.getConstructor(PhysicalEnvironment.class);
                mixer = constructor.newInstance(environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mixer == null) {
            try {
                mixer = new JavaSoundMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            System.out.println("null AudioDevice!");
        } else {
            System.out.println("j3d.audiodevice=" + mixer.getClass().getName());
            environment.setAudioDevice((AudioDevice)mixer);
            try {
                mixer.initialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String action3dSoundType = AccessController.doPrivilegedWithCombiner(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("acerola3d.action3d.sound");
            }
        });
        if (action3dSoundType == null || !action3dSoundType.equals("J3D_AUDIODEVICE")) {
            Action3DData.soundSystem = A3SoundSystem.getDefaultSoundSystem();
            System.out.println("acerola3d.action3d.sound=JOAL_DIRECT");
        } else {
            System.out.println("acerola3d.action3d.sound=J3D_AUDIODEVICE");
        }
        this.scene = new Scene(this, 0);
        this.scenes.put(0, this.scene);
        this.scene.activate();
    }

    TimerBehavior getTimerBehavior() {
        return this.timerBehavior;
    }

    void prepareVirtualUniverse() {
    }

    @Override
    public void add(A3Object a) {
        this.scene.add(a);
    }

    @Override
    public void del(A3Object a) {
        this.scene.del(a);
    }

    @Override
    public void delAll() {
        this.scene.delAll();
    }

    @Override
    public void delAll(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delAll();
    }

    @Override
    public void setBackground(A3Object a) {
        this.scene.setBackground(a);
    }

    @Override
    public void delBackground() {
        this.scene.delBackground();
    }

    @Override
    public void setAvatar(A3Object a) {
        this.scene.setAvatar(a);
    }

    @Override
    public A3Object getAvatar() {
        return this.scene.getAvatar();
    }

    @Override
    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    @Override
    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z) {
        this.scene.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc) {
        this.scene.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double ay, double z, double w) {
        this.scene.setDefaultCameraQuat(x, ay, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat) {
        this.scene.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z) {
        this.scene.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot) {
        this.scene.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraRev(double x, double y, double z) {
        this.scene.setDefaultCameraRev(x, y, z);
    }

    @Override
    public void setDefaultCameraRev(Vector3d rev) {
        this.scene.setDefaultCameraRev(rev);
    }

    @Override
    public void setDefaultCameraScale(double s) {
        this.scene.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera() {
        this.scene.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z) {
        this.scene.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc) {
        this.scene.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z) {
        this.scene.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc) {
        this.scene.setCameraLocImmediately(loc);
    }

    @Override
    public void addCameraLoc(double x, double y, double z) {
        this.scene.addCameraLoc(x, y, z);
    }

    @Override
    public void addCameraLoc(Vector3d loc) {
        this.scene.addCameraLoc(loc);
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z) {
        this.scene.addCameraLocImmediately(x, y, z);
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc) {
        this.scene.setCameraLocImmediately(loc);
    }

    @Override
    public void moveCameraForward(double l) {
        this.scene.moveCameraForward(l);
    }

    @Override
    public void moveCameraForwardImmediately(double l) {
        this.scene.moveCameraForwardImmediately(l);
    }

    @Override
    public void moveCameraBackward(double l) {
        this.scene.moveCameraBackward(l);
    }

    @Override
    public void moveCameraBackwardImmediately(double l) {
        this.scene.moveCameraBackwardImmediately(l);
    }

    @Override
    public void moveCameraRight(double l) {
        this.scene.moveCameraRight(l);
    }

    @Override
    public void moveCameraRightImmediately(double l) {
        this.scene.moveCameraRightImmediately(l);
    }

    @Override
    public void moveCameraLeft(double l) {
        this.scene.moveCameraLeft(l);
    }

    @Override
    public void moveCameraLeftImmediately(double l) {
        this.scene.moveCameraLeftImmediately(l);
    }

    @Override
    public void moveCameraUp(double l) {
        this.scene.moveCameraUp(l);
    }

    @Override
    public void moveCameraUpImmediately(double l) {
        this.scene.moveCameraUpImmediately(l);
    }

    @Override
    public void moveCameraDown(double l) {
        this.scene.moveCameraDown(l);
    }

    @Override
    public void moveCameraDownImmediately(double l) {
        this.scene.moveCameraDownImmediately(l);
    }

    @Override
    public void moveCameraForward(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraForward(l);
    }

    @Override
    public void moveCameraForwardImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraForwardImmediately(l);
    }

    @Override
    public void moveCameraBackward(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraBackward(l);
    }

    @Override
    public void moveCameraBackwardImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraBackwardImmediately(l);
    }

    @Override
    public void moveCameraRight(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraRight(l);
    }

    @Override
    public void moveCameraRightImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraRightImmediately(l);
    }

    @Override
    public void moveCameraLeft(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraLeft(l);
    }

    @Override
    public void moveCameraLeftImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraLeftImmediately(l);
    }

    @Override
    public void moveCameraUp(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraUp(l);
    }

    @Override
    public void moveCameraUpImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraUpImmediately(l);
    }

    @Override
    public void moveCameraDown(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraDown(l);
    }

    @Override
    public void moveCameraDownImmediately(double l, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.moveCameraDownImmediately(l);
    }

    @Override
    public Vector3d getCameraLoc() {
        return this.scene.getCameraLoc();
    }

    @Override
    public Vector3d getCameraTargetLoc() {
        return this.scene.getCameraTargetLoc();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w) {
        this.scene.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat) {
        this.scene.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.scene.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat) {
        this.scene.setCameraQuatImmediately(quat);
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w) {
        this.scene.mulCameraQuat(x, y, z, w);
    }

    @Override
    public void mulCameraQuat(Quat4d quat) {
        this.scene.mulCameraQuat(quat);
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w) {
        this.scene.mulCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat) {
        this.scene.mulCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat() {
        return this.scene.getCameraQuat();
    }

    @Override
    public Quat4d getCameraTargetQuat() {
        return this.scene.getCameraTargetQuat();
    }

    @Override
    public void setCameraRot(double x, double y, double z) {
        this.scene.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot) {
        this.scene.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z) {
        this.scene.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot) {
        this.scene.setCameraRotImmediately(rot);
    }

    @Override
    public void mulCameraRot(double x, double y, double z) {
        this.scene.mulCameraRot(x, y, z);
    }

    @Override
    public void mulCameraRot(Vector3d rot) {
        this.scene.mulCameraRot(rot);
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z) {
        this.scene.mulCameraRotImmediately(x, y, z);
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot) {
        this.scene.mulCameraRotImmediately(rot);
    }

    @Override
    public Vector3d getCameraRot() {
        return this.scene.getCameraRot();
    }

    @Override
    public Vector3d getCameraTargetRot() {
        return this.scene.getCameraTargetRot();
    }

    @Override
    public void setCameraRev(double x, double y, double z) {
        this.scene.setCameraRot(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z);
    }

    @Override
    public void setCameraRev(Vector3d rev) {
        this.scene.setCameraRot(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z);
    }

    @Override
    public void setCameraRevImmediately(double x, double y, double z) {
        this.scene.setCameraRotImmediately(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z);
    }

    @Override
    public void setCameraRevImmediately(Vector3d rev) {
        this.scene.setCameraRotImmediately(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z);
    }

    @Override
    public void mulCameraRev(double x, double y, double z) {
        this.scene.mulCameraRot(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z);
    }

    @Override
    public void mulCameraRev(Vector3d rev) {
        this.scene.mulCameraRot(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z);
    }

    @Override
    public void mulCameraRevImmediately(double x, double y, double z) {
        this.scene.mulCameraRotImmediately(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z);
    }

    @Override
    public void mulCameraRevImmediately(Vector3d rev) {
        this.scene.mulCameraRotImmediately(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z);
    }

    @Override
    public Vector3d getCameraRev() {
        Vector3d ret = this.scene.getCameraRot();
        ret.scale(57.29577951308232);
        return ret;
    }

    @Override
    public Vector3d getCameraTargetRev() {
        Vector3d ret = this.scene.getCameraTargetRot();
        ret.scale(57.29577951308232);
        return ret;
    }

    @Override
    public void setCameraScale(double s) {
        this.scene.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s) {
        this.scene.setCameraScaleImmediately(s);
    }

    @Override
    public void mulCameraScale(double s) {
        this.scene.mulCameraScale(s);
    }

    @Override
    public void mulCameraScaleImmediately(double s) {
        this.scene.mulCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale() {
        return this.scene.getCameraScale();
    }

    @Override
    public double getCameraTargetScale() {
        return this.scene.getCameraTargetScale();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt) {
        this.scene.setCameraLookAtPoint(lookAt);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt) {
        this.scene.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z) {
        this.scene.setCameraLookAtPoint(x, y, z);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z) {
        this.scene.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        this.scene.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        this.scene.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.scene.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m, Object ... params) {
        this.scene.setNavigationMode(m, params);
    }

    @Override
    public void setNavigationSpeed(double s) {
        this.scene.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed() {
        return this.scene.getNavigationSpeed();
    }

    @Override
    public void setA3Controller(A3Controller c) {
        this.scene.setA3Controller(c);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y) {
        return this.pickingBehavior.canvasToVirtualCS(x, y);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToVirtualCS(x, y, dis);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y, dis);
    }

    @Override
    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        Point3d p = this.pickingBehavior.physicalCSToVirtualCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Point physicalCSToCanvas(Point3d p) {
        return this.pickingBehavior.physicalCSToCanvas(p);
    }

    @Override
    public Point virtualCSToCanvas(Point3d p) {
        return this.pickingBehavior.virtualCSToCanvas(p);
    }

    @Override
    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        Point3d p = this.pickingBehavior.virtualCSToPhysicalCS(new Point3d((Tuple3d)v));
        return new Vector3d((Tuple3d)p);
    }

    @Override
    public Vector3d getCameraUnitVecX() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(1.0, 0.0, 0.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecY() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 1.0, 0.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public Vector3d getCameraUnitVecZ() {
        Vector3d v = this.physicalCSToVirtualCS(new Vector3d(0.0, 0.0, 1.0));
        v.sub((Tuple3d)this.scene.cameraNowV);
        return v;
    }

    @Override
    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }

    @Override
    public A3Object pick(Vector3d origin, Vector3d dir) {
        return this.pickingBehavior.pickA3(origin, dir);
    }

    @Override
    public void prepareScene(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            s = new Scene(this, scene);
            this.scenes.put(scene, s);
        }
    }

    @Override
    public void changeActiveScene(int s) {
        Scene newScene = this.scenes.get(s);
        if (newScene == null) {
            throw new IllegalArgumentException();
        }
        this.scene.deactivate();
        this.scene = newScene;
        this.transform.set(this.scene.cameraNowQ, this.scene.cameraNowV, this.scene.cameraNowS);
        this.tGroup.setTransform(this.transform);
        this.scene.activate();
    }

    @Override
    public void add(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.add(a);
    }

    @Override
    public void del(A3Object a, int s) {
        Scene tmpScene = this.scenes.get(s);
        if (tmpScene == null) {
            throw new IllegalArgumentException();
        }
        tmpScene.del(a);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(x, y, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraRev(double x, double y, double z, int scene) {
        this.setDefaultCameraRot(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z, scene);
    }

    @Override
    public void setDefaultCameraRev(Vector3d rev, int scene) {
        this.setDefaultCameraRot(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z, scene);
    }

    @Override
    public void setDefaultCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLocImmediately(loc);
    }

    @Override
    public void addCameraLoc(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addCameraLoc(x, y, z);
    }

    @Override
    public void addCameraLoc(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addCameraLoc(loc);
    }

    @Override
    public void addCameraLocImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addCameraLocImmediately(x, y, z);
    }

    @Override
    public void addCameraLocImmediately(Vector3d loc, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addCameraLocImmediately(loc);
    }

    @Override
    public Vector3d getCameraLoc(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraLoc();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector3d getCameraTargetLoc(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraTargetLoc();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraQuatImmediately(quat);
    }

    @Override
    public void mulCameraQuat(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraQuat(x, y, z, w);
    }

    @Override
    public void mulCameraQuat(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraQuat(quat);
    }

    @Override
    public void mulCameraQuatImmediately(double x, double y, double z, double w, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void mulCameraQuatImmediately(Quat4d quat, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraQuat();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Quat4d getCameraTargetQuat(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraTargetQuat();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraRotImmediately(rot);
    }

    @Override
    public void mulCameraRot(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraRot(x, y, z);
    }

    @Override
    public void mulCameraRot(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraRot(rot);
    }

    @Override
    public void mulCameraRotImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraRotImmediately(x, y, z);
    }

    @Override
    public void mulCameraRotImmediately(Vector3d rot, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.mulCameraRotImmediately(rot);
    }

    @Override
    public Vector3d getCameraRot(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraRot();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector3d getCameraTargetRot(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraTargetRot();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraRev(double x, double y, double z, int scene) {
        this.setCameraRot(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z, scene);
    }

    @Override
    public void setCameraRev(Vector3d rev, int scene) {
        this.setCameraRot(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z);
    }

    @Override
    public void setCameraRevImmediately(double x, double y, double z, int scene) {
        this.setCameraRotImmediately(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z, scene);
    }

    @Override
    public void setCameraRevImmediately(Vector3d rev, int scene) {
        this.setCameraRotImmediately(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z, scene);
    }

    @Override
    public void mulCameraRev(double x, double y, double z, int scene) {
        this.mulCameraRot(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z, scene);
    }

    @Override
    public void mulCameraRev(Vector3d rev, int scene) {
        this.mulCameraRot(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z, scene);
    }

    @Override
    public void mulCameraRevImmediately(double x, double y, double z, int scene) {
        this.mulCameraRotImmediately(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z, scene);
    }

    @Override
    public void mulCameraRevImmediately(Vector3d rev, int scene) {
        this.mulCameraRotImmediately(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z, scene);
    }

    @Override
    public Vector3d getCameraRev(int scene) {
        Vector3d ret = this.getCameraRot(scene);
        ret.scale(57.29577951308232);
        return ret;
    }

    @Override
    public Vector3d getCameraTargetRev(int scene) {
        Vector3d ret = this.getCameraTargetRot(scene);
        ret.scale(57.29577951308232);
        return ret;
    }

    @Override
    public void setCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setCameraScaleImmediately(s);
    }

    @Override
    public void mulCameraScale(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.mulCameraScale(s);
    }

    @Override
    public void mulCameraScaleImmediately(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.mulCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraScale();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getCameraTargetScale(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getCameraTargetScale();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(lookAt);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(lookAt);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(x, y, z);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(x, y, z);
    }

    @Override
    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(lookAt, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(lookAt, up);
    }

    @Override
    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPoint(x, y, z, up);
    }

    @Override
    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setCameraLookAtPointImmediately(x, y, z, up);
    }

    @Override
    public void setNavigationMode(int scene, A3CanvasInterface.NaviMode m, Object ... params) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setNavigationMode(m, params);
    }

    @Override
    public void setNavigationSpeed(double s, int scene) {
        Scene sTmp = this.scenes.get(scene);
        if (sTmp == null) {
            throw new IllegalArgumentException();
        }
        sTmp.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getNavigationSpeed();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setA3Controller(A3Controller c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setA3Controller(c);
    }

    @Override
    public void setBackground(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setBackground(a);
    }

    @Override
    public void delBackground(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delBackground();
    }

    @Override
    public void setAvatar(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setAvatar(a);
    }

    @Override
    public A3Object getAvatar(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.getAvatar();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void add(Component2D c) {
        this.scene.add(c);
    }

    @Override
    public void del(Component2D c) {
        this.scene.del(c);
    }

    @Override
    public void add(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.add(c);
    }

    @Override
    public void del(Component2D c, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.del(c);
    }

    ArrayList<Component2D> getComponents2D() {
        return this.scene.getComponents2D();
    }

    @Override
    public void addLockedA3(A3Object a) {
        this.scene.addLockedA3(a);
    }

    @Override
    public void delLockedA3(A3Object a) {
        this.scene.delLockedA3(a);
    }

    @Override
    public void delAllLockedA3() {
        this.scene.delAllLockedA3();
    }

    @Override
    public void addLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.addLockedA3(a);
    }

    @Override
    public void delLockedA3(A3Object a, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delLockedA3(a);
    }

    @Override
    public void delAllLockedA3(int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.delAllLockedA3();
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d) {
        this.scene.setUpperDirection(d);
    }

    @Override
    public void setUpperDirection(A3Object.UpperDirection d, int scene) {
        Scene s = this.scenes.get(scene);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setUpperDirection(d);
    }

    @Override
    public A3Object.UpperDirection getUpperDirection() {
        return this.scene.upperDirection;
    }

    @Override
    public A3Object.UpperDirection getUpperDirection(int scene) {
        Scene s = this.scenes.get(scene);
        if (s != null) {
            return s.upperDirection;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addKeyListener(KeyListener l) {
    }

    @Override
    public void removeKeyListener(KeyListener l) {
    }

    @Override
    public int getFPS() {
        return 0;
    }

    @Override
    public void setUpdateInterval(long l) {
        this.elapsedTime = l;
    }

    @Override
    public long getUpdateInterval() {
        return this.elapsedTime;
    }

    @Override
    public void waitForUpdate(long timeout) {
        this.timerBehavior.waitForUpdate(timeout);
    }

    @Override
    public void insertTaskIntoRenderingLoop(Runnable task) {
    }

    @Override
    public void removeTaskFromRenderingLoop(Runnable task) {
    }

    @Override
    public void insertTaskIntoTimerLoop(Runnable task) {
        this.timerBehavior.insertTaskIntoTimerLoop(task);
    }

    @Override
    public void removeTaskFromTimerLoop(Runnable task) {
        this.timerBehavior.removeTaskFromTimerLoop(task);
    }

    @Override
    public void setCameraInterpolateRatio(double ir) {
        this.cameraBehavior.setInterpolateRatio(ir);
    }

    @Override
    public void setDepthBufferFreezeTransparent(boolean b) {
        this.view.setDepthBufferFreezeTransparent(b);
    }

    @Override
    public void saveImage(File file) throws IOException {
    }

    @Override
    public BufferedImage snapshot() {
        return null;
    }

    @Override
    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
    }

    @Override
    public Dimension getCanvasSize() {
        return null;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void addA3SubCanvas(A3CanvasInterface sc) {
        PickingBehavior pb = new PickingBehavior(sc, this.locale);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        pb.setSchedulingBounds((Bounds)sb);
        sc.setPickingBehavior(pb);
        sc.setVirtualUniverse(this);
        BranchGroup bg = sc.getBranchGroupForViewPlatform();
        this.locale.addBranchGraph(bg);
    }

    @Override
    public void setProjectionMode(ProjectionMode m) {
        if (m == ProjectionMode.PERSPECTIVE) {
            this.view.setProjectionPolicy(1);
            this.view.setScreenScalePolicy(0);
        } else if (m == ProjectionMode.PARALLEL) {
            this.view.setProjectionPolicy(0);
            this.view.setScreenScalePolicy(1);
        }
    }

    @Override
    public void setCanvasWidthInPWorld(double s) {
        double psw = this.canvas3d.getScreen3D().getPhysicalScreenWidth();
        this.view.setScreenScale(psw / s);
    }

    @Override
    public void setFieldOfView(double f) {
        this.view.setFieldOfView(f);
    }

    @Override
    public TransformGroup getTransformGroupForViewPlatform() {
        return this.tGroup;
    }

    @Override
    public Canvas3D getCanvas3D() {
        return this.canvas3d;
    }

    @Override
    public void setSoundGain(double g) {
        Action3DData.soundSystem.setListenerGain(g);
    }

    @Override
    public double getSoundGain() {
        return Action3DData.soundSystem.getListenerGain();
    }

    @Override
    public BranchGroup getBranchGroupForViewPlatform() {
        return null;
    }

    @Override
    public void setPickingBehavior(PickingBehavior pb) {
    }

    @Override
    public void setVirtualUniverse(A3VirtualUniverse vu) {
    }

    @Override
    public A3VirtualUniverse getVirtualUniverse() {
        return this;
    }

    void emphasize(A3Object a3) {
        this.emphasize((Group)a3.getNode());
    }

    void unemphasize(A3Object a3) {
        this.unemphasize((Group)a3.getNode());
    }

    void emphasize(Group g) {
        this.emphasize_OLD(g);
    }

    void emphasize_NEW(final Group g) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (A3VirtualUniverse.this.emphasizerAA.indexOfScope(g) != -1) {
                    return;
                }
                A3VirtualUniverse.this.emphasizerAA.addScope(g);
            }
        };
        this.timerBehavior.addRunnable(r);
    }

    void emphasize_OLD(Group g) {
        if (this.emphasizerAA.indexOfScope(g) != -1) {
            return;
        }
        this.emphasizerAA.addScope(g);
    }

    void unemphasize(Group g) {
        this.unemphasize_OLD(g);
    }

    void unemphasize_NEW(final Group g) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (A3VirtualUniverse.this.emphasizerAA.indexOfScope(g) == -1) {
                    return;
                }
                A3VirtualUniverse.this.emphasizerAA.removeScope(g);
            }
        };
        this.timerBehavior.addRunnable(r);
    }

    void unemphasize_OLD(Group g) {
        if (this.emphasizerAA.indexOfScope(g) == -1) {
            return;
        }
        this.emphasizerAA.removeScope(g);
    }

    void polygonize(A3Object a3) {
        this.polygonize((Group)a3.getNode());
    }

    void unpolygonize(A3Object a3) {
        this.unpolygonize((Group)a3.getNode());
    }

    void polygonize(Group g) {
        this.polygonize_OLD(g);
    }

    void polygonize_NEW(final Group g) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (A3VirtualUniverse.this.polygonizerAA.indexOfScope(g) != -1) {
                    return;
                }
                A3VirtualUniverse.this.polygonizerAA.addScope(g);
            }
        };
        this.timerBehavior.addRunnable(r);
    }

    void polygonize_OLD(Group g) {
        if (this.polygonizerAA.indexOfScope(g) != -1) {
            return;
        }
        this.polygonizerAA.addScope(g);
    }

    void unpolygonize(Group g) {
        this.unpolygonize_OLD(g);
    }

    void unpolygonize_NEW(final Group g) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (A3VirtualUniverse.this.polygonizerAA.indexOfScope(g) == -1) {
                    return;
                }
                A3VirtualUniverse.this.polygonizerAA.removeScope(g);
            }
        };
        this.timerBehavior.addRunnable(r);
    }

    void unpolygonize_OLD(Group g) {
        if (this.polygonizerAA.indexOfScope(g) == -1) {
            return;
        }
        this.polygonizerAA.removeScope(g);
    }
}

