/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Util;

class SubCameraBehavior
extends Behavior {
    TransformGroup tg;
    Transform3D t = new Transform3D();
    Vector3d cameraNowV = new Vector3d();
    Vector3d cameraNextV = new Vector3d();
    Quat4d cameraNowQ = new Quat4d();
    Quat4d cameraNextQ = new Quat4d();
    double cameraNowS = 1.0;
    double cameraNextS = 1.0;
    Vector3d cameraDefaultV = new Vector3d();
    Quat4d cameraDefaultQ = new Quat4d();
    double cameraDefaultS = 1.0;
    A3VirtualUniverse virtualUniverse = null;
    double interpolateRatio = 0.1;

    SubCameraBehavior(TransformGroup tg) {
        this.tg = tg;
    }

    void setA3VirtualUniverse(A3VirtualUniverse u) {
        this.virtualUniverse = u;
    }

    public void initialize() {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(null, 1);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(null, 1);
        this.wakeupOn((WakeupCondition)w);
        double ratio = 1.0 - Math.pow(this.interpolateRatio, (double)this.virtualUniverse.elapsedTime / 1000.0);
        this.cameraNowS += ratio * (this.cameraNextS - this.cameraNowS);
        this.cameraNowQ.normalize();
        this.cameraNowQ.interpolate(this.cameraNextQ, ratio);
        this.cameraNowQ.normalize();
        this.cameraNowV.interpolate((Tuple3d)this.cameraNextV, ratio);
        this.t.set(this.cameraNowQ, this.cameraNowV, this.cameraNowS);
        try {
            this.tg.setTransform(this.t);
        }
        catch (BadTransformException e) {
            System.out.println("BadTransformException in SubCameraBehavior.processStimulus().");
            this.cameraNowS = 1.0;
            this.cameraNowQ.set(0.0, 0.0, 0.0, 1.0);
            this.cameraNowV.set(0.0, 0.0, 0.0);
        }
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.cameraDefaultV.set(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.cameraDefaultV.set((Tuple3d)loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.cameraDefaultQ.set(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.cameraDefaultQ.set((Tuple4d)quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.cameraDefaultQ.set((Tuple4d)Util.euler2quat(x, y, z));
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.cameraDefaultQ.set((Tuple4d)Util.euler2quat(rot));
    }

    public void setDefaultCameraRev(double x, double y, double z) {
        this.cameraDefaultQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z));
    }

    public void setDefaultCameraRev(Vector3d rev) {
        this.cameraDefaultQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public void setDefaultCameraScale(double s) {
        this.cameraDefaultS = s;
    }

    public void resetCamera() {
        this.cameraNowV.set((Tuple3d)this.cameraDefaultV);
        this.cameraNextV.set((Tuple3d)this.cameraDefaultV);
        this.cameraNowQ.set((Tuple4d)this.cameraDefaultQ);
        this.cameraNextQ.set((Tuple4d)this.cameraDefaultQ);
        this.cameraNowS = this.cameraDefaultS;
        this.cameraNextS = this.cameraDefaultS;
    }

    public void setCameraLoc(double x, double y, double z) {
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.cameraNowV.set(x, y, z);
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.cameraNowV.set((Tuple3d)loc);
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void addCameraLoc(double x, double y, double z) {
        this.cameraNextV.x += x;
        this.cameraNextV.y += y;
        this.cameraNextV.z += z;
    }

    public void addCameraLoc(Vector3d loc) {
        this.cameraNextV.add((Tuple3d)loc);
    }

    public void addCameraLocImmediately(double x, double y, double z) {
        this.cameraNextV.x += x;
        this.cameraNextV.y += y;
        this.cameraNextV.z += z;
        this.cameraNowV.set((Tuple3d)this.cameraNextV);
    }

    public void addCameraLocImmediately(Vector3d loc) {
        this.cameraNextV.add((Tuple3d)loc);
        this.cameraNowV.set((Tuple3d)this.cameraNextV);
    }

    public void moveCameraForward(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 0.0, 1.0));
        v.scale(-l);
        this.addCameraLoc(v);
    }

    public void moveCameraForwardImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 0.0, 1.0));
        v.scale(-l);
        this.addCameraLocImmediately(v);
    }

    public void moveCameraBackward(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 0.0, 1.0));
        v.scale(l);
        this.addCameraLoc(v);
    }

    public void moveCameraBackwardImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 0.0, 1.0));
        v.scale(l);
        this.addCameraLocImmediately(v);
    }

    public void moveCameraRight(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(1.0, 0.0, 0.0));
        v.scale(l);
        this.addCameraLoc(v);
    }

    public void moveCameraRightImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(1.0, 0.0, 0.0));
        v.scale(l);
        this.addCameraLocImmediately(v);
    }

    public void moveCameraLeft(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(1.0, 0.0, 0.0));
        v.scale(-l);
        this.addCameraLoc(v);
    }

    public void moveCameraLeftImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(1.0, 0.0, 0.0));
        v.scale(-l);
        this.addCameraLocImmediately(v);
    }

    public void moveCameraUp(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 1.0, 0.0));
        v.scale(l);
        this.addCameraLoc(v);
    }

    public void moveCameraUpImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 1.0, 0.0));
        v.scale(l);
        this.addCameraLocImmediately(v);
    }

    public void moveCameraDown(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 1.0, 0.0));
        v.scale(-l);
        this.addCameraLoc(v);
    }

    public void moveCameraDownImmediately(double l) {
        Vector3d v = Util.trans(this.cameraNowQ, new Vector3d(0.0, 1.0, 0.0));
        v.scale(-l);
        this.addCameraLocImmediately(v);
    }

    public Vector3d getCameraLoc() {
        return new Vector3d(this.cameraNowV);
    }

    public Vector3d getCameraTargetLoc() {
        return new Vector3d(this.cameraNextV);
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNowQ.set(x, y, z, w);
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.cameraNowQ.set((Tuple4d)quat);
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void mulCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.mul(new Quat4d(x, y, z, w));
    }

    public void mulCameraQuat(Quat4d quat) {
        this.cameraNextQ.mul(quat);
    }

    public void mulCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNextQ.mul(new Quat4d(x, y, z, w));
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void mulCameraQuatImmediately(Quat4d quat) {
        this.cameraNextQ.mul(quat);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public Quat4d getCameraQuat() {
        return new Quat4d(this.cameraNowQ);
    }

    public Quat4d getCameraTargetQuat() {
        return new Quat4d(this.cameraNextQ);
    }

    public void setCameraRot(double x, double y, double z) {
        this.cameraNextQ.set((Tuple4d)Util.euler2quat(x, y, z));
    }

    public void setCameraRot(Vector3d rot) {
        this.cameraNextQ.set((Tuple4d)Util.euler2quat(rot));
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.cameraNowQ.set((Tuple4d)Util.euler2quat(x, y, z));
        this.cameraNextQ.set((Tuple4d)this.cameraNowQ);
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.cameraNowQ.set((Tuple4d)Util.euler2quat(rot));
        this.cameraNextQ.set((Tuple4d)this.cameraNowQ);
    }

    public void mulCameraRot(double x, double y, double z) {
        this.cameraNextQ.mul(Util.euler2quat(x, y, z));
    }

    public void mulCameraRot(Vector3d rot) {
        this.cameraNextQ.mul(Util.euler2quat(rot));
    }

    public void mulCameraRotImmediately(double x, double y, double z) {
        this.cameraNextQ.mul(Util.euler2quat(x, y, z));
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void mulCameraRotImmediately(Vector3d rot) {
        this.cameraNextQ.mul(Util.euler2quat(rot));
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public Vector3d getCameraRot() {
        return Util.quat2euler(this.cameraNowQ);
    }

    public Vector3d getCameraTargetRot() {
        return Util.quat2euler(this.cameraNextQ);
    }

    public void setCameraRev(double x, double y, double z) {
        this.cameraNextQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z));
    }

    public void setCameraRev(Vector3d rev) {
        this.cameraNextQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public void setCameraRevImmediately(double x, double y, double z) {
        this.cameraNowQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z));
        this.cameraNextQ.set((Tuple4d)this.cameraNowQ);
    }

    public void setCameraRevImmediately(Vector3d rev) {
        this.cameraNowQ.set((Tuple4d)Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
        this.cameraNextQ.set((Tuple4d)this.cameraNowQ);
    }

    public void mulCameraRev(double x, double y, double z) {
        this.cameraNextQ.mul(Util.euler2quat(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z));
    }

    public void mulCameraRev(Vector3d rev) {
        this.cameraNextQ.mul(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
    }

    public void mulCameraRevImmediately(double x, double y, double z) {
        this.cameraNextQ.mul(Util.euler2quat(Math.PI / 180 * x, Math.PI / 180 * y, Math.PI / 180 * z));
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void mulCameraRevImmediately(Vector3d rev) {
        this.cameraNextQ.mul(Util.euler2quat(Math.PI / 180 * rev.x, Math.PI / 180 * rev.y, Math.PI / 180 * rev.z));
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public Vector3d getCameraRev() {
        Vector3d ret = Util.quat2euler(this.cameraNowQ);
        ret.scale(57.29577951308232);
        return ret;
    }

    public Vector3d getCameraTargetRev() {
        Vector3d ret = Util.quat2euler(this.cameraNextQ);
        ret.scale(57.29577951308232);
        return ret;
    }

    public void setCameraScale(double s) {
        this.cameraNextS = s;
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraNowS = s;
        this.cameraNextS = s;
    }

    public void mulCameraScale(double s) {
        this.cameraNextS *= s;
    }

    public void mulCameraScaleImmediately(double s) {
        this.cameraNextS *= s;
        this.cameraNowS = this.cameraNextS;
    }

    public double getCameraScale() {
        return this.cameraNowS;
    }

    public double getCameraTargetScale() {
        return this.cameraNextS;
    }

    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        Vector3d front = new Vector3d(lookAt);
        front.sub((Tuple3d)this.cameraNowV);
        this.cameraNextQ.set((Tuple4d)Util.frontFacingQuat_CAMERA(front, up));
    }

    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
        this.setCameraLookAtPoint(lookAt, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.setCameraLookAtPoint(lookAt, up);
    }

    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.setCameraLookAtPoint(x, y, z, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    void setInterpolateRatio(double ir) {
        this.interpolateRatio = ir;
    }
}

