/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.bulletphysics.collision.shapes.BvhTriangleMeshShape;
import com.bulletphysics.collision.shapes.ConvexHullShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.ShapeHull;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TriangleIndexVertexArray;
import com.bulletphysics.extras.gimpact.GImpactMeshShape;
import com.bulletphysics.util.ObjectArrayList;
import com.sun.j3d.loaders.Scene;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.a3.VRML;

public class Util {
    public static void cleanUp() {
    }

    public static Quat4d mul(Quat4d a, Quat4d b) {
        Quat4d ret = new Quat4d();
        ret.x = a.w * b.x + a.x * b.w + a.y * b.z - a.z * b.y;
        ret.y = a.w * b.y - a.x * b.z + a.y * b.w + a.z * b.x;
        ret.z = a.w * b.z + a.x * b.y - a.y * b.x + a.z * b.w;
        ret.w = a.w * b.w - a.x * b.x - a.y * b.y - a.z * b.z;
        return ret;
    }

    public static Vector3d trans(Quat4d q, Vector3d v) {
        Quat4d qc = new Quat4d();
        qc.x = -q.x;
        qc.y = -q.y;
        qc.z = -q.z;
        qc.w = q.w;
        Quat4d vq = new Quat4d();
        vq.x = v.x;
        vq.y = v.y;
        vq.z = v.z;
        vq.w = 0.0;
        vq.mul(q, vq);
        vq.mul(qc);
        return new Vector3d(vq.x, vq.y, vq.z);
    }

    public static Quat4d euler2quat(Vector3d v) {
        return Util.euler2quat(v.x, v.y, v.z);
    }

    public static Quat4d euler2quat(double x, double y, double z) {
        Quat4d q = new Quat4d(0.0, 0.0, 0.0, 1.0);
        q.mul(new Quat4d(0.0, Math.sin(y / 2.0), 0.0, Math.cos(y / 2.0)));
        q.mul(new Quat4d(Math.sin(x / 2.0), 0.0, 0.0, Math.cos(x / 2.0)));
        q.mul(new Quat4d(0.0, 0.0, Math.sin(z / 2.0), Math.cos(z / 2.0)));
        return q;
    }

    static Quat4d euler2quat_OLD(Vector3d v) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotY(v.y);
        t0.mul(t1);
        t1.rotX(v.x);
        t0.mul(t1);
        t1.rotZ(v.z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    public static Vector3d quat2euler(Quat4d q) {
        Matrix3d m = new Matrix3d();
        m.set(q);
        Vector3d ret = new Vector3d();
        if (m.m12 == 1.0) {
            ret.x = 1.5707963267948966;
            ret.y = Math.atan2(-m.m20, m.m00);
            ret.z = 0.0;
        } else if (m.m12 == -1.0) {
            ret.x = -1.5707963267948966;
            ret.y = Math.atan2(-m.m20, m.m00);
            ret.z = 0.0;
        } else {
            ret.x = Math.asin(-m.m12);
            ret.y = Math.atan2(m.m02, m.m22);
            ret.z = Math.atan2(m.m10, m.m11);
        }
        return ret;
    }

    public static Matrix3d quat2matrix(Quat4d q) {
        Matrix3d m = new Matrix3d();
        m.m00 = 1.0 - 2.0 * q.y * q.y - 2.0 * q.z * q.z;
        m.m01 = 2.0 * q.x * q.y - 2.0 * q.w * q.z;
        m.m02 = 2.0 * q.x * q.z + 2.0 * q.w * q.y;
        m.m10 = 2.0 * q.x * q.y + 2.0 * q.w * q.z;
        m.m11 = 1.0 - 2.0 * q.x * q.x - 2.0 * q.z * q.z;
        m.m12 = 2.0 * q.y * q.z - 2.0 * q.w * q.x;
        m.m20 = 2.0 * q.x * q.z - 2.0 * q.w * q.y;
        m.m21 = 2.0 * q.y * q.z + 2.0 * q.w * q.x;
        m.m22 = 1.0 - 2.0 * q.x * q.x - 2.0 * q.y * q.y;
        return m;
    }

    public static Quat4d matrix2quat(Matrix3d m) {
        double[] elem = new double[]{m.m00 - m.m11 - m.m22 + 1.0, -m.m00 + m.m11 - m.m22 + 1.0, -m.m00 - m.m11 + m.m22 + 1.0, m.m00 + m.m11 + m.m22 + 1.0};
        int biggestIndex = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(elem[i] > elem[biggestIndex])) continue;
            biggestIndex = i;
        }
        if (elem[biggestIndex] < 0.0) {
            return null;
        }
        double v = Math.sqrt(elem[biggestIndex]) * 0.5;
        double mult = 0.25 / v;
        Quat4d q = new Quat4d();
        switch (biggestIndex) {
            case 0: {
                q.x = v;
                q.y = (m.m10 + m.m01) * mult;
                q.z = (m.m02 + m.m20) * mult;
                q.w = (m.m21 - m.m12) * mult;
                break;
            }
            case 1: {
                q.x = (m.m10 + m.m01) * mult;
                q.y = v;
                q.z = (m.m21 + m.m12) * mult;
                q.w = (m.m02 - m.m20) * mult;
                break;
            }
            case 2: {
                q.x = (m.m02 + m.m20) * mult;
                q.y = (m.m21 + m.m12) * mult;
                q.z = v;
                q.w = (m.m10 - m.m01) * mult;
                break;
            }
            case 3: {
                q.x = (m.m21 - m.m12) * mult;
                q.y = (m.m02 - m.m20) * mult;
                q.z = (m.m10 - m.m01) * mult;
                q.w = v;
            }
        }
        return q;
    }

    public static Quat4d matrix2quat(Matrix3f m) {
        double[] elem = new double[]{(double)(m.m00 - m.m11 - m.m22) + 1.0, (double)(-m.m00 + m.m11 - m.m22) + 1.0, (double)(-m.m00 - m.m11 + m.m22) + 1.0, (double)(m.m00 + m.m11 + m.m22) + 1.0};
        int biggestIndex = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(elem[i] > elem[biggestIndex])) continue;
            biggestIndex = i;
        }
        if (elem[biggestIndex] < 0.0) {
            return null;
        }
        double v = Math.sqrt(elem[biggestIndex]) * 0.5;
        double mult = 0.25 / v;
        Quat4d q = new Quat4d();
        switch (biggestIndex) {
            case 0: {
                q.x = v;
                q.y = (double)(m.m10 + m.m01) * mult;
                q.z = (double)(m.m02 + m.m20) * mult;
                q.w = (double)(m.m21 - m.m12) * mult;
                break;
            }
            case 1: {
                q.x = (double)(m.m10 + m.m01) * mult;
                q.y = v;
                q.z = (double)(m.m21 + m.m12) * mult;
                q.w = (double)(m.m02 - m.m20) * mult;
                break;
            }
            case 2: {
                q.x = (double)(m.m02 + m.m20) * mult;
                q.y = (double)(m.m21 + m.m12) * mult;
                q.z = v;
                q.w = (double)(m.m10 - m.m01) * mult;
                break;
            }
            case 3: {
                q.x = (double)(m.m21 - m.m12) * mult;
                q.y = (double)(m.m02 - m.m20) * mult;
                q.z = (double)(m.m10 - m.m01) * mult;
                q.w = v;
            }
        }
        return q;
    }

    public static Quat4d a2bQuat(Vector3d a, Vector3d b) {
        double aLen = a.length();
        double bLen = b.length();
        double ct = a.dot(b) / aLen / bLen;
        double ct2 = Math.sqrt(0.5 * (1.0 + ct));
        double st2 = Math.sqrt(0.5 * (1.0 - ct));
        double k = Math.sqrt(bLen / aLen);
        Vector3d na = new Vector3d(a);
        na.normalize();
        Vector3d nb = new Vector3d(b);
        nb.normalize();
        Vector3d jiku = new Vector3d();
        jiku.cross(na, nb);
        if (jiku.length() < 1.0E-5) {
            if (ct > 0.0) {
                Quat4d ret = new Quat4d();
                ret.z = 0.0;
                ret.y = 0.0;
                ret.x = 0.0;
                ret.w = k;
                return ret;
            }
            Quat4d ret = new Quat4d();
            ret.w = 0.0;
            ret.z = 0.0;
            ret.x = 0.0;
            ret.y = k;
            return ret;
        }
        jiku.normalize();
        Quat4d ret = new Quat4d();
        ret.x = k * st2 * jiku.x;
        ret.y = k * st2 * jiku.y;
        ret.z = k * st2 * jiku.z;
        ret.w = k * ct2;
        return ret;
    }

    public static Quat4d frontFacingQuat(Vector3d oldFront, Vector3d oldTop, Vector3d newFront, Vector3d up) {
        Vector3d oldFrontN = new Vector3d(oldFront);
        oldFrontN.normalize();
        Vector3d oldTopN = new Vector3d(oldTop);
        oldTopN.normalize();
        Vector3d oldRightN = new Vector3d();
        oldRightN.cross(oldFrontN, oldTopN);
        Vector3d newFrontN = new Vector3d(newFront);
        newFrontN.normalize();
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        Matrix3d a = new Matrix3d();
        a.m00 = oldRightN.x;
        a.m01 = oldTopN.x;
        a.m02 = oldFrontN.x;
        a.m10 = oldRightN.y;
        a.m11 = oldTopN.y;
        a.m12 = oldFrontN.y;
        a.m20 = oldRightN.z;
        a.m21 = oldTopN.z;
        a.m22 = oldFrontN.z;
        a.invert();
        double dTmp = upN.dot(newFrontN);
        Vector3d vTmp1 = new Vector3d(newFrontN);
        vTmp1.scale(dTmp);
        Vector3d newTopN = new Vector3d(upN);
        newTopN.sub((Tuple3d)vTmp1);
        newTopN.normalize();
        Vector3d newRightN = new Vector3d();
        newRightN.cross(newFrontN, newTopN);
        Matrix3d b = new Matrix3d();
        b.m00 = newRightN.x;
        b.m01 = newTopN.x;
        b.m02 = newFrontN.x;
        b.m10 = newRightN.y;
        b.m11 = newTopN.y;
        b.m12 = newFrontN.y;
        b.m20 = newRightN.z;
        b.m21 = newTopN.z;
        b.m22 = newFrontN.z;
        b.mul(a);
        Quat4d q = Util.matrix2quat(b);
        return q;
    }

    public static Quat4d frontFacingQuat_A3Y(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, 0.0, 1.0);
            top.set(0.0, 1.0, 0.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = -right.x;
        m.m01 = top.x;
        m.m02 = frontN.x;
        m.m10 = -right.y;
        m.m11 = top.y;
        m.m12 = frontN.y;
        m.m20 = -right.z;
        m.m21 = top.z;
        m.m22 = frontN.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static Quat4d frontFacingQuat_A3Z(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, -1.0, 0.0);
            top.set(0.0, 0.0, 1.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = -right.x;
        m.m01 = -frontN.x;
        m.m02 = top.x;
        m.m10 = -right.y;
        m.m11 = -frontN.y;
        m.m12 = top.y;
        m.m20 = -right.z;
        m.m21 = -frontN.z;
        m.m22 = top.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static Quat4d frontFacingQuat_CAMERA(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, 0.0, -1.0);
            top.set(0.0, 1.0, 0.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = right.x;
        m.m01 = top.x;
        m.m02 = -frontN.x;
        m.m10 = right.y;
        m.m11 = top.y;
        m.m12 = -frontN.y;
        m.m20 = right.z;
        m.m21 = top.z;
        m.m22 = -frontN.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static Vector3d rev2rot(Vector3d rev) {
        Vector3d ret = new Vector3d(rev);
        ret.scale(Math.PI / 180);
        return ret;
    }

    public static Vector3d rot2rev(Vector3d rot) {
        Vector3d ret = new Vector3d(rot);
        ret.scale(57.29577951308232);
        return ret;
    }

    public static ConvexHullShape makeConvexHullShape(Node n) {
        ObjectArrayList vertexes1 = new ObjectArrayList();
        Transform3D t0 = new Transform3D();
        t0.setIdentity();
        Util.listingVertexes(n, (ObjectArrayList<Vector3f>)vertexes1, t0);
        ConvexHullShape chs1 = new ConvexHullShape(vertexes1);
        float margin = chs1.getMargin();
        ShapeHull sh = new ShapeHull((ConvexShape)chs1);
        sh.buildHull(margin);
        ObjectArrayList vertexes2 = sh.getVertexPointer();
        ConvexHullShape chs2 = new ConvexHullShape(vertexes2);
        return chs2;
    }

    public static ObjectArrayList<Vector3f> listingVertexes(Node n) {
        ObjectArrayList vertexes1 = new ObjectArrayList();
        Transform3D t0 = new Transform3D();
        t0.setIdentity();
        Util.listingVertexes(n, (ObjectArrayList<Vector3f>)vertexes1, t0);
        return vertexes1;
    }

    static void listingVertexes(Node n, ObjectArrayList<Vector3f> vertexes, Transform3D t0) {
        if (n instanceof Shape3D) {
            Shape3D s = (Shape3D)n;
            Transform3D t = new Transform3D();
            try {
                s.getLocalToVworld(t);
            }
            catch (Exception ee) {
                // empty catch block
            }
            int numGeo = s.numGeometries();
            for (int i = 0; i < numGeo; ++i) {
                Geometry geo = s.getGeometry(i);
                if (geo instanceof GeometryArray) {
                    GeometryArray ga = (GeometryArray)geo;
                    try {
                        int ici = ga.getInitialCoordIndex();
                        int vvc = ga.getValidVertexCount();
                        Point3f p = new Point3f();
                        for (int j = ici; j < ici + vvc; ++j) {
                            ga.getCoordinate(j, p);
                            t.transform(p);
                            vertexes.add((Object)new Vector3f((Tuple3f)p));
                        }
                        continue;
                    }
                    catch (Exception ee) {
                        continue;
                    }
                }
                System.out.println("Util.listingVertexes():" + geo.getClass().getName());
                System.out.print("  " + geo.getClass().getName());
                System.out.println(" is not GeometryArray.");
            }
        } else if (n instanceof Group) {
            Enumeration e = ((Group)n).getAllChildren();
            while (e.hasMoreElements()) {
                Util.listingVertexes((Node)e.nextElement(), vertexes, t0);
            }
        } else if (n instanceof Link) {
            Transform3D t = new Transform3D();
            try {
                n.getLocalToVworld(t);
            }
            catch (Exception ee) {
                // empty catch block
            }
            t.mul(t0, t);
            SharedGroup sg = ((Link)n).getSharedGroup();
            Enumeration e = sg.getAllChildren();
            while (e.hasMoreElements()) {
                Util.listingVertexes((Node)e.nextElement(), vertexes, t);
            }
        } else if (!(n instanceof Behavior)) {
            System.out.print("Util.listingVertexes().???: ");
            System.out.println(n.getClass().getName());
        }
    }

    static TriangleIndexVertexArray makeTriangleIndexVertexArray(Node n) {
        int vertStride = 12;
        int indexStride = 12;
        int[] iTmp = Util.countVertsAndTriangles(n);
        int totalVerts = iTmp[0];
        int totalTriangles = iTmp[1];
        ByteBuffer vertices = ByteBuffer.allocateDirect(totalVerts * vertStride).order(ByteOrder.nativeOrder());
        ByteBuffer gIndices = ByteBuffer.allocateDirect(totalTriangles * 3 * 4).order(ByteOrder.nativeOrder());
        Transform3D t0 = new Transform3D();
        t0.setIdentity();
        Util.makeVertsAndTriangles(n, vertices, gIndices, 0, t0);
        TriangleIndexVertexArray indexVertexArrays = new TriangleIndexVertexArray(totalTriangles, gIndices, indexStride, totalVerts, vertices, vertStride);
        return indexVertexArrays;
    }

    public static BvhTriangleMeshShape makeBvhTriangleMeshShape(Node n) {
        TriangleIndexVertexArray indexVertexArrays = Util.makeTriangleIndexVertexArray(n);
        boolean useQuantizedAabbCompression = true;
        BvhTriangleMeshShape shape = new BvhTriangleMeshShape((StridingMeshInterface)indexVertexArrays, useQuantizedAabbCompression);
        return shape;
    }

    public static GImpactMeshShape makeGImpactMeshShape(Node n) {
        TriangleIndexVertexArray indexVertexArrays = Util.makeTriangleIndexVertexArray(n);
        GImpactMeshShape shape = new GImpactMeshShape((StridingMeshInterface)indexVertexArrays);
        shape.updateBound();
        return shape;
    }

    static int[] countVertsAndTriangles(Node n) {
        int verCount = 0;
        int triCount = 0;
        if (n instanceof Shape3D) {
            Shape3D s = (Shape3D)n;
            int numGeo = s.numGeometries();
            for (int i = 0; i < numGeo; ++i) {
                Geometry geo = s.getGeometry(i);
                int triCountTmp = 0;
                int verCountTmp = 0;
                if (geo instanceof GeometryArray) {
                    GeometryArray ga = (GeometryArray)geo;
                    int vvc = ga.getValidVertexCount();
                    if (ga instanceof QuadArray) {
                        triCountTmp = vvc / 4 * 2;
                        verCountTmp = vvc / 4 * 2 * 3;
                    } else if (ga instanceof TriangleFanArray) {
                        int ns = ((TriangleFanArray)ga).getNumStrips();
                        triCountTmp = vvc - 2 * ns;
                        verCountTmp = (vvc - 2 * ns) * 3;
                    } else if (ga instanceof TriangleArray) {
                        triCountTmp = vvc / 3;
                        verCountTmp = vvc;
                    } else if (ga instanceof LineStripArray) {
                        triCountTmp = vvc / 2;
                        verCountTmp = vvc / 2 * 3;
                    } else {
                        System.out.println("GAHA1");
                    }
                } else {
                    System.out.println("GAHA2");
                }
                verCount += verCountTmp;
                triCount += triCountTmp;
            }
        } else if (n instanceof Group) {
            Enumeration e = ((Group)n).getAllChildren();
            while (e.hasMoreElements()) {
                int[] iTmp = Util.countVertsAndTriangles((Node)e.nextElement());
                verCount += iTmp[0];
                triCount += iTmp[1];
            }
        } else if (n instanceof Link) {
            SharedGroup sg = ((Link)n).getSharedGroup();
            Enumeration e = sg.getAllChildren();
            while (e.hasMoreElements()) {
                int[] iTmp = Util.countVertsAndTriangles((Node)e.nextElement());
                verCount += iTmp[0];
                triCount += iTmp[1];
            }
        } else if (!(n instanceof Behavior)) {
            System.out.println("GAHA3");
            System.out.println(n.getClass().getName());
        }
        int[] ret = new int[]{verCount, triCount};
        return ret;
    }

    static int makeVertsAndTriangles(Node n, ByteBuffer vertices, ByteBuffer gIndices, int idx, Transform3D t0) {
        if (n instanceof Shape3D) {
            Shape3D s = (Shape3D)n;
            Transform3D t = new Transform3D();
            try {
                s.getLocalToVworld(t);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            t.mul(t0, t);
            int numGeo = s.numGeometries();
            for (int i = 0; i < numGeo; ++i) {
                Geometry geo = s.getGeometry(i);
                if (geo instanceof GeometryArray) {
                    GeometryArray ga = (GeometryArray)geo;
                    if (ga instanceof QuadArray) {
                        idx = Util.addQuadArray(ga, vertices, gIndices, idx, t);
                        continue;
                    }
                    if (ga instanceof TriangleFanArray) {
                        idx = Util.addTriangleFanArray(ga, vertices, gIndices, idx, t);
                        continue;
                    }
                    if (ga instanceof TriangleArray) {
                        idx = Util.addTriangleArray(ga, vertices, gIndices, idx, t);
                        continue;
                    }
                    if (ga instanceof LineStripArray) {
                        idx = Util.addLineStripArray(ga, vertices, gIndices, idx, t);
                        continue;
                    }
                    System.out.println("GAHA4");
                    continue;
                }
                System.out.println("GAHA5");
            }
        } else if (n instanceof Group) {
            Enumeration e = ((Group)n).getAllChildren();
            while (e.hasMoreElements()) {
                idx = Util.makeVertsAndTriangles((Node)e.nextElement(), vertices, gIndices, idx, t0);
            }
        } else if (n instanceof Link) {
            Transform3D t = new Transform3D();
            try {
                n.getLocalToVworld(t);
            }
            catch (Exception ee) {
                // empty catch block
            }
            t.mul(t0, t);
            SharedGroup sg = ((Link)n).getSharedGroup();
            Enumeration e = sg.getAllChildren();
            while (e.hasMoreElements()) {
                idx = Util.makeVertsAndTriangles((Node)e.nextElement(), vertices, gIndices, idx, t);
            }
        } else if (!(n instanceof Behavior)) {
            System.out.println("GAHA6");
            System.out.println(n.getClass().getName());
        }
        return idx;
    }

    static int addQuadArray(GeometryArray ga, ByteBuffer vertices, ByteBuffer gIndices, int idx, Transform3D t) {
        int ici = ga.getInitialCoordIndex();
        int vvc = ga.getValidVertexCount();
        for (int i = ici; i < ici + vvc; i += 4) {
            Point3f p0 = new Point3f();
            Point3f p1 = new Point3f();
            Point3f p2 = new Point3f();
            Point3f p3 = new Point3f();
            ga.getCoordinate(i + 0, p0);
            t.transform(p0);
            ga.getCoordinate(i + 1, p1);
            t.transform(p1);
            ga.getCoordinate(i + 2, p2);
            t.transform(p2);
            ga.getCoordinate(i + 3, p3);
            t.transform(p3);
            vertices.putFloat(p0.x);
            vertices.putFloat(p0.y);
            vertices.putFloat(p0.z);
            vertices.putFloat(p1.x);
            vertices.putFloat(p1.y);
            vertices.putFloat(p1.z);
            vertices.putFloat(p2.x);
            vertices.putFloat(p2.y);
            vertices.putFloat(p2.z);
            vertices.putFloat(p2.x);
            vertices.putFloat(p2.y);
            vertices.putFloat(p2.z);
            vertices.putFloat(p3.x);
            vertices.putFloat(p3.y);
            vertices.putFloat(p3.z);
            vertices.putFloat(p0.x);
            vertices.putFloat(p0.y);
            vertices.putFloat(p0.z);
            gIndices.putInt(idx + 0);
            gIndices.putInt(idx + 1);
            gIndices.putInt(idx + 2);
            gIndices.putInt(idx + 3);
            gIndices.putInt(idx + 4);
            gIndices.putInt(idx + 5);
            idx += 6;
        }
        return idx;
    }

    static int addTriangleFanArray(GeometryArray ga, ByteBuffer vertices, ByteBuffer gIndices, int idx, Transform3D t) {
        int ici = ga.getInitialCoordIndex();
        int vvc = ga.getValidVertexCount();
        int ns = ((TriangleFanArray)ga).getNumStrips();
        int[] svc = new int[ns];
        ((TriangleFanArray)ga).getStripVertexCounts(svc);
        int stripStart = ici;
        for (int i = 0; i < ns; ++i) {
            Point3f p0 = new Point3f();
            ga.getCoordinate(stripStart, p0);
            t.transform(p0);
            for (int j = 1; j < svc[i] - 1; ++j) {
                Point3f p1 = new Point3f();
                Point3f p2 = new Point3f();
                ga.getCoordinate(stripStart + j + 0, p1);
                t.transform(p1);
                ga.getCoordinate(stripStart + j + 1, p2);
                t.transform(p2);
                vertices.putFloat(p0.x);
                vertices.putFloat(p0.y);
                vertices.putFloat(p0.z);
                vertices.putFloat(p1.x);
                vertices.putFloat(p1.y);
                vertices.putFloat(p1.z);
                vertices.putFloat(p2.x);
                vertices.putFloat(p2.y);
                vertices.putFloat(p2.z);
                gIndices.putInt(idx + 0);
                gIndices.putInt(idx + 1);
                gIndices.putInt(idx + 2);
                idx += 3;
            }
            stripStart += svc[i];
        }
        return idx;
    }

    static int addTriangleArray(GeometryArray ga, ByteBuffer vertices, ByteBuffer gIndices, int idx, Transform3D t) {
        int ici = ga.getInitialCoordIndex();
        int vvc = ga.getValidVertexCount();
        for (int i = ici; i < ici + vvc; i += 3) {
            Point3f p0 = new Point3f();
            Point3f p1 = new Point3f();
            Point3f p2 = new Point3f();
            ga.getCoordinate(i + 0, p0);
            t.transform(p0);
            ga.getCoordinate(i + 1, p1);
            t.transform(p1);
            ga.getCoordinate(i + 2, p2);
            t.transform(p2);
            vertices.putFloat(p0.x);
            vertices.putFloat(p0.y);
            vertices.putFloat(p0.z);
            vertices.putFloat(p1.x);
            vertices.putFloat(p1.y);
            vertices.putFloat(p1.z);
            vertices.putFloat(p2.x);
            vertices.putFloat(p2.y);
            vertices.putFloat(p2.z);
            gIndices.putInt(idx + 0);
            gIndices.putInt(idx + 1);
            gIndices.putInt(idx + 2);
            idx += 3;
        }
        return idx;
    }

    static int addLineStripArray(GeometryArray ga, ByteBuffer vertices, ByteBuffer gIndices, int idx, Transform3D t) {
        int ici = ga.getInitialCoordIndex();
        int vvc = ga.getValidVertexCount();
        for (int i = ici; i < ici + vvc; i += 2) {
            Point3f p0 = new Point3f();
            Point3f p1 = new Point3f();
            ga.getCoordinate(i + 0, p0);
            t.transform(p0);
            ga.getCoordinate(i + 1, p1);
            t.transform(p1);
            vertices.putFloat(p0.x);
            vertices.putFloat(p0.y);
            vertices.putFloat(p0.z);
            vertices.putFloat(p1.x);
            vertices.putFloat(p1.y);
            vertices.putFloat(p1.z);
            vertices.putFloat(p0.x);
            vertices.putFloat(p0.y);
            vertices.putFloat(p0.z);
            gIndices.putInt(idx + 0);
            gIndices.putInt(idx + 1);
            gIndices.putInt(idx + 2);
            idx += 3;
        }
        return idx;
    }

    public static Node loadVRML_A(URL url) throws Exception {
        VRML.initVRML();
        Scene scene = VRML.loader.load(url);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)scene.getSceneGroup());
        for (Background background : scene.getBackgroundNodes()) {
            bg.addChild((Node)background);
        }
        for (Background background : scene.getFogNodes()) {
            bg.addChild((Node)background);
        }
        return bg;
    }

    public static Node loadVRML_B(URL url) throws Exception {
        VRML.initVRML();
        Scene scene = VRML.loader.load(url);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)scene.getSceneGroup());
        return bg;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

