/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3.bvh.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import jp.sourceforge.acerola3d.a3.bvh.lexer.LexerException;
import jp.sourceforge.acerola3d.a3.bvh.node.EOF;
import jp.sourceforge.acerola3d.a3.bvh.node.TBlank;
import jp.sourceforge.acerola3d.a3.bvh.node.TChannels;
import jp.sourceforge.acerola3d.a3.bvh.node.TEndSite;
import jp.sourceforge.acerola3d.a3.bvh.node.TFrameTime;
import jp.sourceforge.acerola3d.a3.bvh.node.TFrames;
import jp.sourceforge.acerola3d.a3.bvh.node.THierarchy;
import jp.sourceforge.acerola3d.a3.bvh.node.TIdentifier;
import jp.sourceforge.acerola3d.a3.bvh.node.TInteger;
import jp.sourceforge.acerola3d.a3.bvh.node.TJoint;
import jp.sourceforge.acerola3d.a3.bvh.node.TLBrace;
import jp.sourceforge.acerola3d.a3.bvh.node.TMotion;
import jp.sourceforge.acerola3d.a3.bvh.node.TOffset;
import jp.sourceforge.acerola3d.a3.bvh.node.TRBrace;
import jp.sourceforge.acerola3d.a3.bvh.node.TRealNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.TRoot;
import jp.sourceforge.acerola3d.a3.bvh.node.TXPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TXRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TXScale;
import jp.sourceforge.acerola3d.a3.bvh.node.TYPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TYRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TYScale;
import jp.sourceforge.acerola3d.a3.bvh.node.TZPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TZRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TZScale;
import jp.sourceforge.acerola3d.a3.bvh.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
        if (gotoTable == null) {
            try {
                int j;
                int i;
                DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for (i = 0; i < gotoTable.length; ++i) {
                    length = s.readInt();
                    Lexer.gotoTable[i] = new int[length][][];
                    for (j = 0; j < gotoTable[i].length; ++j) {
                        length = s.readInt();
                        Lexer.gotoTable[i][j] = new int[length][3];
                        for (int k = 0; k < gotoTable[i][j].length; ++k) {
                            for (int l = 0; l < 3; ++l) {
                                Lexer.gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }
                length = s.readInt();
                accept = new int[length][];
                for (i = 0; i < accept.length; ++i) {
                    length = s.readInt();
                    Lexer.accept[i] = new int[length];
                    for (j = 0; j < accept[i].length; ++j) {
                        Lexer.accept[i][j] = s.readInt();
                    }
                }
                s.close();
            }
            catch (Exception e) {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block31: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block31;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 18: {
                    Token token = this.new18(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 20: {
                    Token token = this.new20(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 21: {
                    Token token = this.new21(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 22: {
                    Token token = this.new22(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 23: {
                    Token token = this.new23(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "] Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(int line, int pos) {
        return new THierarchy(line, pos);
    }

    Token new1(int line, int pos) {
        return new TRoot(line, pos);
    }

    Token new2(int line, int pos) {
        return new TOffset(line, pos);
    }

    Token new3(int line, int pos) {
        return new TChannels(line, pos);
    }

    Token new4(int line, int pos) {
        return new TJoint(line, pos);
    }

    Token new5(int line, int pos) {
        return new TXPosition(line, pos);
    }

    Token new6(int line, int pos) {
        return new TYPosition(line, pos);
    }

    Token new7(int line, int pos) {
        return new TZPosition(line, pos);
    }

    Token new8(int line, int pos) {
        return new TXRotation(line, pos);
    }

    Token new9(int line, int pos) {
        return new TYRotation(line, pos);
    }

    Token new10(int line, int pos) {
        return new TZRotation(line, pos);
    }

    Token new11(int line, int pos) {
        return new TXScale(line, pos);
    }

    Token new12(int line, int pos) {
        return new TYScale(line, pos);
    }

    Token new13(int line, int pos) {
        return new TZScale(line, pos);
    }

    Token new14(int line, int pos) {
        return new TEndSite(line, pos);
    }

    Token new15(int line, int pos) {
        return new TLBrace(line, pos);
    }

    Token new16(int line, int pos) {
        return new TRBrace(line, pos);
    }

    Token new17(int line, int pos) {
        return new TMotion(line, pos);
    }

    Token new18(int line, int pos) {
        return new TFrames(line, pos);
    }

    Token new19(int line, int pos) {
        return new TFrameTime(line, pos);
    }

    Token new20(String text, int line, int pos) {
        return new TIdentifier(text, line, pos);
    }

    Token new21(String text, int line, int pos) {
        return new TInteger(text, line, pos);
    }

    Token new22(String text, int line, int pos) {
        return new TRealNumber(text, line, pos);
    }

    Token new23(String text, int line, int pos) {
        return new TBlank(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(text.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        for (int i = 0; i < acceptLength; ++i) {
            s.append(this.text.charAt(i));
        }
        return s.toString();
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

