#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v3.0.6
## (c)2008-2010 NorenzPRO Ltd. TalafumiArai 2010/8/29
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
require './aelib.cgi';
use strict;
use CGI;
use Encode;
use File::Path;

##★このスクリプトの名前
our $cginame = 'adskin.cgi';

##★ディレクトリ構成ファイル
our $dirfile = './dir.dat';

##★システム設定ファイルのパス
our $conffile = './conf.dat';

##★クッキーの名称
our $CookieName = 'AdminPass';

##★パスワードファイル
our $passfile='./pass.cgi';

##★ファイルアップロード上限サイズ(KB)
our $UploadMaxSize=5120;

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our $RegImgName;

##ディレクトリファイル読込
open(DIRRD,"$dirfile");
our @DIR = <DIRRD>;
close(DIRRD);

##システム設定ファイル読込
open(CONFRD,"$conffile");
our @CONF = <CONFRD>;
close(CONFRD);
our $DirMode =$CONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$CONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$CONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$CONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$CONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$CONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$CONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$CONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $GmapAPIkey =$CONF[8];
$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
our $SysVersion =$CONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$CONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$CONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$CONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
our $UpdateOut =$CONF[13];
$UpdateOut =~ s/\r//g; $UpdateOut =~ s/\n//g;
our $DefMainURL =$CONF[14];
$DefMainURL =~ s/\r//g; $DefMainURL =~ s/\n//g;
our $SearchSkinURL =$CONF[15];
$SearchSkinURL =~ s/\r//g; $SearchSkinURL =~ s/\n//g;
our $pcoutCode =$CONF[22];
$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
our $mboutCode =$CONF[23];
$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;

if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }
if ($DefMainURL eq '') { $DefMainURL ='main.html'; }
if ($SearchSkinURL eq '') { $SearchSkinURL ='/skin/skin.html'; }
our $vLogoutTime;
if ($LogoutTime eq '1800') { $vLogoutTime='30分'; }
elsif ($LogoutTime eq '3600') { $vLogoutTime='1時間'; }
elsif ($LogoutTime eq '10800') { $vLogoutTime='3時間'; }
elsif ($LogoutTime eq '21600') { $vLogoutTime='6時間'; }
elsif ($LogoutTime eq '43200') { $vLogoutTime='12時間'; }
elsif ($LogoutTime eq '86400') { $vLogoutTime='1日'; }
elsif ($LogoutTime eq '259200') { $vLogoutTime='3日'; }
elsif ($LogoutTime eq '604800') { $vLogoutTime='7日'; }
else { $LogoutTime='259200'; $vLogoutTime='3日'; }
if ($pcoutCode eq '') { $pcoutCode='sjis'; }
if ($mboutCode eq '') { $mboutCode='sjis'; }

##編集者IDパスワード読込
our $admin_id;
our $admin_pw;
if (open(PASSRD,"$passfile")) {
	our @PASSID = <PASSRD>;
	$admin_id =$PASSID[0];
	$admin_id =~ s/\r//g; $admin_id =~ s/\n//g;
	$admin_pw =$PASSID[1];
	$admin_pw =~ s/\r//g; $admin_pw =~ s/\n//g;
	$admin_pw =crypt($admin_pw,'ae');
	close(PASSRD);
} else { &error('パスワードファイル読込エラー'); }

##転送許可ファイルのサイズ上限
our $ViewMaxSize;
if ($UploadMaxSize < 1024) {
	$ViewMaxSize=$UploadMaxSize."KB";
} else {
	my $ViewMaxMB =int($UploadMaxSize*10/1024)/10;
	$ViewMaxSize=$ViewMaxMB.'MB';
}
our $MaxDataSize=$UploadMaxSize*1024;

##AGENTの取得
our %ENV;
our $agent = $ENV{'HTTP_USER_AGENT'};
$agent =~ s/\,/\./g;

##フォームの取得
our %in;
our @in;
our $upfile;
if ($MaxDataSize < $ENV{'CONTENT_LENGTH'}) { &error('添付ファイル容量オーバー'); }
my $query = CGI->new;
*in = $query->Vars();
if ($in{'imgfile'} ne '') {
	my $query = CGI->new; 
	$upfile= $query->param('imgfile'); 
}

##==============メインアクション==============

## 管理者ログイン認証
our $ck_id; our $ck_pw;
our $c_id; our $c_pw;
if ($in{'loging'} eq "new") {
	# フォーム認証
	my $input_id;
	my $input_pw;
	$input_id = $in{'admin_id'};
	$input_pw = $in{'admin_pw'};
	$input_pw =crypt($input_pw,'ae');
	if ($input_id ne "$admin_id") { &error('認証エラー'); }
	if ($input_pw ne "$admin_pw") { &error('認証エラー'); }
	&set_cookie;
	&admin;
} else {
	# クッキー認証
	&get_cookie;
	if (($ck_id eq "$admin_id")&&($ck_pw eq "$admin_pw")) {
		# 処理分岐
		if ($in{'mode'} eq 'admin') { &admin; }
		elsif ($in{'mode'} eq 'regskin') { &regskin; }
		elsif ($in{'mode'} eq 'delskin') { &delskin; }
		elsif ($in{'mode'} eq 'regimage') { &regimage; }
		elsif ($in{'mode'} eq 'delimage') { &delimage; }
		elsif ($in{'mode'} eq 'MakeIndexFile') { &MakeIndexFile; }
		elsif ($in{'mode'} eq 'emoji') { &emoji; }
		else { &admin; }
	} else {
		&login;
	}
}

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

##コンテンツ設定画面出力##
my $headTitle='スキン編集';

##★EditArea設定
our $htEditArea;
if ($in{'TargFile'} =~ /\.css/) {
$htEditArea = <<"EditArea";
	<script language="Javascript" type="text/javascript">
		editAreaLoader.init({
			id: "htbody"	// id of the textarea to transform	
			,start_highlight: true	
			,font_size: "10"
			,font_family: "verdana, monospace"
			,allow_resize: "y"
			,allow_toggle: false
			,display: "later"
			,language: "ja"
			,syntax: "css"	
			,toolbar: "search, go_to_line, |, undo, redo, |, select_font, |, change_smooth_selection, highlight, reset_highlight, |, help"
		});
	</script>
EditArea
} elsif ($in{'TargFile'} =~ /\.js/) {
$htEditArea = <<"EditArea";
	<script language="Javascript" type="text/javascript">
		editAreaLoader.init({
			id: "htbody"	// id of the textarea to transform	
			,start_highlight: true	
			,font_size: "10"
			,font_family: "verdana, monospace"
			,allow_resize: "y"
			,allow_toggle: true
			,display: "later"
			,language: "ja"
			,syntax: "js"	
			,toolbar: "search, go_to_line, |, undo, redo, |, select_font, |, change_smooth_selection, highlight, reset_highlight, |, help"
		});
	</script>
EditArea
} else {
$htEditArea = <<"EditArea";
	<script language="Javascript" type="text/javascript">
		editAreaLoader.init({
			id: "htbody"	// id of the textarea to transform	
			,start_highlight: true	
			,font_size: "10"
			,font_family: "verdana, monospace"
			,allow_resize: "y"
			,allow_toggle: true
			,display: "later"
			,language: "ja"
			,syntax: "html"	
			,toolbar: "search, go_to_line, |, undo, redo, |, select_font, |, change_smooth_selection, highlight, reset_highlight, |, help"
		});
	</script>
EditArea
}

##★HTMLヘッダの変更はここを訂正
my $html_head = <<"HTMLHEAD";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>$headTitle</title>
<link rel="stylesheet" href="../admin/style.css" type="text/css">
<script language="JavaScript"><!--
function AddRows(targetObj) {
  var obj = document.getElementsByName(targetObj)[0];
  obj.rows = obj.rows+5;
}
--></script>
<script language="Javascript" type="text/javascript" src="./editarea/edit_area_full.js" charset="UTF-8"></script>
$htEditArea
</head>
<body onload="javascript:parent.menu.location.href='menu.cgi'">
<h3 align=center>$headTitle</h3>
HTMLHEAD

print "Content-type: text/html\n\n";
print $html_head;

}
##=======================================================================================
sub html_foot {

##★HTMLフッタの変更はここを訂正
my $html_foot = <<"HTMLFOOT";
</body>
</html>
HTMLFOOT

print $html_foot;

}
##=======================================================================================
sub login {

##★ログイン画面の変更はここを訂正
my $html_login = <<"LOGINHTML";
<div align="center">
<form method="post" action="$cginame">
<br>
<h5 align=center style="color:red">セッションタイムアウト</h5>
<h4 align=center>管理画面 再ログイン</h4>
<div align=center>ログインID　<input type="text" name="admin_id" size="25" value="$ck_id" class="Hankaku"></div>
<div align=center>パスワード　<input type="password" name="admin_pw" size="25" value="$ck_pw" class="Hankaku"></div>
<div align="center">
<input type="submit" name="submit" value="ログイン">
<input type="reset" value="リセット">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="loging" value="new">
</div>
</form>
LOGINHTML

&html_head;
print $html_login;
&html_foot;

exit;
}
##=======================================================================================
sub admin {

my $FilesTag='';

##スキンファイル取得##
my $TargFile;
my $scRootPath;
if ($in{'TargFile'} ne '') { $TargFile=$in{'TargFile'}; } else { $TargFile=''; }
if ($RootPath ne '') { $scRootPath='/'.$RootPath; } else { $scRootPath=''; }

##スキンファイルセレクタ##
our $vRootPath;
if ($RootPath ne '') { $vRootPath='/'.$RootPath; } else { $vRootPath=''; }

my $TopDir='../';
my @TopFiles=&GetFilelist($TopDir,'.html/.shtml/.css/.js',0);
@TopFiles=reverse(@TopFiles); my $i=0;
foreach(@TopFiles) {
	if (($TopFiles[$i] eq $TargFile)&&($in{'RootReg'} eq '1')) {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$TopFiles[$i].'&RootReg=1" selected>[トップ階層] '
		.$vRootPath.'/'.$TopFiles[$i].'</option>'."\n";
	} else {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$TopFiles[$i].'&RootReg=1">[トップ階層] '
		.$vRootPath.'/'.$TopFiles[$i].'</option>'."\n";
	}
	$i++;
}
my $SkinDir='../skin';
my @SkinFiles=&GetFilelist($SkinDir,'.html/.shtml/.css/.js',0);
@SkinFiles=reverse(@SkinFiles); $i=0;
foreach(@SkinFiles) {
	if (($SkinFiles[$i] eq $TargFile)&&($in{'RootReg'} eq '0')) {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$SkinFiles[$i].'&RootReg=0" selected>[スキン階層] '
		.$vRootPath.'/skin/'.$SkinFiles[$i].'</option>'."\n";
	} else {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$SkinFiles[$i].'&RootReg=0">[スキン階層] '
		.$vRootPath.'/skin/'.$SkinFiles[$i].'</option>'."\n";
	}
	$i++;
}
my $MobiDir='../mobi';
my @MobiFiles=&GetFilelist($MobiDir,'.html/.shtml',0);
@MobiFiles=reverse(@MobiFiles); $i=0;
foreach(@MobiFiles) {
	if (($MobiFiles[$i] eq $TargFile)&&($in{'RootReg'} eq 'm')) {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$MobiFiles[$i].'&RootReg=m" selected>[/mobi/階層] '
		.$vRootPath.'/mobi/'.$MobiFiles[$i].'</option>'."\n";
	} else {
		$FilesTag=$FilesTag.'<option value="'.$cginame.'?TargFile='.$MobiFiles[$i].'&RootReg=m">[/mobi/階層] '
		.$vRootPath.'/mobi/'.$MobiFiles[$i].'</option>'."\n";
	}
	$i++;
}

my $DefSkin;
if ($TargFile eq '') { $DefSkin=' selected'; } else { $DefSkin=''; }

##スキンファイル条件分岐##
my $TargFilePath;
my $RootRegTag;
my $vSkinPath;
my $vAlt;
if ($in{'RootReg'} eq '1') {
	$TargFilePath='../'.$TargFile;
	$RootRegTag='<input type="hidden" name="RootReg" value="1">';
	$vSkinPath='/';
	$vAlt = <<"vAlt";
	<img src="./img/top.gif" align="right">
	<b>トップページ [$vRootPath/index.shtml] の設定と編集</b><br>
	「AD-EDIT」は、SSIの使用を前提として開発されています。<br>
	もし、あなたが借りているレンタルサーバーにSSI\機\能\がなければ、<br>
	トップページは固定HTML [$vRootPath/index.html] としてください。<br>
	<br>
	ＰＣサイト設定を有効にするために、[$vRootPath/index.shtml] のソ\ー\スコード内に、<br>
	メニューゾーン1 → <font style="color:#FF0000">&lt;!--#include virtual="./commons/menu1.inc" --&gt;</font><br>
	メニューゾーン2 → <font style="color:#FF0000">&lt;!--#include virtual="./commons/menu2.inc" --&gt;</font><br>
	メニューゾーン3 → <font style="color:#FF0000">&lt;!--#include virtual="./commons/menu3.inc" --&gt;</font><br>
	を記述してください。<br>
	<br>
	また、新着情報を\表\示するためには、[$vRootPath/index.shtml] のソ\ー\スコード内に、<br>
	<font style="color:#FF0000">&lt;!--#include virtual="./commons/news.cgi" --&gt;</font><br>
	を記述します。<br>
	<br>
	検索窓を設置する場合は、スキンファイルのソ\ー\スコード内に、<br>
	<font style="color:#FF0000">&lt;form action="$scRootPath/commons/search.cgi" method="get"&gt;<br>
	&lt;input type="text" name="q" /&gt;<br>
	&lt;input type="submit" value="検索" /&gt;&lt;/form&gt;<br>
	</font>
	を記述してください。
vAlt
	if (($TargFile =~ /\.css/)||($TargFile =~ /\.js/)) { $vAlt=''; }
} elsif ($in{'RootReg'} eq '0') {
	$TargFilePath='../skin/'.$TargFile;
	$RootRegTag='<input type="hidden" name="RootReg" value="0">';
	$vSkinPath='/skin/';
	if ($TargFile =~ /mobi/) {
	$vAlt = <<"vAlt";
	<img src="./img/mobi.gif" align="right">
	<b>携帯用スキンファイル [/skin/$TargFile] の設定</b><br>
	「AD-EDIT」は、コンテンツページ(下層ページ)を\表\示する際に、<br>
	スキンファイル [$vRootPath/skin/$TargFile] を読み込み、<br>
	スキンファイルのデザインで\表\示します。<br>
	<br>
	スキンファイルはコンテンツ毎にいくつでも設置できます。<br>
	<br>
	コンテンツページを正しく表示させるためには、<br>
	スキンファイル内に「コンテンツゾーン(記事を\表\示する領域)」を定義する必要があります。<br>
	コンテンツゾーンの定義方法は、スキンファイル [$vRootPath/skin/$TargFile] のソ\ー\スコード内に、<br>
	<font style="color:#FF0000">&lt;!-- MainZone --&gt;</font><br>
	のコメント行を、まるまる１行分、確保して記述してください。<br>
	<br>
	携帯用トップページの編集は、<img src=../icon/mobi.gif align=absmiddle><a href=admobi.cgi target=main>[携帯メニュー設定]</a>
	にて行ってください。<br>
	トップページなどで使用する画像などは、こちらで登録を行っておくと便利です。<br>
vAlt
	} else {
	$vAlt = <<"vAlt";
	<img src="./img/skin.gif" align="right">
	<b>スキンファイル [/skin/$TargFile] の設定</b><br>
	「AD-EDIT」は、コンテンツページ(下層ページ)を\表\示する際に、<br>
	スキンファイル [$vRootPath/skin/$TargFile] を読み込み、<br>
	スキンファイルのデザインで\表\示します。<br>
	<br>
	スキンファイルはコンテンツ毎にいくつでも設置できます。<br>
	<br>
	コンテンツページを正しく表示させるためには、<br>
	スキンファイル内に「コンテンツゾーン(記事を\表\示する領域)」を定義する必要があります。<br>
	コンテンツゾーンの定義方法は、スキンファイル [$vRootPath/skin/$TargFile] のソ\ー\スコード内に、<br>
	<font style="color:#FF0000">&lt;!-- MainZone --&gt;</font><br>
	のコメント行を、まるまる１行分、確保して記述してください。<br>
	<br>
	また、コンテンツページにおけるＰＣサイト設定を有効にするために、スキンファイルのソ\ー\スコード内に、<br>
	メニューゾーン1 → <font style="color:#FF0000">&lt;MenuZone1&gt;</font><br>
	メニューゾーン2 → <font style="color:#FF0000">&lt;MenuZone2&gt;</font><br>
	メニューゾーン3 → <font style="color:#FF0000">&lt;MenuZone3&gt;</font><br>
	を記述してください。<br>
	<br>
	<br>
	検索窓を設置する場合は、スキンファイルのソ\ー\スコード内に、<br>
	<font style="color:#FF0000">&lt;form action="$scRootPath/commons/search.cgi" method="get"&gt;<br>
	&lt;input type="text" name="q" /&gt;<br>
	&lt;input type="submit" value="検索" /&gt;&lt;/form&gt;<br>
	</font>
	を記述してください。<br>
	<br>
	コンテンツページでの新着情報の\表\示はできません。<br>
vAlt
	}
	if (($TargFile =~ /\.css/)||($TargFile =~ /\.js/)) { $vAlt=''; }
} elsif ($in{'RootReg'} eq 'm') {
	$TargFilePath='../mobi/'.$TargFile;
	$RootRegTag='<input type="hidden" name="RootReg" value="m">';
	$vSkinPath='/mobi/';
	$vAlt = <<"vAlt";
	<b>携帯用HTMLファイル [/mobi/$TargFile] の設定</b><br>
	<br>
	/mobi/ 階層では、おもに携帯用のHTMLページを格納します。<br>
	携帯用トップページのファイル名は、index.html としてください。<br>
	<br>
	携帯用トップページのメニュー編集は、<img src=../icon/mobi.gif align=absmiddle><a href=admobi.cgi target=main>[携帯メニュー設定]</a>
	でも行うことが出来ます。<br>
	トップページなどで使用する画像などは、こちらで登録を行っておくと便利です。<br>
vAlt
} else {
	$TargFilePath='../skin/'.$TargFile;
	$RootRegTag='<input type="hidden" name="RootReg" value="0">';
	$vSkinPath='/skin/';
	$vAlt = '';
}

my $DefSkinSelected;
my $SkinSelected;
my $PreviewButton;
my $DeleteButton;
my $DelSkinJS;
my $SkinName;
my $SkinExt;
if ($TargFile ne '') {
	($SkinName,$SkinExt)=split(/\./,$TargFile);
	$SkinSelected='<option value=".'.$SkinExt.'" selected>.'.$SkinExt.'</option>';
	$DefSkinSelected='';
	$PreviewButton="<input type=\"button\" value=\"スキンプレビュー\" onClick=\"javascript:window.open(\'".$TargFilePath."\')\">";
	$DelSkinJS = <<"DelSkinJS";
	<script language=Javascript><!--
	function delSkin() {
	if (confirm("$TargFile を削除しますか？"))
	{ location.href="$cginame?mode=delskin&delfile=$TargFile&TargFile=$TargFile&RootReg=$in{'RootReg'}"; }
	}
	// -->
	</script>
DelSkinJS
	$DeleteButton=$DelSkinJS
	."<input type=\"button\" value=\"このスキンファイルを削除\" onClick=\"javascript:delSkin()\">";
} else {
	$DefSkinSelected=' selected';
	$PreviewButton='';
	$DeleteButton='';
}

##スキンファイル読み込み##
my @SKINHTML=();
my $skinflag=0;
my $saveSJIS;
my $saveUTF8;
if ((-e $TargFilePath)&&($TargFile ne '')) {
	open(SKINRD,"$TargFilePath");
	@SKINHTML = <SKINRD>;
	close(SKINRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($TargFilePath);
	if ($contCC eq 'shiftjis') {
		foreach (@SKINHTML) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		$saveSJIS=' selected';
	} else { $saveUTF8=' selected'; }
}
my $hi=0;
my $LotSKINHTML=@SKINHTML;
my $vSkinBody;
for(0..$LotSKINHTML) {
	$SKINHTML[$hi]=~ s/\r\n/\n/g;
	$SKINHTML[$hi]=~ s/\r/\n/g;
	$SKINHTML[$hi]=~ s/\t/  /g;;
	$vSkinBody=$vSkinBody.$SKINHTML[$hi].'';
	$hi++;
}
if ($TargFile eq '') { $vSkinBody=''; }

##★変更画面の変更はここを訂正
my $htmlForm = <<"htmlForm";
<hr size="1" align="center">
  <h4 align="center">スキンHTML編集</h4>
  <div align=center>ここでトップページやスキンHTMLファイルの編集ができます</div>
<hr size="1" align="center">

<form method="post" action="$cginame">
<table border=0 cellspacing=0 cellpadding=5 align="center" width="95%">
<tr><td>
<b>編集ファイル</b>
<select onChange="javascript:location.href=this.options[this.selectedIndex].value">
<option value="$cginame?RootReg=0"$DefSkin>編集するファイルを選択してください</option>
$FilesTag
</select>
$PreviewButton
$DeleteButton
<br>
<textarea name="htbody" id="htbody" cols="110" rows="35" onDblClick="AddRows('htbody')">$vSkinBody</textarea>
<br>
<b>スキンファイルの保存/別名保存</b>
<br>
$vRootPath$vSkinPath<input type="text" name="SkinName" value="$SkinName" size="20" class="Hankaku">
<select name="SkinExt">
$SkinSelected<option value=".html"$DefSkinSelected>.html</option>
<option value=".shtml">.shtml</option>
<option value=".css">.css</option>
<option value=".js">.js</option>
</select>　
<select name="savecc">
<option value="sjis"$saveSJIS>ShiftJIS</option>
<option value="utf8"$saveUTF8>UTF-8</option>
</select>
として
<input type="submit" name="submit" value="保存する">
<input type="reset" value="リセット">
$RootRegTag
<input type="hidden" name="mode" value="regskin"><br>
<span style='color:#FF0000' align=center>※ファイル名は半角英数、拡張子まで選択してください</span><br>
<span style='color:#0000FF' align=center>※携帯用スキンファイルは、ファイル名に[mobi]の文字列を含むようにしてください</span><br>
<br>
$vAlt
</form>
</td></tr>
</table>

<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
<div style="margin-bottom:5px"><strong>メニュー設定をサイト全体に反映</strong>(スキン編集後に操作)
<a href="javascript:alert(this.helpUD.title);" name="helpUD" title="各コンテンツフォルダのindex.htmlを更\新します">[?]</a></div>
  <form>　<input type="button" onClick="location.href='$cginame?mode=MakeIndexFile'" value="上記メニュー項目をサイト全体に反映する(HTMLファイルを更\新)"></form>
</td></tr></table>
htmlForm

##スキン画像リストの取得##
if ($RootPath ne '') { $vRootPath='/'.$RootPath; } else { $vRootPath=''; }
our $SkinImgDir='../img';
our @SkinImgFiles=&GetFilelist($SkinImgDir,0,0);
$i=0;
my $JsFileName;
my $vImgPath;
my $vImgTag;
my $DelJS;
my $vImgAbsPath;
foreach(@SkinImgFiles) {
	$JsFileName=$SkinImgFiles[$i];
	$JsFileName =~ s/\./\\\./g;
	$DelJS = <<"DelJS";
	<script language=Javascript><!--
	function delImage$i() {
	if (confirm("$JsFileName を削除しますか？"))
	{ location.href="$cginame?mode=delimage&delfile=$SkinImgFiles[$i]&TargFile=$TargFile&RootReg=$in{'RootReg'}"; }
	}
	// -->
	</script>
DelJS
	$vImgPath=$SkinImgDir.'/'.$SkinImgFiles[$i];
	$vImgAbsPath=$vRootPath.'/img/'.$SkinImgFiles[$i];
	$vImgTag=$vImgTag.'<tr><td align="center">'
	.'<a href="'.$vImgPath.'" target=_blank><img src="'.$vImgPath.'" width=50 height=50></a></td>'
	.'<td align="left">'.$SkinImgFiles[$i].' 　</td>'
	.'<td align="left"><form>'.$vImgAbsPath.'<br />'
	.'<input type="text" value="&lt;img src=&quot;'.$vImgAbsPath.'&quot; alt=&quot;画像の説明&quot; border=&quot;0&quot; /&gt;" size="70"></form></td>'
	.'<td align="center">'.$DelJS.'<form><input type="button" value="削除" onClick="delImage'.$i.'()"></form></tr>';
	$i++;
}

##★変更画面の変更はここを訂正
my $imageForm = <<"imageForm";
<hr size="1" align="center">
  <h4 align="center">スキン画像の登録(アップロード)</h4>
  <div align=center>ここでスキンHTMLファイルで使用している画像の追加・差替えができます</div>
<hr size="1" align="center">

<table width="95%" border="1" cellspacing="0" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr><td align="center"><b>画像</b></td>
<td align="center"><b>ファイル名</b></td>
<td align="center"><b>ファイルパス/埋込タグ</b></td>
<td align="center"><b>削除</b></td></tr>
$vImgTag
<tr><td align="center"><b>新規登録</b></td>
<td colspan=3>
<form method="post" action="$cginame" enctype="multipart/form-data">
ファイル参照
<input type="file" name="imgfile" size="20">　≫　
ファイル名
<input type="text" name="ImgName"  size="20" class="Hankaku">
<select name="ImgExt">
<option value=".jpg">.jpg</option>
<option value=".gif">.gif</option>
<option value=".png">.png</option>
<option value=".swf">.swf</option>
</select>　≫　
<input type="submit" value="画像登録(アップロード)">
<input type="hidden" name="mode" value="regimage">
<input type="hidden" name="TargFile" value="$TargFile">
<input type="hidden" name="RootReg" value="$in{'RootReg'}"><br>
<span style='color:#FF0000' align=center>※ファイル名は半角英数、拡張子まで選択してください</span><br>
<span style='color:#FF0000' align=center>※ファイルサイズ上限 $ViewMaxSize まで</span>
</form>

</td></tr>
</table>
imageForm

&html_head;
print $htmlForm;
print $imageForm;
&html_foot;

exit;
}
##=======================================================================================
sub regskin {

##変数情報の取得
if ($in{'SkinName'} eq '') { &error('ファイル名を指定してください'); }
$in{'SkinName'} =~ s/\r//g;
$in{'SkinName'} =~ s/\n//g;
$in{'SkinName'} =~ s/ //g;
$in{'SkinName'} =~ s/\///g;
$in{'SkinName'} =~ s/\.//g;
$in{'SkinName'} =~ s/\,//g;
$in{'SkinName'} =~ s/\#//g;
$in{'SkinName'} =~ s/\"//g;
$in{'SkinName'} =~ s/\'//g;
$in{'SkinName'} =~ s/\&//g;
$in{'SkinName'} =~ s/\%//g;
$in{'SkinName'} =~ s/\!//g;
$in{'SkinName'} =~ s/\\//g;
$in{'SkinName'} =~ s/=//g;

##★フォーム取得処理
$in{'htbody'}=~ s/\r\n/\n/g;
$in{'htbody'}=~ s/\r/\n/g;
$in{'htbody'}=~ s/\n/\n/g;

##★保存文字コード
if ($in{'savecc'} eq 'sjis') {
	$in{'htbody'} =~ s/ charset=UTF-8/ charset=Shift_JIS/g;
	$in{'htbody'} =~ s/ charset=utf-8/ charset=Shift_JIS/g;
	Encode::from_to($in{'htbody'}, 'utf8', 'shiftjis');
} elsif ($in{'savecc'} eq 'utf8') {
	$in{'htbody'} =~ s/ charset=Shift_JIS/ charset=UTF-8/g;
	$in{'htbody'} =~ s/ charset=shift_jis/ charset=UTF-8/g;
	$in{'htbody'} =~ s/ charset=x-sjis/ charset=UTF-8/g;
}
##★スキンファイル取得
my $skinfile;
if ($in{'RootReg'} eq '1') {
	$skinfile='../'.$in{'SkinName'}.$in{'SkinExt'};
} elsif ($in{'RootReg'} eq 'm') {
	$skinfile='../mobi/'.$in{'SkinName'}.$in{'SkinExt'};
} else {
	$skinfile='../skin/'.$in{'SkinName'}.$in{'SkinExt'};
}

##★スキンセーブ
if (open(SKINWR,"> $skinfile")) {
	print SKINWR $in{'htbody'};
	close(SKINWR);
} else { &error($skinfile.'が記述できません'); }
chmod(oct($WRMode),$skinfile);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&TargFile=".$in{'SkinName'}.$in{'SkinExt'}."&RootReg=".$in{'RootReg'};
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>スキンファイル作成処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、スキンファイルの作成処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub delskin {

##変数情報の取得
my $delFilePath;
if (($in{'delfile'} ne '')&&($in{'RootReg'} eq '0')) {
	$delFilePath='../skin/'.$in{'delfile'};
	if (-e $delFilePath) { unlink($delFilePath); }
}
if (($in{'delfile'} ne '')&&($in{'RootReg'} eq '1')) {
	$delFilePath='../'.$in{'delfile'};
	if (-e $delFilePath) { unlink($delFilePath); }
}
if (($in{'delfile'} ne '')&&($in{'RootReg'} eq 'm')) {
	$delFilePath='../mobi/'.$in{'delfile'};
	if (-e $delFilePath) { unlink($delFilePath); }
}

##処理画面出力
my $jumpurl = "$cginame?mode=admin";

my $htmla_jumpurl = <<"JUMPA";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>ファイル操作</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、 $in{'delfile'} を削除中です。</h2>
</body></html>
JUMPA

print "Content-type: text/html\n\n";
print $htmla_jumpurl;

exit;
}
##=======================================================================================
sub regimage {

##変数情報の取得
if ($in{'imgfile'} eq '') { &error('添付ファイルを指定してください'); }
if ($in{'ImgName'} eq '') { &error('ファイル名を指定してください'); }
$in{'ImgName'} =~ s/\r//g;
$in{'ImgName'} =~ s/\n//g;
$in{'ImgName'} =~ s/ //g;
$in{'ImgName'} =~ s/\///g;
$in{'ImgName'} =~ s/\.//g;
$in{'ImgName'} =~ s/\,//g;
$in{'ImgName'} =~ s/\#//g;
$in{'ImgName'} =~ s/\"//g;
$in{'ImgName'} =~ s/\'//g;
$in{'ImgName'} =~ s/\&//g;
$in{'ImgName'} =~ s/\%//g;
$in{'ImgName'} =~ s/\!//g;
$in{'ImgName'} =~ s/\\//g;
$in{'ImgName'} =~ s/=//g;

$RegImgName='../img/'.$in{'ImgName'}.$in{'ImgExt'};

##添付ファイルのアップロード
if (($agent =~ /Mac/i) | ($agent =~ /PPC/i)) {
	foreach (@in) { if ($_ =~ /Content-type:/i) { &imageregist; } }
} elsif (($agent =~ /Windows/i) | ($agent =~ /NT/i))  {
	if ($in{'imgfile'} ne '') { &imageregist; }
} else {
	if ($in{'imgfile'} ne '') { &imageregist; }
}

##処理画面出力
my $jumpurl = "$cginame?mode=admin&TargFile=".$in{'TargFile'}."&RootReg=".$in{'RootReg'};
my $htmla_jumpurl = <<"JUMPA";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>ファイル操作</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、ファイルのアップロード中です。</h2>
</body></html>
JUMPA

print "Content-type: text/html\n\n";
print $htmla_jumpurl;

exit;
}
##=======================================================================================
sub delimage {

##変数情報の取得
my $delFilePath;
if ($in{'delfile'} ne '') {
	$delFilePath='../img/'.$in{'delfile'};
	if (-e $delFilePath) { unlink($delFilePath); }
}

##処理画面出力
my $jumpurl;
if ($in{'TargFile'} ne '') {
	$jumpurl = "$cginame?mode=admin&TargFile=".$in{'TargFile'}."&RootReg=".$in{'RootReg'};
} else {
	$jumpurl = "$cginame?mode=admin&RootReg=".$in{'RootReg'};
}

my $htmla_jumpurl = <<"JUMPA";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>ファイル操作</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、 $in{'delfile'} を削除中です。</h2>
</body></html>
JUMPA

print "Content-type: text/html\n\n";
print $htmla_jumpurl;

exit;
}
##=======================================================================================
sub imageregist {
	
	# マックバイナリ対策
	my $macbin=0;
	foreach (@in) {
		if ($_ =~ /application\/x-macbinary/i) { $macbin=1; }
	}
	if ($macbin) {
		my $length = substr($upfile,83,4);
		$length = unpack("%N",$length);
		$upfile = substr($upfile,128,$length);
	}

	# 添付データを書き込み
	my $TmpImage='../img/'.$$.'.tmp';
	my $buffer;
	open(OUT,"> $TmpImage") || &error('アップロード失敗');
	binmode(OUT);
	binmode(STDOUT);
	while (read($upfile, $buffer, 1024)) { 
		print OUT $buffer;
	} 
	print OUT $upfile;
	close(OUT);
	chmod(oct($WRMode),$TmpImage);
	rename($TmpImage,$RegImgName);
	
}
##=======================================================================================
sub MakeIndexFile {

our $di;
our @DIRLIST=();
our @DIRLINE=();
our @DIRNAME=();
our @DirCONF=();
our $TargDir;
our $geturl;
our $checkurl;
our $delindex;
our $setindex;
our $veiwindex;
our $SkipOutIndex;
our $checkConf;
our $status;

##コンテンツ設定ファイル読込
if (open(DIRRD,"dir.dat")) {
	@DIRLIST = <DIRRD>;
	close(DIRRD);
}
##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>コンテンツページ更\新\処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、コンテンツページの更\新\処理中です。</h3>
<div align="center">
htJump

print "Content-type: text/html\n\n";
print $htJump;

$di=0;
foreach(@DIRLIST) {
	$SkipOutIndex=2;
	@DIRLINE=split(/\,/,$DIRLIST[$di]);
	$TargDir = $DIRLINE[0];
	$DIRLINE[1] =~ s/\r//g; $DIRLINE[1] =~ s/\n//g;
	if ($DIRLINE[1] ne 'other') {
		#URL取得
		if ($RootPath eq '') {
			$geturl = 'http://'.$Domain.'/'.$TargDir.'/index.cgi';
			$checkurl= '../'.$TargDir.'/index.cgi';
		} else {
			$geturl = 'http://'.$Domain.'/'.$RootPath.'/'.$TargDir.'/index.cgi';
			$checkurl= '../'.'/'.$TargDir.'/index.cgi';
		}
		
		#古いindex.htmlを削除
		$delindex='../'.$TargDir.'/index.html';
		unlink ($delindex);
		
		#pgedit処理
		if ($DIRLINE[1] eq 'pgedit') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
			}
			$DirCONF[56] =~ s/\r//g; $DirCONF[56] =~ s/\n//g;
			if ($DirCONF[56] eq '') { $SkipOutIndex=1; }
		}
		#pgedit2処理
		if ($DIRLINE[1] eq 'pgedit2') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
			}
			$DirCONF[63] =~ s/\r//g; $DirCONF[63] =~ s/\n//g;
			if ($DirCONF[63] eq '') { $SkipOutIndex=1; }
		}
		#calender処理
		if ($DIRLINE[1] eq 'calender') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
			}
			$DirCONF[37] =~ s/\r//g; $DirCONF[37] =~ s/\n//g;
			if ($DirCONF[37] eq '') { $SkipOutIndex=1; }
		}
		#index.htmlを書き出し
		if ($SkipOutIndex == 2) {
			if (-e $checkurl) {
				$setindex='../'.$TargDir.'/index.html';
				$veiwindex = '/'.$TargDir.'/index.html';
				$status = &GetStore($geturl,$setindex);
				if ($status eq 'ok') {
					print $veiwindex.' を再出力しました<br>';
				} else {
					print '<font style="color:red">'.$veiwindex.' を再出力失敗</font><br>';
				}
			}
		}
	}
	$di++;
}
##★処理画面出力
$htJump = <<"htJump";
</div>
</body></html>
htJump
print $htJump;

exit;

}
##=======================================================================================
sub GetStore {
	use LWP::UserAgent;
	our $ua = LWP::UserAgent->new;
	my $re = $ua->simple_request(HTTP::Request->new(GET => $_[0]));
	if($re->code() == 200){
		open(my $IMG,">$_[1]");
		binmode($IMG);
		print $IMG $re->content();
		close($IMG);
		chmod(oct($WRMode),$_[1]);
		return 'ok';
	} else { 	return 'false'; }
}
##=======================================================================================
sub emoji {

##スキンファイル取得##
my $TagEmojiList;
my $EmojiCode;
my $EmojiFileName;
my $EmojiDir='../emoji/';
my @EmojiFiles=&GetFilelist($EmojiDir,'.gif',0);
@EmojiFiles=sort(@EmojiFiles);

$TagEmojiList='<table style="border:2px solid #CCCCCC; border-collapse:collapse;" align="center">'."\n";
my $i=0;
foreach (@EmojiFiles) {
	if ($i==0) { $TagEmojiList=$TagEmojiList.'<tr>'; }
	$EmojiCode=$_;
	$EmojiCode=~ s/\.gif//g;
	$EmojiCode='['.$EmojiCode.']';
	$EmojiFileName=$_;
	$TagEmojiList=$TagEmojiList.'<td style="border:2px solid #CCCCCC; border-collapse:collapse;padding:5px">';
	$TagEmojiList=$TagEmojiList.'<img src="'.$EmojiDir.$EmojiFileName.'"> '
		.$EmojiCode.'<br>';
	$TagEmojiList=$TagEmojiList.'</td>';
	if ($i==9) {
		$TagEmojiList=$TagEmojiList.'</tr>'."\n"; $i=0;
	} else { $i++; }
}

##★絵文字一覧はここを訂正
my $htEMOJI = <<"htEMOJI";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>絵文字コード一覧</title>
<link rel="stylesheet" href="../admin/style.css" type="text/css">
</head>
<body>
<h3 align=center>絵文字コード一覧</h3>
$TagEmojiList
</body>
</html>
htEMOJI

print "Content-type: text/html\n\n";
print $htEMOJI;

}
##=======================================================================================
