/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.HibernateException;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private static Log log = LogFactory.getLog(Workspace.class);
    private Map<Class, DocumentBuilder<Object>> documentBuilders;
    private Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders;
    private Map<DirectoryProvider, IndexReader> readers = new HashMap<DirectoryProvider, IndexReader>();
    private Map<DirectoryProvider, IndexWriter> writers = new HashMap<DirectoryProvider, IndexWriter>();
    private List<DirectoryProvider> lockedProviders = new ArrayList<DirectoryProvider>();

    public Workspace(Map<Class, DocumentBuilder<Object>> documentBuilders, Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders) {
        this.documentBuilders = documentBuilders;
        this.lockableDirectoryProviders = lockableDirectoryProviders;
    }

    public DocumentBuilder getDocumentBuilder(Class entity) {
        return this.documentBuilders.get(entity);
    }

    public IndexReader getIndexReader(Class entity) {
        DirectoryProvider provider = this.documentBuilders.get(entity).getDirectoryProvider();
        IndexReader reader = this.readers.get(provider);
        if (reader != null) {
            return reader;
        }
        this.lockProvider(provider);
        try {
            reader = IndexReader.open(provider.getDirectory());
            this.readers.put(provider, reader);
        }
        catch (IOException e) {
            this.cleanUp(new HibernateException("Unable to open IndexReader for " + entity, e));
        }
        return reader;
    }

    public IndexWriter getIndexWriter(Class entity) {
        DirectoryProvider provider = this.documentBuilders.get(entity).getDirectoryProvider();
        IndexWriter writer = this.writers.get(provider);
        if (writer != null) {
            return writer;
        }
        this.lockProvider(provider);
        try {
            writer = new IndexWriter(provider.getDirectory(), this.documentBuilders.get(entity).getAnalyzer(), false);
            this.writers.put(provider, writer);
        }
        catch (IOException e) {
            this.cleanUp(new HibernateException("Unable to open IndexWriter for " + entity, e));
        }
        return writer;
    }

    private void lockProvider(DirectoryProvider provider) {
        ReentrantLock lock = this.lockableDirectoryProviders.get(provider);
        if (!lock.isHeldByCurrentThread()) {
            lock.lock();
            this.lockedProviders.add(provider);
        }
    }

    private void cleanUp(HibernateException originalException) {
        HibernateException raisedException = originalException;
        for (IndexReader reader : this.readers.values()) {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (raisedException != null) {
                    log.error((Object)"Subsequent Exception while closing IndexReader", (Throwable)e);
                    continue;
                }
                raisedException = new HibernateException("Exception while closing IndexReader", e);
            }
        }
        for (IndexWriter writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                if (raisedException != null) {
                    log.error((Object)"Subsequent Exception while closing IndexWriter", (Throwable)e);
                    continue;
                }
                raisedException = new HibernateException("Exception while closing IndexWriter", e);
            }
        }
        for (DirectoryProvider provider : this.lockedProviders) {
            this.lockableDirectoryProviders.get(provider).unlock();
        }
        this.readers.clear();
        this.writers.clear();
        this.lockedProviders.clear();
        if (raisedException != null) {
            throw raisedException;
        }
    }

    public void clean() {
        this.cleanUp(null);
    }
}

