/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.alert;

import com.sun.appserv.management.alert.LogDomains;
import com.sun.appserv.management.alert.UnitTest;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.Notification;
import javax.management.NotificationListener;

public class MailAlert
implements NotificationListener {
    private String subject = "Alert from SJAS AppServer";
    private String recipients;
    private String mailResourceName;
    private String fromAddress;
    private InternetAddress fromSMTPAddress;
    private String mailSMTPHost = "localhost";
    private boolean includeDiagnostics;
    Logger alertLogger = LogDomains.getAlertLogger();

    public MailAlert() {
        this.setFromAddress("SJASAlert@sun.com");
        this.includeDiagnostics = false;
        if (this.alertLogger.isLoggable(Level.FINE)) {
            this.alertLogger.log(Level.FINE, "MailAlert instantiated");
        }
    }

    public void setSubject(String subject) {
        this.subject = subject;
        if (this.alertLogger.isLoggable(Level.FINE)) {
            this.alertLogger.log(Level.FINE, "setSubject called with -> " + subject);
        }
    }

    String getSubject() {
        return this.subject;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
        if (this.alertLogger.isLoggable(Level.FINE)) {
            this.alertLogger.log(Level.FINE, "setRecipients called with -> " + recipients);
        }
    }

    String getRecipients() {
        return this.recipients;
    }

    public void setMailSMTPHost(String mailSMTPHost) {
        this.mailSMTPHost = mailSMTPHost;
        if (this.alertLogger.isLoggable(Level.FINE)) {
            this.alertLogger.log(Level.FINE, "setMailSMTPHost called with ->" + mailSMTPHost);
        }
    }

    String getMailSMTPHost() {
        return this.mailSMTPHost;
    }

    public void setMailResourceName(String mailResourceName) {
        this.mailResourceName = mailResourceName;
    }

    String getMailResourceName() {
        return this.mailResourceName;
    }

    public void setFromAddress(String fromAddress) {
        if (this.alertLogger.isLoggable(Level.FINE)) {
            this.alertLogger.log(Level.FINE, "setFromAddress called with address ->" + fromAddress);
        }
        this.fromAddress = fromAddress;
        try {
            this.fromSMTPAddress = new InternetAddress(fromAddress);
        }
        catch (Exception e) {
            this.alertLogger.log(Level.FINE, "Exception in MailAlert.setFromAddress ->" + e);
        }
    }

    String getFromAddress() {
        return this.fromAddress;
    }

    public void setIncludeDiagnostics(boolean includeDiagnostics) {
        this.includeDiagnostics = includeDiagnostics;
    }

    boolean getIncludeDiagnostics() {
        return this.includeDiagnostics;
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.mailSMTPHost);
            Session session = Session.getDefaultInstance(props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom(this.fromSMTPAddress);
            message.setRecipients(Message.RecipientType.TO, this.recipients);
            message.setSubject(this.subject);
            message.setText(notification.toString());
            Transport.send(message);
        }
        catch (Exception e) {
            this.alertLogger.log(Level.FINE, "Exception in MailAlert.handleNotification ->" + e);
        }
    }

    public void setUnitTestData(String unitTestData) {
        this.alertLogger.log(Level.FINE, "UnitTestData -> " + unitTestData);
        new UnitTest(1, unitTestData, this).start();
    }
}

