/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.naming;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinPolicy {
    private List<ClusterInstanceInfo> endpointsList = new LinkedList<ClusterInstanceInfo>();
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static Random rand = new Random();
    private int sumOfAllWeights = 0;
    private static final int default_weight = 10;

    public RoundRobinPolicy(String[] list) {
        this.setClusterInstanceInfo(list);
    }

    public synchronized void setClusterInstanceInfo(List<ClusterInstanceInfo> list) {
        boolean isWeighted;
        this.sumOfAllWeights = 0;
        this.endpointsList = list;
        String policy = System.getProperty("com.sun.appserv.iiop.loadbalancingpolicy");
        if (policy == null) {
            policy = "ic-based";
        }
        if (policy.equals("ic-based-weighted")) {
            isWeighted = true;
        } else if (policy.equals("ic-based")) {
            isWeighted = false;
        } else {
            isWeighted = false;
            _logger.warning("loadbalancing.policy.incorrect");
        }
        _logger.fine("isWeighted = " + isWeighted);
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            if (!isWeighted) {
                endpoint.weight = 10;
            }
            _logger.info("endpoint.weight after checking isWeight = " + endpoint.weight);
            this.sumOfAllWeights += endpoint.weight;
        }
        _logger.info("sumOfAllWeights = " + this.sumOfAllWeights);
    }

    public synchronized void setClusterInstanceInfo(String[] list) {
        String[] newList = null;
        newList = list != null && list.length > 0 ? this.getAddressPortList(list) : this.getEndpointForProviderURL(System.getProperty("java.naming.provider.url"));
        if (newList != null && newList.length > 0) {
            String[] new_list = this.randomize(newList);
            LinkedList<ClusterInstanceInfo> targetServerList = new LinkedList<ClusterInstanceInfo>();
            for (int i = 0; i < new_list.length; ++i) {
                if (!this.notDuplicate(new_list[i])) continue;
                targetServerList.add(this.makeClusterInstanceInfo(new_list[i], 10));
            }
            if (!targetServerList.isEmpty()) {
                targetServerList.addAll(this.endpointsList);
                this.setClusterInstanceInfo(targetServerList);
            }
        } else {
            _logger.log(Level.WARNING, "no.endpoints");
        }
    }

    private ClusterInstanceInfo makeClusterInstanceInfo(String str, int weight) {
        String[] host_port = str.split(":");
        String server_identifier = "";
        String type = "CLEAR_TEXT";
        SocketInfo socketInfo = new SocketInfo(type, host_port[0], new Integer(host_port[1]));
        ClusterInstanceInfo instanceInfo = new ClusterInstanceInfo(server_identifier, weight, new SocketInfo[]{socketInfo});
        return instanceInfo;
    }

    private synchronized boolean notDuplicate(String str) {
        String[] host_port = str.split(":");
        Iterator<ClusterInstanceInfo> i$ = this.endpointsList.iterator();
        while (i$.hasNext()) {
            ClusterInstanceInfo endpoint;
            ClusterInstanceInfo instanceInfo = endpoint = i$.next();
            for (int j = 0; j < instanceInfo.endpoints.length; ++j) {
                if (!instanceInfo.endpoints[j].host.equals(host_port[0]) || instanceInfo.endpoints[j].port != new Integer(host_port[1])) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getEndpointForProviderURL(String providerURLString) {
        String[] newList = null;
        if (providerURLString != null) {
            try {
                IiopUrl providerURL = new IiopUrl(providerURLString);
                newList = this.getAddressPortList(providerURL);
                _logger.log(Level.WARNING, "no.endpoints.selected.provider", new Object[]{providerURLString});
            }
            catch (MalformedURLException me) {
                _logger.log(Level.WARNING, "provider.exception", new Object[]{me.getMessage(), providerURLString});
            }
        }
        return newList;
    }

    public String[] randomize(String[] list) {
        String[] randomizedList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            int random;
            do {
                random = rand.nextInt(list.length);
                _logger.fine("random ==> " + random);
            } while (list[random] == null);
            randomizedList[i] = list[random];
            _logger.fine("randomisedList[" + i + "] ==> " + randomizedList[i]);
            list[random] = null;
        }
        return randomizedList;
    }

    public synchronized boolean isEmpty() {
        return this.endpointsList.size() == 0;
    }

    public synchronized Object[] getNextRotation() {
        int lowerLimit = 0;
        int random = 0;
        _logger.fine("RoundRobinPolicy.getNextRotation -> sumOfAllWeights = " + this.sumOfAllWeights);
        while (random == 0 && (random = rand.nextInt(this.sumOfAllWeights)) == 0) {
        }
        _logger.fine("getNextRotation : random # = " + random + " sum of all weights = " + this.sumOfAllWeights);
        int i = 0;
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            int upperLimit = lowerLimit + endpoint.weight;
            _logger.fine("upperLimit = " + upperLimit);
            if (random > lowerLimit && random <= upperLimit) {
                LinkedList<ClusterInstanceInfo> instanceInfo = new LinkedList<ClusterInstanceInfo>();
                instanceInfo.addAll(0, this.endpointsList.subList(i, this.endpointsList.size()));
                instanceInfo.addAll(this.endpointsList.subList(0, i));
                _logger.fine("returning the following list..." + ((Object)instanceInfo).toString());
                return this.convertIntoCorbaloc(instanceInfo);
            }
            lowerLimit = upperLimit;
            _logger.fine("lowerLimit = " + lowerLimit);
            ++i;
        }
        _logger.warning("Could not find an endpoint to send request to!");
        return null;
    }

    private Object[] convertIntoCorbaloc(List<ClusterInstanceInfo> list) {
        LinkedList<String> host_port = new LinkedList<String>();
        for (ClusterInstanceInfo endpoint : list) {
            SocketInfo[] socketInfo = endpoint.endpoints;
            for (int j = 0; j < socketInfo.length; ++j) {
                if (host_port.contains(socketInfo[j].host.trim() + ":" + socketInfo[j].port)) continue;
                host_port.add(socketInfo[j].host.trim() + ":" + socketInfo[j].port);
            }
        }
        return host_port.toArray();
    }

    private String[] getAddressPortList(String[] hostPortList) {
        Vector<String> addressPortVector = new Vector<String>();
        for (int i = 0; i < hostPortList.length; ++i) {
            try {
                IiopUrl url = new IiopUrl("iiop://" + hostPortList[i]);
                String[] apList = this.getAddressPortList(url);
                for (int j = 0; j < apList.length; ++j) {
                    addressPortVector.addElement(apList[j]);
                }
                continue;
            }
            catch (MalformedURLException me) {
                _logger.log(Level.WARNING, "bad.host.port", new Object[]{hostPortList[i], me.getMessage()});
            }
        }
        String[] ret = new String[addressPortVector.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)addressPortVector.elementAt(i);
        }
        return ret;
    }

    private String[] getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address iiopUrlAddress = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String host = iiopUrlAddress.host;
        int portNumber = iiopUrlAddress.port;
        String port = Integer.toString(portNumber);
        return this.getAddressPortList(host, port);
    }

    public String[] getAddressPortList(String host, String port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            String[] ret = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                ret[i] = addresses[i].getHostAddress() + ":" + port;
            }
            return ret;
        }
        catch (UnknownHostException ukhe) {
            _logger.log(Level.WARNING, "unknown.host", new Object[]{host, ukhe.getMessage()});
            return null;
        }
    }

    public synchronized void print() {
        _logger.fine("List contents ==> ");
        int i = 0;
        Iterator<ClusterInstanceInfo> i$ = this.endpointsList.iterator();
        while (i$.hasNext()) {
            ClusterInstanceInfo endpoint;
            ClusterInstanceInfo instanceInfo = endpoint = i$.next();
            _logger.fine("endpoint[" + i + "] ==> name =" + instanceInfo.name + " weight = " + instanceInfo.weight);
            for (int j = 0; j < instanceInfo.endpoints.length; ++j) {
                _logger.fine("IP addresses = " + instanceInfo.endpoints[j].host + ":" + instanceInfo.endpoints[j].port + " type = " + instanceInfo.endpoints[j].type);
            }
            ++i;
        }
    }
}

