/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.ServerTool;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.Locator;
import com.sun.corba.ee.spi.activation.LocatorHelper;
import com.sun.corba.ee.spi.activation.LocatorPackage.ServerLocation;
import com.sun.corba.ee.spi.activation.NoSuchEndPoint;
import com.sun.corba.ee.spi.activation.ORBPortInfo;
import com.sun.corba.ee.spi.activation.ServerHeldDown;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class LocateServer
implements CommandHandler {
    static final int illegalServerId = -1;

    LocateServer() {
    }

    public String getCommandName() {
        return "locate";
    }

    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.locate"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.locate1"));
        }
    }

    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int serverId = -1;
        String endPointType = "IIOP_CLEAR_TEXT";
        try {
            int i = 0;
            while (i < cmdArgs.length) {
                String arg;
                if ((arg = cmdArgs[i++]).equals("-serverid")) {
                    if (i < cmdArgs.length) {
                        serverId = Integer.valueOf(cmdArgs[i++]);
                        continue;
                    }
                    return true;
                }
                if (arg.equals("-applicationName")) {
                    if (i < cmdArgs.length) {
                        serverId = ServerTool.getServerIdForAlias(orb, cmdArgs[i++]);
                        continue;
                    }
                    return true;
                }
                if (!arg.equals("-endpointType") || i >= cmdArgs.length) continue;
                endPointType = cmdArgs[i++];
            }
            if (serverId == -1) {
                return true;
            }
            Locator locator = LocatorHelper.narrow(orb.resolve_initial_references("ServerLocator"));
            ServerLocation location = locator.locateServer(serverId, endPointType);
            out.println(CorbaResourceUtil.getText("servertool.locate2", location.hostname));
            for (ORBPortInfo orbPort : location.ports) {
                out.println("\t\t" + orbPort.port + "\t\t" + endPointType + "\t\t" + orbPort.orbId);
            }
        }
        catch (NoSuchEndPoint ex) {
        }
        catch (ServerHeldDown ex) {
            out.println(CorbaResourceUtil.getText("servertool.helddown"));
        }
        catch (ServerNotRegistered ex) {
            out.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

