/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.Codes;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastInputStream {
    private List<ByteBuffer> data;
    private Iterator<ByteBuffer> iter;
    private ByteBuffer current;
    private List<Object> indirections;
    private static final int DATA_SIZE = 4096;

    private void error(String msg) {
        throw new IllegalStateException(msg);
    }

    private void allocate() {
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
        } else {
            this.error("Tried to read past end of stream");
        }
    }

    public FastInputStream(List<ByteBuffer> data) {
        this.data = data;
        this.iter = data.iterator();
        this.allocate();
        this.indirections = new ArrayList<Object>(100);
    }

    public void close() {
        this.data = null;
        this.current = null;
        this.indirections = null;
    }

    private String code(byte b) {
        Codes[] codes = (Codes[])Codes.class.getEnumConstants();
        if (b >= 0 && b < codes.length) {
            return codes[b].toString();
        }
        return "invalid Code(" + b + ")";
    }

    private Codes getCode() {
        byte b = this.getByte();
        Codes[] codes = (Codes[])Codes.class.getEnumConstants();
        if (b >= 0 && b < codes.length) {
            return codes[b];
        }
        this.error("Invalid code " + b);
        return null;
    }

    private void expect(Codes code) {
        byte b = this.getByte();
        if (code.ordinal() != b) {
            this.error("Error in reading stream: expected " + (Object)((Object)code) + " but read " + this.code(b));
        }
    }

    private boolean getBoolean() {
        byte b;
        try {
            b = this.current.get();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            b = this.current.get();
        }
        if (b == 0) {
            return false;
        }
        if (b == 1) {
            return true;
        }
        this.error("Invalid boolean in stream: value was " + b);
        return false;
    }

    private byte getByte() {
        try {
            return this.current.get();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.get();
        }
    }

    private short getShort() {
        try {
            return this.current.getShort();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getShort();
        }
    }

    private char getChar() {
        try {
            return this.current.getChar();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getChar();
        }
    }

    private int getInt() {
        try {
            return this.current.getInt();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getInt();
        }
    }

    private long getLong() {
        try {
            return this.current.getLong();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getLong();
        }
    }

    private float getFloat() {
        try {
            return this.current.getFloat();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getFloat();
        }
    }

    private double getDouble() {
        try {
            return this.current.getDouble();
        }
        catch (BufferUnderflowException exc) {
            this.allocate();
            return this.current.getDouble();
        }
    }

    public boolean readBoolean() {
        this.expect(Codes.BOOL);
        return this.getBoolean();
    }

    public char readChar() {
        this.expect(Codes.CHAR);
        return this.getChar();
    }

    public byte readByte() {
        this.expect(Codes.BYTE);
        return this.getByte();
    }

    public short readShort() {
        this.expect(Codes.SHORT);
        return this.getShort();
    }

    public int readInt() {
        this.expect(Codes.INT);
        return this.getInt();
    }

    public long readLong() {
        this.expect(Codes.LONG);
        return this.getLong();
    }

    public float readFloat() {
        this.expect(Codes.FLOAT);
        return this.getFloat();
    }

    public double readDouble() {
        this.expect(Codes.DOUBLE);
        return this.getDouble();
    }

    private <T> T handleIndirection(Class<T> cls) {
        int indir = -this.getInt();
        if (indir > 0 && indir < this.indirections.size()) {
            Object val = this.indirections.get(indir);
            if (val == null) {
                this.error("Indirection to a NULL value");
            } else {
                if (cls.isInstance(val)) {
                    return cls.cast(val);
                }
                this.error("Indirection to value " + val + " of incompatible type. Expected type " + cls.getName());
            }
        } else {
            this.error("Indirection value " + indir + " is out of range");
        }
        return null;
    }

    public boolean[] readBooleanArray() {
        Codes code = this.getCode();
        if (code == Codes.REF) {
            int indir = -this.getInt();
            if (indir > 0 && indir < this.indirections.size()) {
                Object val = this.indirections.get(indir);
                if (val == null) {
                    this.error("Indirection to a NULL value");
                } else {
                    if (val instanceof boolean[]) {
                        return (boolean[])val;
                    }
                    this.error("Indirection to non-String value " + val);
                }
            } else {
                this.error("Indirection value " + indir + " is out of range");
            }
        } else {
            if (code == Codes.BOOL_ARR) {
                int indir1 = -this.getInt();
                int len = this.getInt();
                boolean[] result = new boolean[len];
                for (int ctr = 0; ctr < len; ++ctr) {
                    result[ctr] = this.getBoolean();
                }
                this.indirections.set(indir1, result);
                return result;
            }
            this.error("Expected INDIR or ARRAY BOOL, but read " + (Object)((Object)code));
        }
        return null;
    }

    public char[] readCharArray() {
        return null;
    }

    public byte[] readByteArray() {
        return null;
    }

    public short[] readShortArray() {
        return null;
    }

    public int[] readIntArray() {
        return null;
    }

    public long[] readLongArray() {
        return null;
    }

    public float[] readFloatArray() {
        return null;
    }

    public double[] readDoubleArray() {
        return null;
    }

    public void readNull() {
    }

    public Object startReference() {
        return null;
    }

    public void endReference() {
    }

    public Pair<Object, Integer> startReferenceArray(String className, int size) {
        return null;
    }
}

