/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.legacy.connection.USLPort;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.oa.poa.BadServerIdHandler;
import com.sun.corba.ee.impl.transport.DefaultIORToSocketInfoImpl;
import com.sun.corba.ee.impl.transport.DefaultSocketFactoryImpl;
import com.sun.corba.ee.impl.transport.TcpTimeoutsImpl;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.orb.OperationFactory;
import com.sun.corba.ee.spi.orb.OperationFactoryExt;
import com.sun.corba.ee.spi.orb.ParserData;
import com.sun.corba.ee.spi.orb.ParserDataFactory;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.misc.ORBClassLoader;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class ParserTable {
    private static String MY_CLASS_NAME = ParserTable.class.getName();
    private static ParserTable myInstance = new ParserTable();
    private ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_ORB_LIFECYCLE_ORBUtil();
    private ParserData[] parserData;

    public static ParserTable get() {
        return myInstance;
    }

    public ParserData[] getParserData() {
        return this.parserData;
    }

    private ParserTable() {
        String codeSetTestString = "65537,65801,65568";
        String[] debugTestData = new String[]{"subcontract", "poa", "transport"};
        USLPort[] USLPorts = new USLPort[]{new USLPort("FOO", 2701), new USLPort("BAR", 3333)};
        TcpTimeouts testTcpTimeouts = TcpTimeouts.factory.create(2000, 6000, 20);
        TcpTimeouts defaultTcpTimeouts = TcpTimeouts.factory.create(2000, 6000, 20);
        TcpTimeouts testTcpConnectTimeouts = TcpTimeouts.factory.create(20, 60000, 100, 5000);
        TcpTimeouts defaultTcpConnectTimeouts = TcpTimeouts.factory.create(250, 60000, 100, 5000);
        ORBInitializer[] TestORBInitializers = new ORBInitializer[]{null, new TestORBInitializer1(), new TestORBInitializer2()};
        Pair[] TestORBInitData = new Pair[]{new Pair<String, String>("foo.bar.blech.NonExistent", "dummy"), new Pair<String, String>(MY_CLASS_NAME + "$TestORBInitializer1", "dummy"), new Pair<String, String>(MY_CLASS_NAME + "$TestORBInitializer2", "dummy")};
        Acceptor[] TestAcceptors = new Acceptor[]{null, new TestAcceptor2(), new TestAcceptor1()};
        Pair[] TestAcceptorData = new Pair[]{new Pair<String, String>("foo.bar.blech.NonExistent", "dummy"), new Pair<String, String>(MY_CLASS_NAME + "$TestAcceptor1", "dummy"), new Pair<String, String>(MY_CLASS_NAME + "$TestAcceptor2", "dummy")};
        Pair[] TestORBInitRefData = new Pair[]{new Pair<String, String>("Foo", "ior:930492049394"), new Pair<String, String>("Bar", "ior:3453465785633576")};
        ParserData[] pd = new ParserData[]{ParserDataFactory.make("com.sun.corba.ee.ORBDebug", OperationFactory.listAction(",", OperationFactory.stringAction()), "debugFlags", new String[0], debugTestData, "subcontract,poa,transport"), ParserDataFactory.make("org.omg.CORBA.ORBInitialHost", OperationFactory.stringAction(), "ORBInitialHost", "", "Foo", "Foo"), ParserDataFactory.make("org.omg.CORBA.ORBInitialPort", OperationFactory.integerAction(), "ORBInitialPort", new Integer(900), new Integer(27314), "27314"), ParserDataFactory.make("com.sun.corba.ee.ORBServerHost", OperationFactory.stringAction(), "ORBServerHost", "", "camelot", "camelot"), ParserDataFactory.make("com.sun.corba.ee.ORBServerPort", OperationFactory.integerAction(), "ORBServerPort", new Integer(0), new Integer(38143), "38143"), ParserDataFactory.make("org.omg.CORBA.ORBId", OperationFactory.stringAction(), "orbId", "", "foo", "foo"), ParserDataFactory.make("com.sun.corba.ee.ORBid", OperationFactory.stringAction(), "orbId", "", "foo", "foo"), ParserDataFactory.make("org.omg.CORBA.ORBServerId", OperationFactory.integerAction(), "persistentServerId", new Integer(-1), new Integer(1234), "1234"), ParserDataFactory.make("org.omg.CORBA.ORBServerId", OperationFactory.setFlagAction(), "persistentServerIdInitialized", Boolean.FALSE, Boolean.TRUE, "1234"), ParserDataFactory.make("com.sun.corba.ee.connection.ORBHighWaterMark", OperationFactory.integerAction(), "highWaterMark", new Integer(240), new Integer(3745), "3745"), ParserDataFactory.make("com.sun.corba.ee.connection.ORBLowWaterMark", OperationFactory.integerAction(), "lowWaterMark", new Integer(100), new Integer(12), "12"), ParserDataFactory.make("com.sun.corba.ee.connection.ORBNumberToReclaim", OperationFactory.integerAction(), "numberToReclaim", new Integer(5), new Integer(231), "231"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBGIOPVersion", this.makeGVOperation(), "giopVersion", GIOPVersion.DEFAULT_VERSION, new GIOPVersion(2, 3), "2.3"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBFragmentSize", this.makeFSOperation(), "giopFragmentSize", new Integer(4096), new Integer(65536), "65536"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBBufferSize", OperationFactory.integerAction(), "giopBufferSize", new Integer(4096), new Integer(234000), "234000"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBGIOP11BuffMgr", this.makeBMGROperation(), "giop11BuffMgr", new Integer(0), new Integer(1), "CLCT"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBGIOP12BuffMgr", this.makeBMGROperation(), "giop12BuffMgr", new Integer(2), new Integer(0), "GROW"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBTargetAddressing", OperationFactory.compose(OperationFactory.integerRangeAction(0, 3), OperationFactory.convertIntegerToShort()), "giopTargetAddressPreference", new Short(3), new Short(2), "2"), ParserDataFactory.make("com.sun.corba.ee.giop.ORBTargetAddressing", this.makeADOperation(), "giopAddressDisposition", new Short(0), new Short(2), "2"), ParserDataFactory.make("com.sun.corba.ee.codeset.AlwaysSendCodeSetCtx", OperationFactory.booleanAction(), "alwaysSendCodeSetCtx", Boolean.TRUE, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.codeset.UseByteOrderMarkers", OperationFactory.booleanAction(), "useByteOrderMarkers", true, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.codeset.UseByteOrderMarkersInEncaps", OperationFactory.booleanAction(), "useByteOrderMarkersInEncaps", false, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.codeset.charsets", this.makeCSOperation(), "charData", CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.getCharComponent(), CodeSetComponentInfo.createFromString(codeSetTestString), codeSetTestString), ParserDataFactory.make("com.sun.corba.ee.codeset.wcharsets", this.makeCSOperation(), "wcharData", CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.getWCharComponent(), CodeSetComponentInfo.createFromString(codeSetTestString), codeSetTestString), ParserDataFactory.make("com.sun.corba.ee.ORBAllowLocalOptimization", OperationFactory.booleanAction(), "allowLocalOptimization", Boolean.FALSE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.legacy.connection.ORBSocketFactoryClass", this.makeLegacySocketFactoryOperation(), "legacySocketFactory", null, new TestLegacyORBSocketFactory(), MY_CLASS_NAME + "$TestLegacyORBSocketFactory"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBSocketFactoryClass", this.makeSocketFactoryOperation(), "socketFactory", new DefaultSocketFactoryImpl(), new TestORBSocketFactory(), MY_CLASS_NAME + "$TestORBSocketFactory"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBListenSocket", this.makeUSLOperation(), "userSpecifiedListenPorts", new USLPort[0], USLPorts, "FOO:2701,BAR:3333"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBIORToSocketInfoClass", this.makeIORToSocketInfoOperation(), "iorToSocketInfo", new DefaultIORToSocketInfoImpl(), new TestIORToSocketInfo(), MY_CLASS_NAME + "$TestIORToSocketInfo"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBIIOPPrimaryToContactInfoClass", this.makeIIOPPrimaryToContactInfoOperation(), "iiopPrimaryToContactInfo", null, new TestIIOPPrimaryToContactInfo(), MY_CLASS_NAME + "$TestIIOPPrimaryToContactInfo"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBContactInfoList", this.makeContactInfoListFactoryOperation(), "corbaContactInfoListFactory", null, new TestContactInfoListFactory(), MY_CLASS_NAME + "$TestContactInfoListFactory"), ParserDataFactory.make("com.sun.corba.ee.POA.ORBPersistentServerPort", OperationFactory.integerAction(), "persistentServerPort", new Integer(0), new Integer(2743), "2743"), ParserDataFactory.make("com.sun.corba.ee.POA.ORBPersistentServerPort", OperationFactory.setFlagAction(), "persistentPortInitialized", Boolean.FALSE, Boolean.TRUE, "2743"), ParserDataFactory.make("com.sun.corba.ee.POA.ORBActivated", OperationFactory.booleanAction(), "serverIsORBActivated", Boolean.FALSE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.POA.ORBBadServerIdHandlerClass", OperationFactory.classAction(), "badServerIdHandlerClass", null, TestBadServerIdHandler.class, MY_CLASS_NAME + "$TestBadServerIdHandler"), ParserDataFactory.make("org.omg.PortableInterceptor.ORBInitializerClass.", this.makeROIOperation(), "orbInitializers", new ORBInitializer[0], TestORBInitializers, TestORBInitData, ORBInitializer.class), ParserDataFactory.make("com.sun.corba.ee.transport.ORBAcceptor", this.makeAcceptorInstantiationOperation(), "acceptors", new Acceptor[0], TestAcceptors, TestAcceptorData, Acceptor.class), ParserDataFactory.make("com.sun.corba.ee.transport.ORBAcceptorSocketType", OperationFactory.stringAction(), "acceptorSocketType", "SocketChannel", "foo", "foo"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBUseNIOSelectToWait", OperationFactory.booleanAction(), "acceptorSocketUseSelectThreadToWait", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBAcceptorSocketUseWorkerThreadForEvent", OperationFactory.booleanAction(), "acceptorSocketUseWorkerThreadForEvent", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBConnectionSocketType", OperationFactory.stringAction(), "connectionSocketType", "SocketChannel", "foo", "foo"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBUseNIOSelectToWait", OperationFactory.booleanAction(), "connectionSocketUseSelectThreadToWait", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBConnectionSocketUseWorkerThreadForEvent", OperationFactory.booleanAction(), "connectionSocketUseWorkerThreadForEvent", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBWaitForResponseTimeout", OperationFactory.integerAction(), "waitForResponseTimeout", 1800000, new Integer(1234), "1234"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBDisableDirectByteBufferUse", OperationFactory.booleanAction(), "disableDirectByteBufferUse", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBTCPTimeouts", OperationFactoryExt.convertAction(TcpTimeoutsImpl.class), "tcpTimeouts", defaultTcpTimeouts, testTcpTimeouts, "2000:6000:20"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBTCPConnectTimeouts", OperationFactoryExt.convertAction(TcpTimeoutsImpl.class), "tcpConnectTimeouts", defaultTcpConnectTimeouts, testTcpConnectTimeouts, "20:60000:100:5000"), ParserDataFactory.make("com.sun.corba.ee.encoding.ORBEnableJavaSerialization", OperationFactory.booleanAction(), "enableJavaSerialization", Boolean.FALSE, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.ORBUseRepId", OperationFactory.booleanAction(), "useRepId", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("org.omg.CORBA.ORBInitRef", OperationFactory.identityAction(), "orbInitialReferences", new Pair[0], TestORBInitRefData, TestORBInitRefData, Pair.class), ParserDataFactory.make("com.sun.corba.ee.ORBShowInfoMessages", OperationFactory.booleanAction(), "showInfoMessages", Boolean.FALSE, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.ORBGetServiceContextReturnsNull", OperationFactory.booleanAction(), "getServiceContextReturnsNull", Boolean.FALSE, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.corba.ee.ORBAppServerMode", OperationFactory.booleanAction(), "isAppServerMode", Boolean.FALSE, Boolean.FALSE, "FALSE"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBReadByteBufferSize", OperationFactory.integerAction(), "readByteBufferSize", new Integer(64000), new Integer(8192), "8192"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBMaximumReadByteBufferSize", OperationFactory.integerAction(), "maxReadByteBufferSizeThreshold", new Integer(256000), new Integer(4000000), "4000000"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBPooledDirectByteBufferSlabSize", OperationFactory.integerAction(), "pooledDirectByteBufferSlabSize", new Integer(4000000), new Integer(0x100000), "1048576"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBOptimizedReadAlwaysEnterBlockingRead", OperationFactory.booleanAction(), "alwaysEnterBlockingRead", Boolean.TRUE, Boolean.TRUE, "TRUE"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBNonBlockingReadCheckMessageParser", OperationFactory.booleanAction(), "nonBlockingReadCheckMessageParser", Boolean.TRUE, Boolean.TRUE, "TRUE"), ParserDataFactory.make("com.sun.corba.ee.transport.ORBBlockingReadCheckMessageParser", OperationFactory.booleanAction(), "blockingReadCheckMessageParser", Boolean.FALSE, Boolean.FALSE, "FALSE"), ParserDataFactory.make("com.sun.corba.ee.ORBEnableTimingPoints", OperationFactory.booleanAction(), "timingPointsEnabled", Boolean.FALSE, Boolean.TRUE, "TRUE")};
        this.parserData = pd;
    }

    private Operation makeUSLOperation() {
        Operation[] siop = new Operation[]{OperationFactory.stringAction(), OperationFactory.integerAction()};
        Operation op2 = OperationFactory.sequenceAction(":", siop);
        Operation uslop = new Operation(){

            public Object operate(Object value) {
                Object[] values = (Object[])value;
                String type = (String)values[0];
                Integer port = (Integer)values[1];
                return new USLPort(type, port);
            }
        };
        Operation op3 = OperationFactory.compose(op2, uslop);
        Operation listenop = OperationFactory.listAction(",", op3);
        return listenop;
    }

    private Operation makeMapOperation(final Map map) {
        return new Operation(){

            public Object operate(Object value) {
                return map.get(value);
            }
        };
    }

    private Operation makeBMGROperation() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("GROW", new Integer(0));
        map.put("CLCT", new Integer(1));
        map.put("STRM", new Integer(2));
        return this.makeMapOperation(map);
    }

    private Operation makeLegacySocketFactoryOperation() {
        Operation sfop = new Operation(){

            public Object operate(Object value) {
                String param = (String)value;
                try {
                    Class legacySocketFactoryClass = ORBClassLoader.loadClass(param);
                    if (com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory.class.isAssignableFrom(legacySocketFactoryClass)) {
                        return legacySocketFactoryClass.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalSocketFactoryType(legacySocketFactoryClass.toString());
                }
                catch (Exception ex) {
                    throw ParserTable.this.wrapper.badCustomSocketFactory(ex, (Object)param);
                }
            }
        };
        return sfop;
    }

    private Operation makeSocketFactoryOperation() {
        Operation sfop = new Operation(){

            public Object operate(Object value) {
                String param = (String)value;
                try {
                    Class socketFactoryClass = ORBClassLoader.loadClass(param);
                    if (ORBSocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                        return socketFactoryClass.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalSocketFactoryType(socketFactoryClass.toString());
                }
                catch (Exception ex) {
                    throw ParserTable.this.wrapper.badCustomSocketFactory(ex, (Object)param);
                }
            }
        };
        return sfop;
    }

    private Operation makeIORToSocketInfoOperation() {
        Operation op = new Operation(){

            public Object operate(Object value) {
                String param = (String)value;
                try {
                    Class iorToSocketInfoClass = ORBClassLoader.loadClass(param);
                    if (IORToSocketInfo.class.isAssignableFrom(iorToSocketInfoClass)) {
                        return iorToSocketInfoClass.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalIorToSocketInfoType(iorToSocketInfoClass.toString());
                }
                catch (Exception ex) {
                    throw ParserTable.this.wrapper.badCustomIorToSocketInfo(ex, (Object)param);
                }
            }
        };
        return op;
    }

    private Operation makeIIOPPrimaryToContactInfoOperation() {
        Operation op = new Operation(){

            public Object operate(Object value) {
                String param = (String)value;
                try {
                    Class iiopPrimaryToContactInfoClass = ORBClassLoader.loadClass(param);
                    if (IIOPPrimaryToContactInfo.class.isAssignableFrom(iiopPrimaryToContactInfoClass)) {
                        return iiopPrimaryToContactInfoClass.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalIiopPrimaryToContactInfoType(iiopPrimaryToContactInfoClass.toString());
                }
                catch (Exception ex) {
                    throw ParserTable.this.wrapper.badCustomIiopPrimaryToContactInfo(ex, (Object)param);
                }
            }
        };
        return op;
    }

    private Operation makeContactInfoListFactoryOperation() {
        Operation op = new Operation(){

            public Object operate(Object value) {
                String param = (String)value;
                try {
                    Class contactInfoListFactoryClass = ORBClassLoader.loadClass(param);
                    if (CorbaContactInfoListFactory.class.isAssignableFrom(contactInfoListFactoryClass)) {
                        return contactInfoListFactoryClass.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalContactInfoListFactoryType(contactInfoListFactoryClass.toString());
                }
                catch (Exception ex) {
                    throw ParserTable.this.wrapper.badContactInfoListFactory(ex, (Object)param);
                }
            }
        };
        return op;
    }

    private Operation makeCSOperation() {
        Operation csop = new Operation(){

            public Object operate(Object value) {
                String val = (String)value;
                return CodeSetComponentInfo.createFromString(val);
            }
        };
        return csop;
    }

    private Operation makeADOperation() {
        Operation admap = new Operation(){
            private Integer[] map = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(0)};

            public Object operate(Object value) {
                int val = (Integer)value;
                return this.map[val];
            }
        };
        Operation rangeop = OperationFactory.integerRangeAction(0, 3);
        Operation op1 = OperationFactory.compose(rangeop, admap);
        Operation result = OperationFactory.compose(op1, OperationFactory.convertIntegerToShort());
        return result;
    }

    private Operation makeFSOperation() {
        Operation fschecker = new Operation(){

            public Object operate(Object value) {
                int giopFragmentSize = (Integer)value;
                if (giopFragmentSize < 32) {
                    throw ParserTable.this.wrapper.fragmentSizeMinimum(new Integer(giopFragmentSize), new Integer(32));
                }
                if (giopFragmentSize % 8 != 0) {
                    throw ParserTable.this.wrapper.fragmentSizeDiv(new Integer(giopFragmentSize), new Integer(8));
                }
                return value;
            }
        };
        Operation result = OperationFactory.compose(OperationFactory.integerAction(), fschecker);
        return result;
    }

    private Operation makeGVOperation() {
        Operation gvHelper = OperationFactory.listAction(".", OperationFactory.integerAction());
        Operation gvMain = new Operation(){

            public Object operate(Object value) {
                Object[] nums = (Object[])value;
                int major = (Integer)nums[0];
                int minor = (Integer)nums[1];
                return new GIOPVersion(major, minor);
            }
        };
        Operation result = OperationFactory.compose(gvHelper, gvMain);
        return result;
    }

    private Operation makeROIOperation() {
        Operation clsop = OperationFactory.classAction();
        Operation indexOp = OperationFactory.suffixAction();
        Operation op1 = OperationFactory.compose(indexOp, clsop);
        Operation mop = OperationFactory.maskErrorAction(op1);
        Operation mkinst = new Operation(){

            public Object operate(Object value) {
                final Class initClass = (Class)value;
                if (initClass == null) {
                    return null;
                }
                if (ORBInitializer.class.isAssignableFrom(initClass)) {
                    ORBInitializer initializer = null;
                    try {
                        initializer = (ORBInitializer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws InstantiationException, IllegalAccessException {
                                return initClass.newInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException exc) {
                        throw ParserTable.this.wrapper.orbInitializerFailure(exc.getException(), (Object)initClass.getName());
                    }
                    catch (Exception exc) {
                        throw ParserTable.this.wrapper.orbInitializerFailure(exc, (Object)initClass.getName());
                    }
                    return initializer;
                }
                throw ParserTable.this.wrapper.orbInitializerType(initClass.getName());
            }
        };
        Operation result = OperationFactory.compose(mop, mkinst);
        return result;
    }

    private Operation makeAcceptorInstantiationOperation() {
        Operation clsop = OperationFactory.classAction();
        Operation indexOp = OperationFactory.suffixAction();
        Operation op1 = OperationFactory.compose(indexOp, clsop);
        Operation mop = OperationFactory.maskErrorAction(op1);
        Operation mkinst = new Operation(){

            public Object operate(Object value) {
                final Class initClass = (Class)value;
                if (initClass == null) {
                    return null;
                }
                if (Acceptor.class.isAssignableFrom(initClass)) {
                    Acceptor acceptor = null;
                    try {
                        acceptor = (Acceptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws InstantiationException, IllegalAccessException {
                                return initClass.newInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException exc) {
                        throw ParserTable.this.wrapper.acceptorInstantiationFailure(exc.getException(), (Object)initClass.getName());
                    }
                    catch (Exception exc) {
                        throw ParserTable.this.wrapper.acceptorInstantiationFailure(exc, (Object)initClass.getName());
                    }
                    return acceptor;
                }
                throw ParserTable.this.wrapper.acceptorInstantiationTypeFailure(initClass.getName());
            }
        };
        Operation result = OperationFactory.compose(mop, mkinst);
        return result;
    }

    private Operation makeInitRefOperation() {
        return new Operation(){

            public Object operate(Object value) {
                String[] values = (String[])value;
                if (values.length != 2) {
                    throw ParserTable.this.wrapper.orbInitialreferenceSyntax();
                }
                return values[0] + "=" + values[1];
            }
        };
    }

    public static final class TestAcceptor1
    implements Acceptor {
        public boolean equals(Object other) {
            return other instanceof TestAcceptor1;
        }

        public boolean initialize() {
            return true;
        }

        public boolean initialized() {
            return true;
        }

        public String getConnectionCacheType() {
            return "FOO";
        }

        public void setConnectionCache(InboundConnectionCache connectionCache) {
        }

        public InboundConnectionCache getConnectionCache() {
            return null;
        }

        public boolean shouldRegisterAcceptEvent() {
            return true;
        }

        public void setUseSelectThreadForConnections(boolean x) {
        }

        public boolean shouldUseSelectThreadForConnections() {
            return true;
        }

        public void setUseWorkerThreadForConnections(boolean x) {
        }

        public boolean shouldUseWorkerThreadForConnections() {
            return true;
        }

        public void accept() {
        }

        public void close() {
        }

        public EventHandler getEventHandler() {
            return null;
        }

        public MessageMediator createMessageMediator(Broker xbroker, Connection xconnection) {
            return null;
        }

        public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }

        public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }
    }

    public static final class TestAcceptor2
    implements Acceptor {
        public boolean equals(Object other) {
            return other instanceof TestAcceptor2;
        }

        public boolean initialize() {
            return true;
        }

        public boolean initialized() {
            return true;
        }

        public String getConnectionCacheType() {
            return "FOO";
        }

        public void setConnectionCache(InboundConnectionCache connectionCache) {
        }

        public InboundConnectionCache getConnectionCache() {
            return null;
        }

        public boolean shouldRegisterAcceptEvent() {
            return true;
        }

        public void setUseSelectThreadForConnections(boolean x) {
        }

        public boolean shouldUseSelectThreadForConnections() {
            return true;
        }

        public void setUseWorkerThreadForConnections(boolean x) {
        }

        public boolean shouldUseWorkerThreadForConnections() {
            return true;
        }

        public void accept() {
        }

        public void close() {
        }

        public EventHandler getEventHandler() {
            return null;
        }

        public MessageMediator createMessageMediator(Broker xbroker, Connection xconnection) {
            return null;
        }

        public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }

        public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }
    }

    public final class TestBadServerIdHandler
    implements BadServerIdHandler {
        public boolean equals(Object other) {
            return other instanceof TestBadServerIdHandler;
        }

        public void handle(ObjectKey objectKey) {
        }
    }

    public static final class TestContactInfoListFactory
    implements CorbaContactInfoListFactory {
        public boolean equals(Object other) {
            return other instanceof TestContactInfoListFactory;
        }

        public void setORB(ORB orb) {
        }

        public CorbaContactInfoList create(IOR ior) {
            return null;
        }
    }

    public static final class TestIIOPPrimaryToContactInfo
    implements IIOPPrimaryToContactInfo {
        public void reset(ContactInfo primary) {
        }

        public boolean hasNext(ContactInfo primary, ContactInfo previous, List contactInfos) {
            return true;
        }

        public ContactInfo next(ContactInfo primary, ContactInfo previous, List contactInfos) {
            return null;
        }
    }

    public static final class TestIORToSocketInfo
    implements IORToSocketInfo {
        public boolean equals(Object other) {
            return other instanceof TestIORToSocketInfo;
        }

        public List getSocketInfo(IOR ior, List previous) {
            return null;
        }
    }

    public static final class TestLegacyORBSocketFactory
    implements com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory {
        public boolean equals(Object other) {
            return other instanceof TestLegacyORBSocketFactory;
        }

        public ServerSocket createServerSocket(String type, int port) {
            return null;
        }

        public SocketInfo getEndPointInfo(org.omg.CORBA.ORB orb, IOR ior, SocketInfo socketInfo) {
            return null;
        }

        public Socket createSocket(SocketInfo socketInfo) {
            return null;
        }
    }

    public static final class TestORBInitializer1
    extends LocalObject
    implements ORBInitializer {
        public boolean equals(Object other) {
            return other instanceof TestORBInitializer1;
        }

        public void pre_init(ORBInitInfo info) {
        }

        public void post_init(ORBInitInfo info) {
        }
    }

    public static final class TestORBInitializer2
    extends LocalObject
    implements ORBInitializer {
        public boolean equals(Object other) {
            return other instanceof TestORBInitializer2;
        }

        public void pre_init(ORBInitInfo info) {
        }

        public void post_init(ORBInitInfo info) {
        }
    }

    public static final class TestORBSocketFactory
    implements ORBSocketFactory {
        public boolean equals(Object other) {
            return other instanceof TestORBSocketFactory;
        }

        public void setORB(ORB orb) {
        }

        public ServerSocket createServerSocket(String type, InetSocketAddress a) {
            return null;
        }

        public Socket createSocket(String type, InetSocketAddress a) {
            return null;
        }

        public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) {
        }
    }
}

