/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.transport;

import com.sun.corba.ee.spi.orbutil.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.orbutil.transport.Connection;
import com.sun.corba.ee.spi.orbutil.transport.ConnectionCache;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionCacheBase<C extends Connection>
implements ConnectionCache<C> {
    private final String cacheType;
    protected final Logger logger;
    private final int highWaterMark;
    private final int numberToReclaim;
    protected ConcurrentQueue<C> reclaimableConnections = null;

    protected boolean debug() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public final String getCacheType() {
        return this.cacheType;
    }

    @Override
    public final int numberToReclaim() {
        return this.numberToReclaim;
    }

    @Override
    public final int highWaterMark() {
        return this.highWaterMark;
    }

    protected abstract String thisClassName();

    ConnectionCacheBase(String cacheType, int highWaterMark, int numberToReclaim, Logger logger) {
        if (cacheType == null) {
            throw new IllegalArgumentException("cacheType must not be null");
        }
        if (highWaterMark < 0) {
            throw new IllegalArgumentException("highWaterMark must be non-negative");
        }
        if (numberToReclaim < 1) {
            throw new IllegalArgumentException("numberToReclaim must be at least 1");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger must not be null");
        }
        this.cacheType = cacheType;
        this.logger = logger;
        this.highWaterMark = highWaterMark;
        this.numberToReclaim = numberToReclaim;
    }

    protected final void dprint(String msg) {
        this.logger.finer(this.thisClassName() + msg);
    }

    public String toString() {
        return this.thisClassName() + "[" + this.getCacheType() + "]";
    }

    public void dprintStatistics() {
        this.dprint(".stats: idle=" + this.numberOfIdleConnections() + " reclaimable=" + this.numberOfReclaimableConnections() + " busy=" + this.numberOfBusyConnections() + " total=" + this.numberOfConnections() + " (" + this.highWaterMark() + "/" + this.numberToReclaim() + ")");
    }

    protected boolean reclaim() {
        Connection candidate;
        int ctr;
        if (this.debug()) {
            this.dprint(".reclaim: starting");
        }
        for (ctr = 0; ctr < this.numberToReclaim() && (candidate = (Connection)this.reclaimableConnections.poll()) != null; ++ctr) {
            if (this.debug()) {
                this.dprint(".reclaim: closing connection " + candidate);
            }
            try {
                this.close(candidate);
                continue;
            }
            catch (RuntimeException exc) {
                if (this.debug()) {
                    this.dprint(".reclaim: caught exception on close: " + exc);
                }
                throw exc;
            }
        }
        if (this.debug()) {
            this.dprint(".reclaim: reclaimed " + ctr + " connection(s)");
        }
        return ctr > 0;
    }
}

