/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.presentation.rmi.ExceptionHandler;
import com.sun.corba.ee.impl.presentation.rmi.ExceptionHandlerImpl;
import com.sun.corba.ee.spi.presentation.rmi.DynamicMethodMarshaller;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class DynamicMethodMarshallerImpl
implements DynamicMethodMarshaller {
    private Method method;
    private ExceptionHandler ehandler;
    private boolean hasArguments = true;
    private boolean hasVoidResult = true;
    private boolean needsArgumentCopy;
    private boolean needsResultCopy;
    private ReaderWriter[] argRWs = null;
    private ReaderWriter resultRW = null;
    private static final ORBUtilSystemException wrapper = com.sun.corba.ee.spi.orb.ORB.getStaticLogWrapperTable().get_RPC_PRESENTATION_ORBUtil();
    private static ReaderWriter booleanRW = new ReaderWriterBase("boolean"){

        public java.lang.Object read(InputStream is) {
            boolean value = is.read_boolean();
            return new Boolean(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Boolean val = (Boolean)value;
            os.write_boolean(val.booleanValue());
        }
    };
    private static ReaderWriter byteRW = new ReaderWriterBase("byte"){

        public java.lang.Object read(InputStream is) {
            byte value = is.read_octet();
            return new Byte(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Byte val = (Byte)value;
            os.write_octet(val.byteValue());
        }
    };
    private static ReaderWriter charRW = new ReaderWriterBase("char"){

        public java.lang.Object read(InputStream is) {
            char value = is.read_wchar();
            return new Character(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Character val = (Character)value;
            os.write_wchar(val.charValue());
        }
    };
    private static ReaderWriter shortRW = new ReaderWriterBase("short"){

        public java.lang.Object read(InputStream is) {
            short value = is.read_short();
            return new Short(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Short val = (Short)value;
            os.write_short(val.shortValue());
        }
    };
    private static ReaderWriter intRW = new ReaderWriterBase("int"){

        public java.lang.Object read(InputStream is) {
            int value = is.read_long();
            return new Integer(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Integer val = (Integer)value;
            os.write_long(val.intValue());
        }
    };
    private static ReaderWriter longRW = new ReaderWriterBase("long"){

        public java.lang.Object read(InputStream is) {
            long value = is.read_longlong();
            return new Long(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Long val = (Long)value;
            os.write_longlong(val.longValue());
        }
    };
    private static ReaderWriter floatRW = new ReaderWriterBase("float"){

        public java.lang.Object read(InputStream is) {
            float value = is.read_float();
            return new Float(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Float val = (Float)value;
            os.write_float(val.floatValue());
        }
    };
    private static ReaderWriter doubleRW = new ReaderWriterBase("double"){

        public java.lang.Object read(InputStream is) {
            double value = is.read_double();
            return new Double(value);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Double val = (Double)value;
            os.write_double(val.doubleValue());
        }
    };
    private static ReaderWriter corbaObjectRW = new ReaderWriterBase("org.omg.CORBA.Object"){

        public java.lang.Object read(InputStream is) {
            return is.read_Object();
        }

        public void write(OutputStream os, java.lang.Object value) {
            os.write_Object((Object)value);
        }
    };
    private static ReaderWriter anyRW = new ReaderWriterBase("any"){

        public java.lang.Object read(InputStream is) {
            return Util.getInstance().readAny((org.omg.CORBA.portable.InputStream)is);
        }

        public void write(OutputStream os, java.lang.Object value) {
            Util.getInstance().writeAny((org.omg.CORBA.portable.OutputStream)os, value);
        }
    };
    private static ReaderWriter abstractInterfaceRW = new ReaderWriterBase("abstract_interface"){

        public java.lang.Object read(InputStream is) {
            return is.read_abstract_interface();
        }

        public void write(OutputStream os, java.lang.Object value) {
            Util.getInstance().writeAbstractObject((org.omg.CORBA.portable.OutputStream)os, value);
        }
    };

    private static boolean isAnyClass(Class cls) {
        return cls.equals(java.lang.Object.class) || cls.equals(Serializable.class) || cls.equals(Externalizable.class);
    }

    private static boolean isAbstractInterface(Class cls) {
        if (IDLEntity.class.isAssignableFrom(cls)) {
            return cls.isInterface();
        }
        return cls.isInterface() && DynamicMethodMarshallerImpl.allMethodsThrowRemoteException(cls);
    }

    private static boolean allMethodsThrowRemoteException(Class cls) {
        Method[] methods = cls.getMethods();
        for (int ctr = 0; ctr < methods.length; ++ctr) {
            Method method = methods[ctr];
            if (method.getDeclaringClass() == java.lang.Object.class || DynamicMethodMarshallerImpl.throwsRemote(method)) continue;
            return false;
        }
        return true;
    }

    private static boolean throwsRemote(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int ctr = 0; ctr < exceptionTypes.length; ++ctr) {
            Class<?> exceptionType = exceptionTypes[ctr];
            if (!RemoteException.class.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static ReaderWriter makeReaderWriter(final Class cls) {
        if (cls.equals(Boolean.TYPE)) {
            return booleanRW;
        }
        if (cls.equals(Byte.TYPE)) {
            return byteRW;
        }
        if (cls.equals(Character.TYPE)) {
            return charRW;
        }
        if (cls.equals(Short.TYPE)) {
            return shortRW;
        }
        if (cls.equals(Integer.TYPE)) {
            return intRW;
        }
        if (cls.equals(Long.TYPE)) {
            return longRW;
        }
        if (cls.equals(Float.TYPE)) {
            return floatRW;
        }
        if (cls.equals(Double.TYPE)) {
            return doubleRW;
        }
        if (Remote.class.isAssignableFrom(cls)) {
            return new ReaderWriterBase("remote(" + cls.getName() + ")"){

                public java.lang.Object read(InputStream is) {
                    return PortableRemoteObject.narrow(is.read_Object(), cls);
                }

                public void write(OutputStream os, java.lang.Object value) {
                    Util.getInstance().writeRemoteObject((org.omg.CORBA.portable.OutputStream)os, value);
                }
            };
        }
        if (cls.equals(Object.class)) {
            return corbaObjectRW;
        }
        if (Object.class.isAssignableFrom(cls)) {
            return new ReaderWriterBase("org.omg.CORBA.Object(" + cls.getName() + ")"){

                public java.lang.Object read(InputStream is) {
                    return is.read_Object(cls);
                }

                public void write(OutputStream os, java.lang.Object value) {
                    os.write_Object((Object)value);
                }
            };
        }
        if (DynamicMethodMarshallerImpl.isAnyClass(cls)) {
            return anyRW;
        }
        if (DynamicMethodMarshallerImpl.isAbstractInterface(cls)) {
            return abstractInterfaceRW;
        }
        return new ReaderWriterBase("value(" + cls.getName() + ")"){

            public java.lang.Object read(InputStream is) {
                return is.read_value(cls);
            }

            public void write(OutputStream os, java.lang.Object value) {
                if (value == null) {
                    os.write_value(null, cls);
                } else if (value instanceof Serializable) {
                    os.write_value((Serializable)value, cls);
                } else {
                    wrapper.objectNotSerializable(value.getClass().getName());
                }
            }
        };
    }

    public DynamicMethodMarshallerImpl(Method method) {
        this.method = method;
        this.ehandler = new ExceptionHandlerImpl(method.getExceptionTypes());
        this.needsArgumentCopy = false;
        Class<?>[] argTypes = method.getParameterTypes();
        boolean bl = this.hasArguments = argTypes.length > 0;
        if (this.hasArguments) {
            this.argRWs = new ReaderWriter[argTypes.length];
            for (int ctr = 0; ctr < argTypes.length; ++ctr) {
                if (!argTypes[ctr].isPrimitive()) {
                    this.needsArgumentCopy = true;
                }
                this.argRWs[ctr] = DynamicMethodMarshallerImpl.makeReaderWriter(argTypes[ctr]);
            }
        }
        Class<?> resultType = method.getReturnType();
        this.needsResultCopy = false;
        this.hasVoidResult = resultType.equals(Void.TYPE);
        if (!this.hasVoidResult) {
            this.needsResultCopy = !resultType.isPrimitive();
            this.resultRW = DynamicMethodMarshallerImpl.makeReaderWriter(resultType);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public java.lang.Object[] copyArguments(java.lang.Object[] args, ORB orb) throws RemoteException {
        if (this.needsArgumentCopy) {
            return Util.getInstance().copyObjects(args, orb);
        }
        return args;
    }

    public java.lang.Object[] readArguments(InputStream is) {
        java.lang.Object[] result = null;
        if (this.hasArguments) {
            result = new java.lang.Object[this.argRWs.length];
            for (int ctr = 0; ctr < this.argRWs.length; ++ctr) {
                result[ctr] = this.argRWs[ctr].read(is);
            }
        }
        return result;
    }

    public void writeArguments(OutputStream os, java.lang.Object[] args) {
        if (this.hasArguments) {
            if (args.length != this.argRWs.length) {
                throw new IllegalArgumentException("Expected " + this.argRWs.length + " arguments, but got " + args.length + " arguments.");
            }
            for (int ctr = 0; ctr < this.argRWs.length; ++ctr) {
                this.argRWs[ctr].write(os, args[ctr]);
            }
        }
    }

    public java.lang.Object copyResult(java.lang.Object result, ORB orb) throws RemoteException {
        if (this.needsResultCopy) {
            return Util.getInstance().copyObject(result, orb);
        }
        return result;
    }

    public java.lang.Object readResult(InputStream is) {
        if (this.hasVoidResult) {
            return null;
        }
        return this.resultRW.read(is);
    }

    public void writeResult(OutputStream os, java.lang.Object result) {
        if (!this.hasVoidResult) {
            this.resultRW.write(os, result);
        }
    }

    public boolean isDeclaredException(Throwable thr) {
        return this.ehandler.isDeclaredException(thr.getClass());
    }

    public void writeException(OutputStream os, Exception ex) {
        this.ehandler.writeException(os, ex);
    }

    public Exception readException(ApplicationException ae) {
        return this.ehandler.readException(ae);
    }

    public static interface ReaderWriter {
        public java.lang.Object read(InputStream var1);

        public void write(OutputStream var1, java.lang.Object var2);
    }

    static abstract class ReaderWriterBase
    implements ReaderWriter {
        String name;

        public ReaderWriterBase(String name) {
            this.name = name;
        }

        public String toString() {
            return "ReaderWriter[" + this.name + "]";
        }
    }
}

