/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.JavaCompiler;
import com.sun.ejb.codegen.JavaCompilerException;
import com.sun.ejb.codegen.ProcessExecutor;
import com.sun.ejb.codegen.ProcessExecutorException;
import com.sun.enterprise.instance.UniqueIdGenerator;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Compiler {
    protected static final String JAVA_EXT_DIRS_SYS_PROP = "java.ext.dirs";
    protected File jdkDir = null;
    protected String installRoot = null;
    protected List options;
    protected List files;
    protected File fileOfFilenames = null;
    protected boolean useFileContainingFilenames = false;
    protected static final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    protected static final StringManager localStrings = StringManager.getManager(JavaCompiler.class);
    protected static final String hostUniqueStr = Integer.toString(new Object().hashCode(), 16) + "_";

    Compiler(List theOptions, List theFiles) throws JavaCompilerException {
        if (theOptions == null || theOptions.size() <= 0) {
            throw new JavaCompilerException("java_compiler.badargs", "JavaCompiler given null or empty {0} list", new Object[]{"options"});
        }
        if (theFiles == null || theFiles.size() <= 0) {
            throw new JavaCompilerException("java_compiler.badargs", "JavaCompiler given null or empty {0} list", new Object[]{"file"});
        }
        this.options = theOptions;
        this.files = theFiles;
        this.init();
    }

    final void compile() throws JavaCompilerException {
        try {
            try {
                this.internal_compile();
            }
            catch (JavaCompilerException jce) {
                throw jce;
            }
            catch (Throwable t) {
                throw new JavaCompilerException(t);
            }
            Object var3_1 = null;
            if (this.fileOfFilenames != null && !this.fileOfFilenames.delete()) {
                this.fileOfFilenames.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (this.fileOfFilenames != null && !this.fileOfFilenames.delete()) {
                this.fileOfFilenames.deleteOnExit();
            }
            throw throwable;
        }
    }

    protected abstract void internal_compile() throws JavaCompilerException, ProcessExecutorException;

    protected abstract void internal_init();

    final void init() {
        this.installRoot = System.getProperty("com.sun.aas.installRoot");
        this.initJDKDir();
        logger.log(Level.FINE, "[Compiler] JDK Directory: " + (this.jdkDir == null ? "null" : this.jdkDir.getPath()));
        String enableJavacFileStr = System.getProperty("com.sun.aas.deployment.javac.file.enable");
        this.useFileContainingFilenames = enableJavacFileStr != null ? Boolean.valueOf(enableJavacFileStr) : OS.isWindows();
        this.internal_init();
    }

    final void initJDKDir() {
        String jreHome = System.getProperty("java.home");
        if (StringUtils.ok(jreHome)) {
            this.jdkDir = OS.isDarwin() ? new File(jreHome) : new File(jreHome).getParentFile();
            if (FileUtils.safeIsDirectory(this.jdkDir)) {
                this.jdkDir = FileUtils.safeGetCanonicalFile(this.jdkDir);
                return;
            }
        }
        this.jdkDir = null;
        String jh = System.getProperty("JAVA_HOME");
        if (StringUtils.ok(jh)) {
            this.jdkDir = new File(jh);
            if (FileUtils.safeIsDirectory(this.jdkDir)) {
                this.jdkDir = FileUtils.safeGetCanonicalFile(this.jdkDir);
                return;
            }
        }
        this.jdkDir = null;
        if (this.installRoot != null) {
            this.jdkDir = new File(this.installRoot + "/jdk");
            if (FileUtils.safeIsDirectory(this.jdkDir)) {
                this.jdkDir = FileUtils.safeGetCanonicalFile(this.jdkDir);
                return;
            }
        }
        this.jdkDir = null;
    }

    protected void runProcess(String[] cmds, long timeout) throws ProcessExecutorException {
        ProcessExecutor exec = new ProcessExecutor(cmds, timeout);
        exec.execute();
    }

    protected void logCompilerName(String compilerName) {
        logger.log(Level.FINE, "[EJBC] Successfully compiled with " + compilerName);
    }

    protected static String getSystemPropertyIgnoreCase(String key) {
        Properties p = System.getProperties();
        Set<Map.Entry<Object, Object>> set = p.entrySet();
        for (Map.Entry<Object, Object> me : set) {
            String propKey = (String)me.getKey();
            if (key.compareToIgnoreCase(propKey) != 0) continue;
            return (String)me.getValue();
        }
        return null;
    }

    protected void addJavaFiles(List list) {
        if (!this.useFileContainingFilenames) {
            list.addAll(this.files);
            return;
        }
        this.writeFileOfFilenames();
        if (this.fileOfFilenames == null) {
            list.addAll(this.files);
            return;
        }
        list.add("@" + FileUtils.safeGetCanonicalPath(this.fileOfFilenames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeFileOfFilenames() {
        block13: {
            this.fileOfFilenames = null;
            BufferedWriter writer = null;
            this.fileOfFilenames = File.createTempFile(hostUniqueStr + Long.toString(UniqueIdGenerator.getInstance().getNextUniqueId(), 16) + "_", ".s1a");
            writer = new BufferedWriter(new FileWriter(this.fileOfFilenames));
            for (String fileSpec : this.files) {
                if (fileSpec.indexOf(32) != -1) {
                    fileSpec = Compiler.prepareFileSpec(fileSpec);
                }
                writer.write(fileSpec);
                writer.newLine();
            }
            Object var5_5 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
                break block13;
            }
            catch (Exception ex) {}
            break block13;
            {
                catch (Exception e) {
                    this.fileOfFilenames = null;
                    Object var5_6 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block13;
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected static int getTimeout(String what, int defValue, int min, int max) {
        int to = defValue;
        String sysValue = System.getProperty(what);
        if (sysValue != null) {
            try {
                to = Integer.parseInt(sysValue);
            }
            catch (Exception e) {
                to = defValue;
            }
        }
        if (to < min || to > max) {
            to = defValue;
        }
        return to;
    }

    protected static String ensureDoubleBackslashes(String original) {
        StringBuffer answer = new StringBuffer();
        int match = -1;
        int placeAfterPreviousSlash = 0;
        while ((match = original.indexOf("\\", placeAfterPreviousSlash)) != -1) {
            boolean slashIsDoubled;
            boolean slashIsAtEnd = match + 1 >= original.length();
            boolean bl = slashIsDoubled = !slashIsAtEnd && original.charAt(match + 1) == '\\';
            if (slashIsAtEnd || !slashIsDoubled) {
                answer.append(original.substring(placeAfterPreviousSlash, match + 1)).append("\\");
            }
            if (slashIsDoubled) {
                placeAfterPreviousSlash = match + 2;
                continue;
            }
            placeAfterPreviousSlash = match + 1;
        }
        answer.append(original.substring(placeAfterPreviousSlash));
        return answer.toString();
    }

    protected static String prepareFileSpec(String fileSpec) {
        String result = "\"" + Compiler.ensureDoubleBackslashes(fileSpec) + "\"";
        return result;
    }
}

