/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.base.container.ContainerServiceImpl;
import com.sun.ejb.base.distributed.AdminEJBTimerEventListenerImpl;
import com.sun.ejb.base.io.IOUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.CommitCEntityContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.PMTransactionManagerImpl;
import com.sun.ejb.containers.ReadOnlyBeanContainer;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.ejb.containers.TimerBeanContainer;
import com.sun.ejb.containers.builder.StatefulContainerBuilder;
import com.sun.ejb.containers.util.LongHashMap;
import com.sun.ejb.containers.util.PoolCacheTimer;
import com.sun.ejb.spi.container.ContainerService;
import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public final class ContainerFactoryImpl
implements ContainerFactory {
    private boolean debugMonitoring = false;
    private long debugMonitoringPeriodMS = 60000L;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static final boolean debug = false;
    public static final byte HOME_KEY = -1;
    public static final byte[] homeInstanceKey = new byte[]{-1};
    private EJBTimerService ejbTimerService;
    private PMTransactionManagerImpl pmtm;
    LongHashMap containers = new LongHashMap(128);
    private ThreadLocal threadLocalContext = new ThreadLocal();
    private static PoolCacheTimer _timer = new PoolCacheTimer();
    private PoolCacheTimer _localTimer;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ContainerFactoryImpl.class);
    private static ContainerService _containerService;

    public ContainerFactoryImpl() {
        this.pmtm = new PMTransactionManagerImpl();
        this._localTimer = _timer;
        this.getDebugMonitoringDetails();
        if (this.debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(), 0L, this.debugMonitoringPeriodMS);
        }
        _containerService = new ContainerServiceImpl();
        _containerService.initializeService();
        IOUtils.setJ2EEObjectStreamFactory(_containerService.getJ2EEObjectStreamFactory());
    }

    public static ContainerService getContainerService() {
        return _containerService;
    }

    public EntityManager lookupExtendedEntityManager(EntityManagerFactory factory) {
        EjbDescriptor ejbDesc;
        Switch theSwitch = Switch.getSwitch();
        InvocationManager invMgr = theSwitch.getInvocationManager();
        ComponentInvocation inv = invMgr.getCurrentInvocation();
        EntityManager em = null;
        if (inv != null && inv.getInvocationType() == 1 && (ejbDesc = (EjbDescriptor)theSwitch.getDescriptorFor(inv.getContainerContext())) instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)ejbDesc).isStateful()) {
            em = ((SessionContextImpl)inv.context).getExtendedEntityManager(factory);
        }
        return em;
    }

    public void initEJBTimerService() throws Exception {
        this.ejbTimerService = null;
    }

    public void setEJBTimerService(EJBTimerService ejbTimerService) {
        this.ejbTimerService = ejbTimerService;
        DistributedEJBServiceFactory.setDistributedEJBTimerService(ejbTimerService);
        if (null != ejbTimerService) {
            AdminEJBTimerEventListenerImpl.getEjbTimerEventListener();
        }
    }

    public void restoreEJBTimers() throws Exception {
        if (this.ejbTimerService != null) {
            this.ejbTimerService.restoreTimers();
        }
    }

    public void shutdownEJBTimerService() {
        if (this.ejbTimerService != null) {
            this.ejbTimerService.shutdown();
        }
    }

    private void getDebugMonitoringDetails() {
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_EJB_CONTAINER");
            if (null != str) {
                str = str.toLowerCase();
                this.debugMonitoring = Boolean.valueOf(str);
                String period = props.getProperty("MONITOR_EJB_TIME_PERIOD_SECONDS");
                if (period != null) {
                    this.debugMonitoringPeriodMS = new Long(period) * 1000L;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "ContainerFactoryImpl.getDebugMonitoringDetails(),  Exception when trying to get the System properties - ", e);
        }
    }

    public static Timer getTimer() {
        return _timer;
    }

    public TransactionManager getTransactionMgr() {
        return this.pmtm;
    }

    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, SecurityManager sm, ConfigContext dynamicConfigContext) throws Exception {
        BaseContainer container = null;
        boolean hasHome = true;
        String commitOption = null;
        String appid = ejbDescriptor.getApplication().getRegistrationName();
        String archiveuri = ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
        String modulename = FileUtils.makeFriendlyFilename(archiveuri);
        String ejbname = ejbDescriptor.getName();
        IASEjbExtraDescriptors iased = null;
        Config cfg = null;
        EjbContainer ejbContainerDesc = null;
        try {
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                EjbSessionDescriptor sd = (EjbSessionDescriptor)ejbDescriptor;
                if (sd.isStateless()) {
                    container = new StatelessSessionContainer(ejbDescriptor, loader);
                } else {
                    StatefulContainerBuilder builder = new StatefulContainerBuilder();
                    builder.buildContainer(ejbDescriptor, loader, dynamicConfigContext);
                    container = builder.getContainer();
                }
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                container = new MessageBeanContainer(ejbDescriptor, loader);
                hasHome = false;
            } else if (((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
                EjbEntityDescriptor robDesc = (EjbEntityDescriptor)ejbDescriptor;
                container = new ReadOnlyBeanContainer(ejbDescriptor, loader);
            } else if (ejbDescriptor.getLocalHomeClassName() != null && ejbDescriptor.getLocalHomeClassName().equals("com.sun.ejb.containers.TimerLocalHome")) {
                container = new TimerBeanContainer(ejbDescriptor, loader);
            } else {
                iased = ((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors();
                if (iased != null) {
                    commitOption = iased.getCommitOption();
                }
                if (commitOption == null) {
                    try {
                        ServerContext sc = ApplicationServer.getServerContext();
                        cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
                    }
                    catch (ConfigException ex) {
                        _logger.log(Level.WARNING, "ejb.createContainer_exception", ex);
                    }
                    ejbContainerDesc = cfg.getEjbContainer();
                    commitOption = ejbContainerDesc.getCommitOption();
                }
                if (commitOption.equals("A")) {
                    _logger.log(Level.WARNING, "ejb.commit_option_A_not_supported", new Object[]{ejbDescriptor.getName()});
                    container = new EntityContainer(ejbDescriptor, loader);
                } else if (commitOption.equals("C")) {
                    _logger.log(Level.FINE, "Using commit option C for: " + ejbDescriptor.getName());
                    container = new CommitCEntityContainer(ejbDescriptor, loader);
                } else {
                    _logger.log(Level.FINE, "Using commit option B for: " + ejbDescriptor.getName());
                    container = new EntityContainer(ejbDescriptor, loader);
                }
            }
            this.containers.put(ejbDescriptor.getUniqueId(), container);
            container.setSecurityManager(sm);
            if (hasHome) {
                container.initializeHome();
            }
            container.setDebugMonitorFlag(this.debugMonitoring);
            return container;
        }
        catch (InvalidNameException ex) {
            _logger.log(Level.SEVERE, "ejb.create_container_exception", ex.toString());
            _logger.log(Level.SEVERE, "Invalid jndiName forappId=" + appid + "; moduleName=" + modulename + "; ejbName=" + ejbname);
            _logger.log(Level.SEVERE, "jndiName=" + ejbDescriptor.getJndiName());
            try {
                this.removeContainer(ejbDescriptor.getUniqueId());
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "", e);
            }
            throw ex;
        }
        catch (UnsupportedOperationException unSupEx) {
            throw unSupEx;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "ejb.create_container_exception", ex.toString());
            _logger.log(Level.SEVERE, "appId=" + appid + " moduleName=" + modulename + " ejbName=" + ejbname);
            try {
                this.removeContainer(ejbDescriptor.getUniqueId());
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "", e);
            }
            throw ex;
        }
    }

    public Container getContainer(long ejbId) {
        return (Container)this.containers.get(ejbId);
    }

    public void removeContainer(long ejbId) {
        this.containers.remove(ejbId);
    }

    public Enumeration listContainers() {
        return this.containers.elements();
    }

    public EjbDescriptor getEjbDescriptor(long ejbId) {
        Container c = (Container)this.containers.get(ejbId);
        if (c == null) {
            return null;
        }
        return c.getEjbDescriptor();
    }

    public Object getEJBContextObject(String contextType) {
        InvocationManager invMgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation currentInv = invMgr.getCurrentInvocation();
        if (currentInv == null) {
            throw new IllegalStateException("no current invocation");
        }
        if (currentInv.getInvocationType() != 1) {
            throw new IllegalStateException("Illegal invocation type for EJB Context : " + currentInv.getInvocationType());
        }
        Object returnObject = currentInv.context;
        if (contextType.equals("javax.ejb.TimerService")) {
            if (this.ejbTimerService == null) {
                throw new IllegalStateException("EJB Timer Service not available");
            }
            returnObject = new EJBTimerServiceWrapper(this.ejbTimerService, (EJBContextImpl)currentInv.context);
        }
        return returnObject;
    }

    EJBTimerService getEJBTimerService() {
        return this.ejbTimerService;
    }

    ContainerSynchronization getContainerSync(Transaction tx) throws RollbackException, SystemException {
        TxData txData = (TxData)((J2EETransaction)tx).getContainerData();
        if (txData == null) {
            txData = new TxData();
            ((J2EETransaction)tx).setContainerData(txData);
        }
        if (txData.sync == null) {
            txData.sync = new ContainerSynchronization(tx, this);
            tx.registerSynchronization(txData.sync);
        }
        return txData.sync;
    }

    void removeContainerSync(Transaction tx) {
    }

    Vector getBeans(Transaction tx) {
        TxData txData = (TxData)((J2EETransaction)tx).getContainerData();
        if (txData == null) {
            txData = new TxData();
            ((J2EETransaction)tx).setContainerData(txData);
        }
        if (txData.beans == null) {
            txData.beans = new Vector();
        }
        return txData.beans;
    }

    class DebugMonitor
    extends TimerTask {
        DebugMonitor() {
        }

        public void run() {
            try {
                Enumeration enumContainers = ContainerFactoryImpl.this.listContainers();
                if (null == enumContainers) {
                    _logger.log(Level.INFO, "MONITORING:: No containers available to report monitoring stats");
                    return;
                }
                while (enumContainers.hasMoreElements()) {
                    BaseContainer container = (BaseContainer)enumContainers.nextElement();
                    container.logMonitoredComponentsData();
                }
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "Exception thrown", th);
            }
        }
    }

    private static class TxData {
        ContainerSynchronization sync;
        Vector beans;

        private TxData() {
        }
    }
}

