/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBTimerTask;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerLocal;
import com.sun.ejb.containers.TimerLocalHome;
import com.sun.ejb.containers.TimerMigrationLocal;
import com.sun.ejb.containers.TimerMigrationLocalHome;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.spi.distributed.DistributedEJBTimerService;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.threadpool.Servicable;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

public class EJBTimerService
implements DistributedEJBTimerService {
    private long nextTimerIdMillis_ = 0L;
    private long nextTimerIdCounter_ = 0L;
    private String serverName_;
    private String domainName_;
    private static final String TIMER_ID_SEP = "@@";
    private String ownerIdOfThisServer_;
    private TimerCache timerCache_;
    private TimerLocalHome timerLocalHome_;
    private TimerMigrationLocalHome timerMigrationLocalHome_;
    private boolean shutdown_;
    private long totalTimedObjectsInitialized_ = 0L;
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static final long MINIMUM_DELIVERY_INTERVAL = 7000L;
    private static final int MAX_REDELIVERIES = 1;
    private static final long REDELIVERY_INTERVAL = 5000L;
    private String appID;
    private long minimumDeliveryInterval_ = 7000L;
    private long maxRedeliveries_ = 1L;
    private long redeliveryInterval_ = 5000L;
    private static final String TIMER_SERVICE_FILE = "__timer_service_shutdown__.dat";
    private static final String TIMER_SERVICE_DOWNTIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private boolean performDBReadBeforeTimeout = false;
    private static final String strDBReadBeforeTimeout = "com.sun.ejb.timer.ReadDBBeforeTimeout";
    private boolean foundSysPropDBReadBeforeTimeout = false;

    public EJBTimerService(String appID, TimerLocalHome timerLocalHome, TimerMigrationLocalHome timerMigrationLocalHome) {
        this.timerLocalHome_ = timerLocalHome;
        this.timerMigrationLocalHome_ = timerMigrationLocalHome;
        this.timerCache_ = new TimerCache();
        this.shutdown_ = false;
        this.appID = appID;
        this.domainName_ = ServerManager.instance().getDomainName();
        InstanceEnvironment server = ApplicationServer.getServerContext().getInstanceEnvironment();
        this.serverName_ = server.getName();
        this.initProperties();
    }

    private void initProperties() {
        try {
            String serverName;
            ServerContext sc = ApplicationServer.getServerContext();
            EjbContainer ejbc = ServerBeansFactory.getConfigBean(sc.getConfigContext()).getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            if (ejbt != null) {
                long val;
                String valString = ejbt.getMinimumDeliveryIntervalInMillis();
                long l = val = valString != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.minimumDeliveryInterval_ = val;
                }
                long l2 = val = (valString = ejbt.getMaxRedeliveries()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.maxRedeliveries_ = val;
                }
                long l3 = val = (valString = ejbt.getRedeliveryIntervalInternalInMillis()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.redeliveryInterval_ = val;
                }
                this.foundSysPropDBReadBeforeTimeout = this.getDBReadBeforeTimeoutProperty();
                this.setPerformDBReadBeforeTimeout(false);
            }
            InstanceEnvironment server = sc.getInstanceEnvironment();
            this.ownerIdOfThisServer_ = serverName = server.getName();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
        logger.log(Level.FINE, "EJB Timer Service properties : min delivery interval = " + this.minimumDeliveryInterval_ + "\nmax redeliveries = " + this.maxRedeliveries_ + "\nredelivery interval = " + this.redeliveryInterval_);
    }

    synchronized void timedObjectCount() {
        ++this.totalTimedObjectsInitialized_;
    }

    String getOwnerIdOfThisServer() {
        return this.ownerIdOfThisServer_;
    }

    private EJBException createEJBException(Exception ex) {
        EJBException ejbEx = new EJBException();
        ejbEx.initCause(ex);
        return ejbEx;
    }

    public String[] listTimers(String[] serverIds) {
        String[] totalTimers = new String[serverIds.length];
        try {
            for (int i = 0; i < serverIds.length; ++i) {
                totalTimers[i] = new String(new Integer(this.timerLocalHome_.selectCountAllTimersOwnedBy(serverIds[i])).toString());
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception in listTimers() : ", ex);
            EJBException ejbEx = this.createEJBException(ex);
            throw ejbEx;
        }
        return totalTimers;
    }

    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from an active server instance " + ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from  an active server instance " + ownerIdOfThisServer);
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner " + fromOwnerId + " to " + ownerIdOfThisServer);
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        Set toRestore = new HashSet();
        try {
            tm.begin();
            Set toMigrate = this.timerMigrationLocalHome_.selectAllTimersOwnedBy(fromOwnerId);
            toRestore = this.timerLocalHome_.selectAllTimersOwnedBy(fromOwnerId);
            for (TimerMigrationLocal next : toMigrate) {
                next.setOwnerId(ownerIdOfThisServer);
            }
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "timer migration error", e);
            try {
                tm.rollback();
            }
            catch (Exception re) {
                logger.log(Level.FINE, "timer migration rollback error", re);
            }
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        int totalTimersMigrated = toRestore.size();
        if (toRestore.size() > 0) {
            boolean success = false;
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of " + toRestore.size() + " timers.  Now reactivating timers...");
                tm.begin();
                this._restoreTimers(toRestore);
                success = true;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "timer restoration error", e);
                EJBException ejbEx = this.createEJBException(e);
                throw ejbEx;
            }
            finally {
                block16: {
                    try {
                        tm.commit();
                    }
                    catch (Exception re) {
                        logger.log(Level.FINE, "timer migration error", re);
                        if (!success) break block16;
                        EJBException ejbEx = this.createEJBException(re);
                        throw ejbEx;
                    }
                }
            }
        }
        logger.log(Level.INFO, fromOwnerId + " has 0 timers in need " + "of migration");
        return totalTimersMigrated;
    }

    public void setPerformDBReadBeforeTimeout(boolean defaultDBReadValue) {
        if (!this.foundSysPropDBReadBeforeTimeout) {
            this.performDBReadBeforeTimeout = defaultDBReadValue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
            }
        }
    }

    private boolean getDBReadBeforeTimeoutProperty() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty(strDBReadBeforeTimeout);
            if (null != str) {
                str = str.toLowerCase();
                this.performDBReadBeforeTimeout = Boolean.valueOf(str);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
                }
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "ContainerFactoryImpl.getDebugMonitoringDetails(),  Exception when trying to get the System properties - ", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        Set allActiveTimers = new HashSet();
        try {
            tm.begin();
            allActiveTimers = this.timerLocalHome_.selectAllActiveTimersOwnedByThisServer();
            this._restoreTimers(allActiveTimers);
        }
        catch (Exception e) {
            ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
            cf.setEJBTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            return;
        }
        finally {
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            }
        }
    }

    private void _restoreTimers(Set timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        for (TimerLocal timerLocal : timersEligibleForRestoration) {
            long containerId = timerLocal.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                TimerPrimaryKey timerId = (TimerPrimaryKey)timerLocal.getPrimaryKey();
                Date initialExpiration = timerLocal.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container instanceof EntityContainer) {
                    timedObjectPrimaryKey = timerLocal.getTimedObjectPrimaryKey();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, timerLocal.getIntervalDuration(), container, timedObjectPrimaryKey);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = timerLocal.getLastExpiration();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ". Timer expirations should " + " have been delivered starting at " + initialExpiration);
                    } else if (lastExpiration != null && now.getTime() - lastExpiration.getTime() > timerLocal.getIntervalDuration()) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ".  Last timer expiration " + "occurred at " + lastExpiration);
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + timerState + ". Timer expiration should " + " have been delivered at " + initialExpiration);
                }
                timersToRestore.put(timerState, expirationTime);
                continue;
            }
            try {
                timerLocal.remove();
            }
            catch (RemoveException e) {
                logger.log(Level.FINE, "Removing timer " + timerLocal.getPrimaryKey() + " for unknown container " + containerId, e);
            }
        }
        for (Map.Entry entry : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)entry.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)entry.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
    }

    void shutdown() {
        this.shutdown_ = true;
    }

    void cancelEntityBeanTimers(long containerId, Object primaryKey) {
        try {
            Collection timers = this.getTimers(containerId, primaryKey);
            if (logger.isLoggable(Level.FINE) && timers.isEmpty()) {
                logger.log(Level.FINE, "0 cancelEntityBeanTimers for " + containerId + ", " + primaryKey);
            }
            for (TimerLocal next : timers) {
                try {
                    this.cancelTimer(next);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ejb.cancel_entity_timer", new Object[]{next.getPrimaryKey()});
                    logger.log(Level.WARNING, "", e);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.cancel_entity_timers", new Object[]{new Long(containerId), primaryKey});
            logger.log(Level.WARNING, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void destroyTimers(long containerId) {
        block21: {
            Set timers = null;
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            tm.begin();
            timers = this.timerLocalHome_.selectTimersByContainer(containerId);
            for (TimerLocal next : timers) {
                TimerPrimaryKey nextTimerId = null;
                RuntimeTimerState nextTimerState = null;
                try {
                    nextTimerId = (TimerPrimaryKey)next.getPrimaryKey();
                    nextTimerState = this.getTimerState(nextTimerId);
                    if (nextTimerState != null) {
                        RuntimeTimerState runtimeTimerState = nextTimerState;
                        synchronized (runtimeTimerState) {
                            if (nextTimerState.isScheduled()) {
                                EJBTimerTask timerTask = nextTimerState.getCurrentTimerTask();
                                timerTask.cancel();
                            }
                        }
                    }
                    next.remove();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ejb.destroy_timer_error", new Object[]{nextTimerId});
                    logger.log(Level.WARNING, "", e);
                }
                finally {
                    if (nextTimerState == null) continue;
                    this.timerCache_.removeTimer(nextTimerId);
                }
            }
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "destroy_timers_error", new Object[]{new Long(containerId)});
                logger.log(Level.WARNING, "", e);
            }
            break block21;
            catch (Exception ex) {
                try {
                    logger.log(Level.WARNING, "destroy_timers_error", new Object[]{new Long(containerId)});
                    logger.log(Level.WARNING, "", ex);
                }
                catch (Throwable throwable) {
                    try {
                        tm.commit();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "destroy_timers_error", new Object[]{new Long(containerId)});
                        logger.log(Level.WARNING, "", e);
                    }
                    throw throwable;
                }
                try {
                    tm.commit();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "destroy_timers_error", new Object[]{new Long(containerId)});
                    logger.log(Level.WARNING, "", e);
                }
                return;
            }
        }
    }

    void rescheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, true);
    }

    void scheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(TimerPrimaryKey timerId, Date expiration, boolean rescheduled) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                Date cutoff;
                Date timerExpiration = expiration;
                if (!rescheduled && expiration.before(cutoff = new Date(new Date().getTime() + this.getMinimumDeliveryInterval()))) {
                    timerExpiration = cutoff;
                }
                EJBTimerTask timerTask = new EJBTimerTask(timerExpiration, timerId, this);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, (rescheduled ? "RE-" : "") + "Scheduling " + timerState + " for timeout at " + timerExpiration);
                }
                if (rescheduled) {
                    timerState.rescheduled(timerTask);
                } else {
                    timerState.scheduled(timerTask);
                }
                Timer jdkTimer = Switch.getSwitch().getTimer();
                jdkTimer.schedule((TimerTask)timerTask, timerExpiration);
            }
        } else {
            logger.log(Level.FINE, "No timer state found for " + (rescheduled ? "RE-schedule" : "schedule") + " request of " + timerId + " for timeout at " + expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date cancelTask(TimerPrimaryKey timerId) {
        Date timeout = null;
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isCreated()) {
                    timeout = timerState.getInitialExpiration();
                } else if (timerState.isScheduled()) {
                    EJBTimerTask timerTask = timerState.getCurrentTimerTask();
                    timeout = timerTask.getTimeout();
                    timerTask.cancel();
                }
                timerState.cancelled();
            }
        } else {
            logger.log(Level.FINE, "No timer state found for cancelTask request of " + timerId);
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTaskToDelivered(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                timerState.restoredToDelivered();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Restoring " + timerId + " to delivered state after it was cancelled and " + " rolled back from within its own ejbTimeout method");
            }
        } else {
            logger.log(Level.FINE, "No timer state found for restoreTaskToDelivered request of " + timerId);
        }
    }

    void expungeTimer(TimerPrimaryKey timerId) {
        this.expungeTimer(timerId, false);
    }

    private Date calcInitialFixedRateExpiration(long timerServiceWentDownAt, RuntimeTimerState timerState) {
        long now2initialDiff;
        long count;
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException();
        }
        Date now = new Date();
        long nowMillis = now.getTime();
        long initialExpiration = timerState.getInitialExpiration().getTime();
        long previousExpiration = initialExpiration + (count = (now2initialDiff = nowMillis - initialExpiration) / timerState.getIntervalDuration()) * timerState.getIntervalDuration();
        if (previousExpiration >= timerServiceWentDownAt && previousExpiration <= nowMillis) {
            logger.log(Level.INFO, "ejb.deliver_missed_timer", new Object[]{timerState.getTimerId(), new Date(previousExpiration)});
            return now;
        }
        return this.calcNextFixedRateExpiration(timerState);
    }

    private Date calcNextFixedRateExpiration(RuntimeTimerState timerState) {
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException("Timer " + timerState + " is " + "not a periodic timer");
        }
        Date initialExpiration = timerState.getInitialExpiration();
        long intervalDuration = timerState.getIntervalDuration();
        return this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
    }

    private Date calcNextFixedRateExpiration(Date initialExpiration, long intervalDuration) {
        Date now = new Date();
        long nowMillis = now.getTime();
        Date nextExpirationTime = initialExpiration;
        if (now.after(initialExpiration)) {
            long timeSinceInitialExpire = nowMillis - initialExpiration.getTime();
            long numIntervals = timeSinceInitialExpire / intervalDuration;
            nextExpirationTime = new Date(initialExpiration.getTime() + (numIntervals + 1L) * intervalDuration);
        }
        return nextExpirationTime;
    }

    private void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        if (removeTimerBean) {
            this.removeTimerBean(timerId);
        }
        this.timerCache_.removeTimer(timerId);
    }

    TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, long initialDuration, long intervalDuration, Serializable info) throws CreateException {
        Date now = new Date();
        Date initialExpiration = new Date(now.getTime() + initialDuration);
        return this.createTimer(containerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        RuntimeTimerState timerState;
        BaseContainer container = this.getContainer(containerId);
        if (container == null) {
            throw new CreateException("invalid container id " + containerId + " in createTimer request");
        }
        Class ejbClass = container.getEJBClass();
        if (!container.isTimedObject()) {
            throw new CreateException("Attempt to create an EJB Timer from a bean that is not a Timed Object.  EJB class " + ejbClass + " must implement javax.ejb.TimedObject or " + " annotation a timeout method with @Timeout");
        }
        TimerPrimaryKey timerId = new TimerPrimaryKey(this.getNextTimerId());
        RuntimeTimerState runtimeTimerState = timerState = new RuntimeTimerState(timerId, initialExpiration, intervalDuration, container, timedObjectPrimaryKey);
        synchronized (runtimeTimerState) {
            this.timerCache_.addTimer(timerId, timerState);
            try {
                this.timerLocalHome_.create(timerId.getTimerId(), containerId, this.ownerIdOfThisServer_, timedObjectPrimaryKey, initialExpiration, intervalDuration, info);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{new Long(containerId), timedObjectPrimaryKey, info});
                logger.log(Level.SEVERE, "", e);
                this.timerCache_.removeTimer(timerId);
                if (e instanceof CreateException) {
                    throw (CreateException)e;
                }
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(e);
                throw ejbEx;
            }
        }
        return timerId;
    }

    private Collection getTimers(long containerId, Object timedObjectPrimaryKey) throws FinderException {
        HashSet<TimerLocal> activeTimers;
        HashSet<TimerLocal> timersForTimedObject = activeTimers = this.timerLocalHome_.selectActiveTimersByContainer(containerId);
        if (timedObjectPrimaryKey != null) {
            timersForTimedObject = new HashSet<TimerLocal>();
            for (TimerLocal next : activeTimers) {
                Object nextTimedObjectPrimaryKey = next.getTimedObjectPrimaryKey();
                if (!nextTimedObjectPrimaryKey.equals(timedObjectPrimaryKey)) continue;
                timersForTimedObject.add(next);
            }
        }
        return timersForTimedObject;
    }

    Collection getTimerIds(long containerId, Object timedObjectPrimaryKey) throws FinderException {
        Set<Object> timerIdsForTimedObject = new HashSet();
        if (timedObjectPrimaryKey == null) {
            timerIdsForTimedObject = this.timerLocalHome_.selectActiveTimerIdsByContainer(containerId);
        } else {
            Collection timersForTimedObject = this.getTimers(containerId, timedObjectPrimaryKey);
            timerIdsForTimedObject = new HashSet();
            for (TimerLocal next : timersForTimedObject) {
                timerIdsForTimedObject.add(next.getPrimaryKey());
            }
        }
        return timerIdsForTimedObject;
    }

    ClassLoader getTimerClassLoader(long containerId) {
        BaseContainer container = this.getContainer(containerId);
        return container != null ? container.getClassLoader() : null;
    }

    TimerLocalHome getTimerBeanHome() {
        return this.timerLocalHome_;
    }

    private RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getTimerState(timerId);
    }

    private TimerLocal findTimer(TimerPrimaryKey timerId) throws FinderException {
        return this.timerLocalHome_.findByPrimaryKey(timerId);
    }

    void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        TimerLocal timerBean = this.findTimer(timerId);
        this.cancelTimer(timerBean);
    }

    private void cancelTimer(TimerLocal timerBean) throws Exception {
        if (!timerBean.isCancelled()) {
            timerBean.cancel();
            timerBean.remove();
        }
    }

    Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        TimerLocal timerBean = this.findTimer(timerId);
        if (timerBean.isCancelled()) {
            throw new FinderException("timer " + timerId + " does not exist");
        }
        Date initialExpiration = timerBean.getInitialExpiration();
        Date nextTimeout = timerBean.repeats() ? this.calcNextFixedRateExpiration(initialExpiration, timerBean.getIntervalDuration()) : initialExpiration;
        return nextTimeout;
    }

    Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        TimerLocal timerBean = this.findTimer(timerId);
        if (timerBean.isCancelled()) {
            throw new FinderException("timer " + timerId + " does not exist");
        }
        return timerBean.getInfo();
    }

    boolean timerExists(TimerPrimaryKey timerId) {
        boolean exists = false;
        try {
            TimerLocal timerBean = this.findTimer(timerId);
            exists = timerBean.isActive();
        }
        catch (FinderException fe) {
            exists = false;
        }
        return exists;
    }

    private void removeTimerBean(TimerPrimaryKey timerId) {
        try {
            TimerLocal timerBean = this.findTimer(timerId);
            timerBean.remove();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "ejb.remove_timer_failure", new Object[]{timerId});
            logger.log(Level.WARNING, "", t);
        }
    }

    private BaseContainer getContainer(long containerId) {
        ContainerFactory cf = Switch.getSwitch().getContainerFactory();
        return (BaseContainer)cf.getContainer(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTimeout(TimerPrimaryKey timerId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService.deliverTimeout(): work thread is processing work for timerId = " + timerId);
        }
        if (this.shutdown_) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown.  Expiration " + " will occur when server is restarted.");
            }
            return;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState == null) {
            logger.log(Level.FINE, "Timer state is NULL for timer " + timerId + " in deliverTimeout");
            return;
        }
        BaseContainer container = this.getContainer(timerState.getContainerId());
        RuntimeTimerState runtimeTimerState = timerState;
        synchronized (runtimeTimerState) {
            if (container == null) {
                logger.log(Level.FINE, "Unknown container for timer " + timerId + " in deliverTimeout.  Expunging timer.");
                this.expungeTimer(timerId, true);
                return;
            }
            if (!timerState.isBeingDelivered()) {
                logger.log(Level.FINE, "Timer state = " + timerState.stateToString() + "for timer " + timerId + " before callEJBTimeout");
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Calling ejbTimeout for timer " + timerState);
            }
        }
        try {
            Switch.getSwitch().getCallFlowAgent().requestStart(RequestType.TIMER_EJB);
            container.onEnteringContainer();
            if (this.performDBReadBeforeTimeout) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "For Timer :" + timerId + ": check the database to ensure that the timer is still " + " valid, before delivering the ejbTimeout call");
                }
                if (!this.checkForTimerValidity(timerId)) {
                    return;
                }
            }
            boolean redeliver = container.callEJBTimeout(timerState, this);
            if (this.shutdown_) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown. Expiration will " + " occur on server restart");
                }
                return;
            }
            timerState = this.getTimerState(timerId);
            if (timerState == null) {
                logger.log(Level.FINE, "Timer no longer exists for " + timerId + " after callEJBTimeout");
                return;
            }
            RuntimeTimerState runtimeTimerState2 = timerState;
            synchronized (runtimeTimerState2) {
                Date now = new Date();
                if (!timerState.isCancelled()) {
                    if (redeliver) {
                        if ((long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries()) {
                            Date redeliveryTimeout = new Date(now.getTime() + this.getRedeliveryInterval());
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Redelivering " + timerState);
                            }
                            this.rescheduleTask(timerId, redeliveryTimeout);
                        } else {
                            int numDeliv = timerState.getNumFailedDeliveries() + 1;
                            logger.log(Level.INFO, "ejb.timer_exceeded_max_deliveries", new Object[]{timerState.toString(), new Integer(numDeliv)});
                            this.expungeTimer(timerId, true);
                        }
                    } else if (timerState.isPeriodic()) {
                        Date expiration = this.calcNextFixedRateExpiration(timerState);
                        this.scheduleTask(timerId, expiration);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "callEJBTimeout threw exception for timer id " + timerId, e);
            this.expungeTimer(timerId, true);
        }
        finally {
            container.onLeavingContainer();
            Switch.getSwitch().getCallFlowAgent().requestEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean postEjbTimeout(TimerPrimaryKey timerId) {
        boolean success = true;
        if (this.shutdown_) {
            return success;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            BaseContainer container = this.getContainer(timerState.getContainerId());
            container.incrementDeliveredTimedObject();
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (!timerState.isCancelled()) {
                    try {
                        TimerLocal timerBean = this.getValidTimerFromDB(timerId);
                        if (null == timerBean) {
                            return false;
                        }
                        if (timerState.isPeriodic()) {
                            Date now = new Date();
                            timerBean.setLastExpiration(now);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Setting last expiration  for periodic timer " + timerState + " to " + now);
                            }
                        } else {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Single-action timer " + timerState + " was successfully delivered. " + " Removing...");
                            }
                            this.cancelTimer(timerBean);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Error in post-ejbTimeout timer processing for " + timerState, e);
                        success = false;
                    }
                }
            }
        }
        return success;
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerLocal timerBean = this.getValidTimerFromDB(timerId);
        if (null == timerBean) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerLocal getValidTimerFromDB(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerLocal timerBean = null;
        try {
            timerBean = this.findTimer(timerId);
            if (!timerBean.getOwnerId().equals(this.ownerIdOfThisServer_)) {
                logger.log(Level.WARNING, "The timer (" + timerId + ") is not owned by " + "server (" + this.ownerIdOfThisServer_ + ") that " + "initiated the ejbTimeout. This timer is now " + "owned by (" + timerBean.getOwnerId() + "). \n" + "Hence delete the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                result = false;
            }
        }
        catch (FinderException fex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Timer :" + timerId + ": has been cancelled by another server instance. " + "Expunging the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
            }
            result = false;
        }
        finally {
            if (!result) {
                this.expungeTimer(timerId, false);
                timerBean = null;
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Timer :" + timerId + ": is a valid timer for the server (" + this.ownerIdOfThisServer_ + ")");
            }
        }
        return timerBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskExpired(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isScheduled()) {
                    timerState.delivered();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Adding work pool task for timer " + timerId);
                    }
                    TaskExpiredWork work = new TaskExpiredWork(this, timerId);
                    ContainerWorkPool.addLast(work);
                } else {
                    logger.log(Level.FINE, "Timer " + timerId + " is not in scheduled state.  Current state = " + timerState.stateToString());
                }
            }
        } else {
            logger.log(Level.FINE, "null timer state for timer id " + timerId);
        }
    }

    private synchronized String getNextTimerId() {
        if (this.nextTimerIdCounter_ <= 0L) {
            this.nextTimerIdMillis_ = System.currentTimeMillis();
            this.nextTimerIdCounter_ = 1L;
        } else {
            ++this.nextTimerIdCounter_;
        }
        return new String(this.nextTimerIdCounter_ + TIMER_ID_SEP + this.nextTimerIdMillis_ + TIMER_ID_SEP + this.serverName_ + TIMER_ID_SEP + this.domainName_);
    }

    private long getMinimumDeliveryInterval() {
        return this.minimumDeliveryInterval_;
    }

    private long getMaxRedeliveries() {
        return this.maxRedeliveries_;
    }

    private long getRedeliveryInterval() {
        return this.redeliveryInterval_;
    }

    private File getTimerServiceShutdownFile() throws Exception {
        InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
        AppsManager appsManager = new AppsManager(env, false);
        String j2eeAppPath = appsManager.getLocation(this.appID);
        File timerServiceShutdownDirectory = new File(j2eeAppPath + File.separator);
        timerServiceShutdownDirectory.mkdirs();
        File timerServiceShutdownFile = new File(j2eeAppPath + File.separator + TIMER_SERVICE_FILE);
        return timerServiceShutdownFile;
    }

    private long getTimerServiceDownAt() {
        long timerServiceWentDownAt = -1L;
        try {
            File timerServiceShutdownFile = this.getTimerServiceShutdownFile();
            if (timerServiceShutdownFile.exists()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
                FileReader fr = new FileReader(timerServiceShutdownFile);
                BufferedReader br = new BufferedReader(fr, 128);
                String line = br.readLine();
                Date myDate = dateFormat.parse(line);
                timerServiceWentDownAt = myDate.getTime();
                logger.log(Level.INFO, "ejb.timer_service_last_shutdown", new Object[]{line});
            } else {
                logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{timerServiceShutdownFile});
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{""});
            logger.log(Level.WARNING, "", th);
        }
        return timerServiceWentDownAt;
    }

    public void onShutdown() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
            String downTimeStr = dateFormat.format(new Date());
            File timerServiceShutdownFile = this.getTimerServiceShutdownFile();
            FileWriter fw = new FileWriter(timerServiceShutdownFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(downTimeStr);
            pw.flush();
            pw.close();
            fw.close();
            logger.log(Level.INFO, "ejb.timer_service_shutdown_msg", new Object[]{downTimeStr});
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{TIMER_SERVICE_FILE});
            logger.log(Level.WARNING, "", th);
        }
    }

    private static class TaskExpiredWork
    implements Servicable {
        private EJBTimerService timerService_;
        private TimerPrimaryKey timerId_;

        public TaskExpiredWork(EJBTimerService timerService, TimerPrimaryKey timerId) {
            this.timerService_ = timerService;
            this.timerId_ = timerId;
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        public void run() {
            this.timerService_.deliverTimeout(this.timerId_);
        }
    }

    private class TimerCache {
        private Map timers_ = new HashMap();
        private Map containerTimers_ = new HashMap();

        public synchronized void addTimer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding timer " + timerState);
            }
            this.timers_.put(timerId, timerState);
            Long containerId = new Long(timerState.getContainerId());
            Object containerInfo = this.containerTimers_.get(containerId);
            if (timerState.timedObjectIsEntity()) {
                ArrayList<Object> entityBeans;
                if (containerInfo == null) {
                    entityBeans = new ArrayList<Object>();
                    this.containerTimers_.put(containerId, entityBeans);
                } else {
                    entityBeans = (ArrayList<Object>)containerInfo;
                }
                entityBeans.add(timerState.getTimedObjectPrimaryKey());
            } else {
                Long timerCount = containerInfo == null ? new Long(1L) : new Long((Long)containerInfo + 1L);
                this.containerTimers_.put(containerId, timerCount);
            }
        }

        public synchronized void removeTimer(TimerPrimaryKey timerId) {
            RuntimeTimerState timerState;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing timer " + timerId);
            }
            if ((timerState = (RuntimeTimerState)this.timers_.remove(timerId)) == null) {
                return;
            }
            Long containerId = new Long(timerState.getContainerId());
            Object containerInfo = this.containerTimers_.get(containerId);
            if (containerInfo != null) {
                if (timerState.timedObjectIsEntity()) {
                    Collection entityBeans = (Collection)containerInfo;
                    if (entityBeans.size() == 1) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        entityBeans.remove(timerState.getTimedObjectPrimaryKey());
                    }
                } else {
                    long timerCount = (Long)containerInfo;
                    if (timerCount == 1L) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        Long newCount = new Long(timerCount - 1L);
                        this.containerTimers_.put(containerId, newCount);
                    }
                }
            }
        }

        public synchronized RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
            return (RuntimeTimerState)this.timers_.get(timerId);
        }

        public synchronized boolean entityBeanHasTimers(long containerId, Object pkey) {
            Object containerInfo = this.containerTimers_.get(new Long(containerId));
            return containerInfo != null ? ((Collection)containerInfo).contains(pkey) : false;
        }

        public synchronized boolean containerHasTimers(long containerId) {
            return this.containerTimers_.containsKey(new Long(containerId));
        }

        public synchronized void validate() {
        }
    }
}

