/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Timer;
import javax.ejb.TimerService;

public class EJBTimerServiceWrapper
implements TimerService {
    private EJBTimerService timerService_;
    private EJBContextImpl ejbContext_;
    private long containerId_;
    private boolean entity_;
    private Object timedObjectPrimaryKey_;

    public EJBTimerServiceWrapper(EJBTimerService timerService, EJBContextImpl ejbContext) {
        this.timerService_ = timerService;
        this.ejbContext_ = ejbContext;
        BaseContainer container = (BaseContainer)ejbContext.getContainer();
        this.containerId_ = container.getEjbDescriptor().getUniqueId();
        this.entity_ = false;
        this.timedObjectPrimaryKey_ = null;
    }

    public EJBTimerServiceWrapper(EJBTimerService timerService, EntityContextImpl entityContext) {
        this(timerService, (EJBContextImpl)entityContext);
        this.entity_ = true;
        this.timedObjectPrimaryKey_ = null;
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        if (duration < 0L) {
            throw new IllegalArgumentException("invalid duration=" + duration);
        }
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), duration, 0L, info);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("invalid initial duration = " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), initialDuration, intervalDuration, info);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        if (expiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), expiration, 0L, info);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        if (initialExpiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), initialExpiration, intervalDuration, info);
        }
        catch (CreateException e) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(e);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        this.checkCallPermission();
        Collection timerIds = new HashSet();
        if (this.ejbContext_.isTimedObject()) {
            try {
                timerIds = this.timerService_.getTimerIds(this.containerId_, this.getTimedObjectPrimaryKey());
            }
            catch (FinderException fe) {
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(fe);
                throw ejbEx;
            }
        }
        HashSet<TimerWrapper> timerWrappers = new HashSet<TimerWrapper>();
        for (TimerPrimaryKey next : timerIds) {
            timerWrappers.add(new TimerWrapper(next, this.timerService_));
        }
        return timerWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTimedObjectPrimaryKey() {
        if (!this.entity_) {
            return null;
        }
        EJBTimerServiceWrapper eJBTimerServiceWrapper = this;
        synchronized (eJBTimerServiceWrapper) {
            if (this.timedObjectPrimaryKey_ == null) {
                this.timedObjectPrimaryKey_ = ((EntityContextImpl)this.ejbContext_).getPrimaryKey();
            }
        }
        return this.timedObjectPrimaryKey_;
    }

    private void checkCreateTimerCallPermission() throws IllegalStateException {
        if (!this.ejbContext_.isTimedObject()) {
            throw new IllegalStateException("EJBTimerService.createTimer can only be called from a timed object.  This EJB does not implement javax.ejb.TimedObject");
        }
        this.checkCallPermission();
    }

    private void checkCallPermission() throws IllegalStateException {
        this.ejbContext_.checkTimerServiceMethodAccess();
    }
}

