/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonException;
import com.sun.appserv.addons.AddonFatalException;
import com.sun.appserv.addons.ConfigurationContext;
import com.sun.appserv.addons.Configurator;
import com.sun.appserv.addons.InstallationContext;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.addons.AddonInstallationController;
import com.sun.enterprise.addons.AddonInstanceRegistry;
import com.sun.enterprise.addons.AddonRegistry;
import com.sun.enterprise.addons.AddonVersionImpl;
import com.sun.enterprise.addons.util.AddOnUtils;
import com.sun.enterprise.addons.util.ConfigurableJarFileFilter;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.management.MBeanServer;

public class AddonConfigurationController
extends AddonInstallationController {
    private final String SERVICEINTERFACE = "com.sun.appserv.addons.Configurator";
    private final String METAINFSERVICE = "META-INF/services/";
    private AddonRegistry ar = null;
    private DomainRoot amxDomainRoot = null;

    protected File getServiceJarLocation() {
        return new File(new File(this.getInstallRoot(), "lib"), "addons");
    }

    protected String getServiceInterface() {
        return "META-INF/services/com.sun.appserv.addons.Configurator";
    }

    protected FilenameFilter getFilenameFilter() {
        return new ConfigurableJarFileFilter(this.ar);
    }

    protected String getName(File f) throws AddonFatalException {
        String name = f.getName();
        String regex = "\\.([j|J][a|A][r|R])";
        if (name.matches(".*" + regex)) {
            return name.split(regex)[0];
        }
        throw new AddonFatalException(localStrings.getString("addon.notjarfile", name));
    }

    public void configureDAS(File installRoot, File domainRoot) throws AddonFatalException {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "InstallRoot for configureDAS :" + installRoot);
            this.getLogger().log(Level.FINER, "DomainRoot for configureDAS :" + domainRoot);
        }
        this.configure(installRoot, domainRoot, ConfigurationContext.ConfigurationType.DAS);
    }

    public void configureInstances(File installRoot, File domainRoot) throws AddonFatalException {
        this.configure(installRoot, domainRoot, ConfigurationContext.ConfigurationType.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(File installRoot, File domainRoot, ConfigurationContext.ConfigurationType type) throws AddonFatalException {
        this.setup(installRoot, domainRoot, type);
        this.loadServices(this.getServiceJarLocation());
        Set mainBasedServices = this.getMapSortedByValue(this.getMainClassBasedServices()).entrySet();
        for (Map.Entry entry : mainBasedServices) {
            this.invokeMain(entry.getKey(), (String)entry.getValue(), type);
        }
        Set apiBasedServices = this.getMapSortedByValue(this.getApiBasedServices()).entrySet();
        for (Map.Entry entry : apiBasedServices) {
            try {
                this.invokeApi(entry.getKey(), (String)entry.getValue(), type);
            }
            catch (Exception e) {
                this.getLogger().warning(localStrings.getString("addon.configurationcomplete.error", "configure", entry.getKey(), e.getLocalizedMessage()));
            }
            finally {
                this.ar.store();
                this.ar.close();
            }
        }
        this.ar.store();
        this.ar.close();
    }

    private void setup(File installRoot, File domainRoot, ConfigurationContext.ConfigurationType type) throws AddonFatalException {
        this.setInstallRoot(installRoot);
        this.setDomainRoot(domainRoot);
        this.ar = type.equals((Object)ConfigurationContext.ConfigurationType.DAS) ? new AddonRegistry(domainRoot, this.getLogger()) : new AddonInstanceRegistry(domainRoot, this.getLogger());
    }

    private void invokeMain(Object obj, String addonName, ConfigurationContext.ConfigurationType type) throws AddonFatalException {
        AddonRegistry.status addonStatus = this.ar.getStatus(addonName);
        if (addonStatus.equals((Object)AddonRegistry.status.CONFIGURE)) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Starting " + (Object)((Object)addonStatus) + " on " + addonName);
            }
            try {
                Method m = obj.getClass().getMethod("main", String[].class);
                String[] args = new String[]{this.getInstallRoot().getCanonicalPath(), this.getDomainRoot().getCanonicalPath()};
                m.invoke(obj, new Object[]{args});
                this.ar.setStatus(addonName, AddonRegistry.status.CONFIGURE);
                this.ar.setStatus(addonName, AddonRegistry.status.ENABLE);
                if (this.getLogger().isLoggable(Level.INFO)) {
                    String s = localStrings.getString("addon.configurecomplete", addonStatus.toString(), addonName);
                    this.getLogger().info(s);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Fatal Exception while configuring the addon " + addonName, e);
                throw new AddonFatalException(e);
            }
        }
    }

    private void invokeApi(Object obj, String addonName, ConfigurationContext.ConfigurationType type) throws AddonFatalException {
        AddonVersionImpl oldVersion;
        AddonRegistry.status addonStatus = this.ar.getStatus(addonName);
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Starting " + (Object)((Object)addonStatus) + " on " + addonName);
        }
        try {
            AddonVersionImpl newVersion = new AddonVersionImpl(addonName);
            oldVersion = this.ar.getOldVersion(newVersion);
            if (oldVersion != null) {
                if (oldVersion.isHigher(newVersion)) {
                    addonStatus = AddonRegistry.status.UPGRADE;
                } else if (oldVersion.isLower(newVersion)) {
                    addonStatus = AddonRegistry.status.UNCHANGED;
                }
            }
        }
        catch (AddonException aoe) {
            throw new AddonFatalException(aoe);
        }
        Configurator conf = (Configurator)Configurator.class.cast(obj);
        InstallationContext ic = new InstallationContext();
        ic.setInstallationDirectory(this.getInstallRoot());
        ConfigurationContext cc = new ConfigurationContext();
        cc.setInstallationContext(ic);
        cc.setDomainDirectory(this.getDomainRoot());
        cc.setConfigurationType(type);
        if (type.equals((Object)ConfigurationContext.ConfigurationType.INSTANCE)) {
            cc.setAMXDomainRoot(this.getAMXDomainRoot());
        }
        this.setAdminCredentials(cc);
        try {
            switch (addonStatus) {
                case CONFIGURE: {
                    this.checkDependencies(addonName);
                    conf.configure(cc);
                    this.ar.setStatus(addonName, AddonRegistry.status.CONFIGURE);
                    this.ar.setStatus(addonName, AddonRegistry.status.ENABLE);
                    break;
                }
                case ENABLE: {
                    conf.enable(cc);
                    this.ar.setStatus(addonName, AddonRegistry.status.ENABLE);
                    break;
                }
                case DISABLE: {
                    conf.disable(cc);
                    this.ar.setStatus(addonName, AddonRegistry.status.DISABLE);
                    break;
                }
                case UNCONFIGURE: {
                    conf.unconfigure(cc);
                    this.ar.setStatus(addonName, AddonRegistry.status.UNCONFIGURE);
                    break;
                }
                case UPGRADE: {
                    this.ar.setStatus(oldVersion.getName(), AddonRegistry.status.REMOVE);
                    conf.upgrade(cc, oldVersion);
                    this.ar.setStatus(addonName, AddonRegistry.status.CONFIGURE);
                    this.ar.setStatus(addonName, AddonRegistry.status.ENABLE);
                    break;
                }
            }
            if (this.getLogger().isLoggable(Level.INFO) && !addonStatus.equals((Object)AddonRegistry.status.UNCHANGED)) {
                String s = localStrings.getString("addon.configurecomplete", addonStatus.toString(), addonName);
                this.getLogger().info(s);
            }
        }
        catch (AddonFatalException afe) {
            this.getLogger().log(Level.FINE, "Fatal Exception while configuring the addon " + addonName, afe);
            throw afe;
        }
        catch (AddonException ae) {
            this.getLogger().warning(localStrings.getString("addon.configurationcomplete.error", addonStatus.toString(), addonName, ae.getLocalizedMessage()));
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Fatal Exception while configuring the addon " + addonName, e);
            throw new AddonFatalException(e);
        }
    }

    private void setAMXDomainRoot() throws AddonFatalException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            this.amxDomainRoot = ProxyFactory.getInstance(mbs).getDomainRoot();
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
    }

    private DomainRoot getAMXDomainRoot() throws AddonFatalException {
        if (this.amxDomainRoot == null) {
            this.setAMXDomainRoot();
        }
        return this.amxDomainRoot;
    }

    private HashMap getMapSortedByValue(Map hmap) {
        LinkedHashMap map = new LinkedHashMap();
        if (hmap == null || hmap.size() < 1) {
            return map;
        }
        ArrayList mapKeys = new ArrayList(hmap.keySet());
        ArrayList mapValues = new ArrayList(hmap.values());
        hmap.clear();
        TreeSet sortedSet = new TreeSet(mapValues);
        Object[] sortedArray = sortedSet.toArray();
        int size = sortedArray.length;
        for (int i = 0; i < size; ++i) {
            map.put(mapKeys.get(mapValues.indexOf(sortedArray[i])), sortedArray[i]);
        }
        return map;
    }

    private void checkDependencies(String addonName) throws AddonFatalException {
        try {
            JarFile jar = AddOnUtils.getAddonJarFile(addonName, this.getServiceJarLocation(), this.getFilenameFilter());
            if (jar == null) {
                return;
            }
            String[] dependencies = AddOnUtils.getDependencies(jar);
            if (dependencies == null) {
                return;
            }
            for (String dependency : dependencies) {
                if (!this.ar.getStatus(dependency).equals((Object)AddonRegistry.status.CONFIGURE)) continue;
                throw new AddonFatalException(localStrings.getString("addon.dependency.missing", addonName, dependency));
            }
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
    }

    public void unconfigureDAS(File installRoot, File domainRoot) throws AddonFatalException {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "InstallRoot for unconfigureDAS :" + installRoot);
            this.getLogger().log(Level.FINER, "DomainRoot for unconfigureDAS :" + domainRoot);
        }
        this.unconfigure(installRoot, domainRoot, ConfigurationContext.ConfigurationType.DAS);
    }

    private void unconfigure(File installRoot, File domainRoot, ConfigurationContext.ConfigurationType type) throws AddonFatalException {
        this.setup(installRoot, domainRoot, type);
        File deletedDir = new File(this.getServiceJarLocation() + File.separator + ".deleted");
        if (!deletedDir.exists()) {
            return;
        }
        this.loadServices(deletedDir);
        Set apiBasedServices = this.getMapSortedByValue(this.getApiBasedServices()).entrySet();
        for (Map.Entry entry : apiBasedServices) {
            String addonName = (String)entry.getValue();
            if (!this.ar.isInRegistry(addonName) || !this.ar.isUnConfigurationRequired(addonName)) continue;
            Configurator conf = (Configurator)Configurator.class.cast(entry.getKey());
            InstallationContext ic = new InstallationContext();
            ic.setInstallationDirectory(this.getInstallRoot());
            ConfigurationContext cc = new ConfigurationContext();
            cc.setInstallationContext(ic);
            cc.setDomainDirectory(this.getDomainRoot());
            cc.setConfigurationType(type);
            try {
                conf.unconfigure(cc);
                this.ar.setStatus(addonName, AddonRegistry.status.REMOVE);
            }
            catch (AddonFatalException afe) {
                this.getLogger().log(Level.SEVERE, "Fatal Exception while unconfiguring the addon " + addonName, afe);
                throw afe;
            }
            catch (AddonException ae) {
                this.getLogger().warning(localStrings.getString("addon.unconfigurationcomplete.error", "unconfigure", addonName, ae.getLocalizedMessage()));
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Fatal Exception while unconfiguring the addon " + addonName, e);
                throw new AddonFatalException(e);
            }
        }
        this.ar.store();
        this.ar.close();
    }
}

