/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonFatalException;
import com.sun.appserv.addons.ConfigurationContext;
import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.addons.AddonClassPath;
import com.sun.enterprise.addons.AddonConfigurationController;
import com.sun.enterprise.addons.AddonInstallationController;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public abstract class AddonController {
    private final HashMap apiBasedServices = new HashMap();
    private final HashMap mainClassBasedServices = new HashMap();
    private final HashMap simpleJars = new HashMap();
    private volatile File installRoot = null;
    private boolean servicesAreLoaded = false;
    private static String adminUser = null;
    private static String adminPassword = null;
    private final String DEFAULT_ADMIN_USER = "admin";
    private final String DEFAULT_ADMIN_PASSWORD = "adminadmin";
    private File domainRoot = null;
    private volatile Logger logger = null;
    protected static final StringManager localStrings = StringManager.getManager(AddonController.class);

    protected void loadServices(File jarDir) throws AddonFatalException {
        if (this.servicesAreLoaded) {
            return;
        }
        this.servicesAreLoaded = true;
        try {
            File[] jars = jarDir.listFiles(this.getFilenameFilter());
            if (jars == null) {
                return;
            }
            for (File jar : jars) {
                if (jar != null && (jar.getName().startsWith("grizzly") || jar.getName().startsWith("freemarker") || jar.getName().startsWith("wadl2java"))) continue;
                JarFile jF = new JarFile(jar);
                String serviceName = this.findApiBasedService(jF);
                ClassLoader cl = this.createClassLoader(jar.toURI().toURL());
                if (serviceName != null) {
                    this.apiBasedServices.put(cl.loadClass(serviceName).newInstance(), this.getName(jar));
                    continue;
                }
                String mainClass = this.findMainClassBasedService(jF);
                if (mainClass != null) {
                    this.mainClassBasedServices.put(cl.loadClass(mainClass).newInstance(), this.getName(jar));
                    continue;
                }
                this.simpleJars.put(jar, this.getName(jar));
            }
        }
        catch (AddonFatalException afe) {
            throw afe;
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
    }

    protected ClassLoader createClassLoader(URL jar) throws AddonFatalException {
        URL[] classpath = null;
        try {
            classpath = AddonClassPath.getClassPath(jar, this.getInstallRoot().getCanonicalPath(), this.getLogger());
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
        return new URLClassLoader(classpath, this.getClass().getClassLoader());
    }

    protected HashMap getApiBasedServices() {
        return this.apiBasedServices;
    }

    protected HashMap getMainClassBasedServices() {
        return this.mainClassBasedServices;
    }

    protected HashMap getSimpleJars() {
        return this.simpleJars;
    }

    protected abstract FilenameFilter getFilenameFilter();

    protected abstract String getName(File var1) throws AddonFatalException;

    protected abstract File getServiceJarLocation();

    protected abstract String getServiceInterface();

    protected String findApiBasedService(JarFile jF) throws AddonFatalException {
        try {
            ZipEntry zE = jF.getEntry(this.getServiceInterface());
            if (zE != null) {
                InputStream in = jF.getInputStream(zE);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                return br.readLine();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, e.getMessage(), e);
            throw new AddonFatalException(e);
        }
        return null;
    }

    protected String findMainClassBasedService(JarFile jF) throws AddonFatalException {
        try {
            String main;
            Attributes attrs;
            Manifest mf = jF.getManifest();
            if (mf != null && (attrs = mf.getMainAttributes()) != null && (main = attrs.getValue(Attributes.Name.MAIN_CLASS)) != null) {
                return main;
            }
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
        return null;
    }

    public void setInstallRoot(File installRoot) {
        this.installRoot = installRoot;
    }

    protected File getInstallRoot() {
        return this.installRoot;
    }

    public static AddonInstallationController getAddonInstallationController() {
        return new AddonInstallationController();
    }

    public static AddonConfigurationController getAddonConfigurationController() {
        return new AddonConfigurationController();
    }

    protected synchronized Logger getLogger() {
        if (this.logger == null) {
            return Logger.getAnonymousLogger();
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setAdminCredentials(ConfigurationContext cc) {
        if (adminPassword == null || adminPassword.length() < 1) {
            this.populateAdminCredentials();
        }
        cc.setAdminUser(adminUser);
        cc.setAdminPassword(adminPassword);
    }

    private void populateAdminCredentials() {
        try {
            String domainXMLLocation = this.getDomainRoot().getCanonicalPath() + File.separator + "config" + File.separator + "domain.xml";
            File domainXML = new File(domainXMLLocation);
            ConfigContext configContext = ConfigFactory.createConfigContext(domainXML.getAbsolutePath());
            HttpListener as = ServerHelper.getHttpListener(configContext, "server", "admin-listener");
            String host = "localhost";
            int port = Integer.parseInt(as.getPort());
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            if (store.exists(host, port)) {
                LoginInfo login = store.read(host, port);
                adminPassword = login.getPassword();
                adminUser = login.getUser();
                if (adminUser == null) {
                    adminUser = "admin";
                    adminPassword = "adminadmin";
                }
            }
        }
        catch (Exception e) {
            adminUser = "admin";
            adminPassword = "adminadmin";
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    void setDomainRoot(File domainRoot) {
        this.domainRoot = domainRoot;
    }

    File getDomainRoot() {
        return this.domainRoot;
    }
}

