/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonException;
import com.sun.appserv.addons.AddonFatalException;
import com.sun.enterprise.addons.AddonVersionImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonRegistry {
    private Properties registry = null;
    Properties systemRegistry = null;
    private FileOutputStream out = null;
    private FileOutputStream systemOut = null;
    private FileInputStream in = null;
    private FileInputStream systemIn = null;
    private File registryFile = null;
    private File systemRegistryFile = null;
    Logger logger = null;
    private final String REGISTRY = "domain-registry";
    private final String SYSTEMREGISTRY = ".domain-registry.system";
    private final String ENABLEKEY = ".enabled";
    final String CONFIGUREKEY = ".configured";
    final String INSTANCEKEY = ".instance";

    AddonRegistry(File domainRoot, Logger logger) throws AddonFatalException {
        this.logger = logger;
        this.load(domainRoot);
    }

    private void load(File domainRoot) throws AddonFatalException {
        try {
            this.registryFile = new File(new File(domainRoot, "config"), "domain-registry");
            this.systemRegistryFile = new File(new File(domainRoot, "config"), ".domain-registry.system");
            if (!this.registryFile.exists()) {
                this.registryFile.createNewFile();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Created : " + this.registryFile);
                }
            }
            if (!this.systemRegistryFile.exists()) {
                this.systemRegistryFile.createNewFile();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Created : " + this.systemRegistryFile);
                }
            }
            this.systemIn = new FileInputStream(this.systemRegistryFile);
            this.systemRegistry = new Properties();
            this.systemRegistry.load(this.systemIn);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Loaded Registry : .domain-registry.system");
            }
            this.in = new FileInputStream(this.registryFile);
            this.registry = new Properties();
            this.registry.load(this.in);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Loaded Registry : domain-registry");
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, e.getMessage(), e);
            }
            throw new AddonFatalException(e);
        }
    }

    status getStatus(String name) {
        String confFlag = (String)String.class.cast(this.registry.get(name + ".configured"));
        String systemConfFlag = (String)String.class.cast(this.systemRegistry.get(name + ".configured"));
        String enableFlag = (String)String.class.cast(this.registry.get(name + ".enabled"));
        String systemEnableFlag = (String)String.class.cast(this.systemRegistry.get(name + ".enabled"));
        if (this.isNull(confFlag, systemConfFlag) && this.isNull(enableFlag, systemEnableFlag)) {
            return status.CONFIGURE;
        }
        if (!this.isEqual(confFlag, systemConfFlag) && confFlag != null) {
            if (confFlag.equalsIgnoreCase("false")) {
                return status.UNCONFIGURE;
            }
            return status.CONFIGURE;
        }
        if (!this.isEqual(enableFlag, systemEnableFlag)) {
            if (enableFlag != null && enableFlag.equalsIgnoreCase("true")) {
                return status.ENABLE;
            }
            return status.DISABLE;
        }
        return status.UNCHANGED;
    }

    private boolean isNull(String flag, String systemFlag) {
        return flag == null && systemFlag == null;
    }

    private boolean isEqual(String flag, String systemFlag) {
        if (flag != null) {
            return flag.equals(systemFlag);
        }
        return systemFlag == null;
    }

    void setStatus(String name, status stat) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Setting status of " + name + " as" + (Object)((Object)stat));
        }
        switch (stat) {
            case ENABLE: {
                this.registry.setProperty(name + ".enabled", "true");
                this.systemRegistry.setProperty(name + ".enabled", "true");
                break;
            }
            case DISABLE: {
                this.registry.setProperty(name + ".enabled", "false");
                this.systemRegistry.setProperty(name + ".enabled", "false");
                break;
            }
            case CONFIGURE: {
                this.registry.setProperty(name + ".configured", "true");
                this.systemRegistry.setProperty(name + ".configured", "true");
                this.systemRegistry.setProperty(name + ".instance" + ".configured", "true");
                break;
            }
            case UNCONFIGURE: {
                this.registry.setProperty(name + ".configured", "false");
                this.systemRegistry.setProperty(name + ".configured", "false");
                this.systemRegistry.setProperty(name + ".instance" + ".configured", "false");
                break;
            }
            case REMOVE: {
                this.registry.remove(name + ".configured");
                this.registry.remove(name + ".enabled");
                this.systemRegistry.remove(name + ".configured");
                this.systemRegistry.remove(name + ".enabled");
                this.systemRegistry.remove(name + ".instance" + ".configured");
                break;
            }
        }
    }

    void store() throws AddonFatalException {
        try {
            this.out = new FileOutputStream(this.registryFile);
            this.registry.store(this.out, null);
            this.out.close();
            this.systemOut = new FileOutputStream(this.systemRegistryFile);
            this.systemRegistry.store(this.systemOut, null);
            this.systemOut.close();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, e.getMessage(), e);
            }
            throw new AddonFatalException(e);
        }
    }

    void close() throws AddonFatalException {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.systemIn != null) {
                this.systemIn.close();
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, e.getMessage(), e);
            }
            throw new AddonFatalException(e);
        }
    }

    public boolean isConfigurationRequired(String name) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Status for " + name + " is " + (Object)((Object)this.getStatus(name)));
        }
        return this.getStatus(name) != status.UNCHANGED;
    }

    public boolean isUnConfigurationRequired(String name) {
        String systemConfFlag;
        String confFlag;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Status for " + name + " is " + (Object)((Object)this.getStatus(name)));
        }
        if (this.isNull(confFlag = (String)String.class.cast(this.registry.get(name + ".configured")), systemConfFlag = (String)String.class.cast(this.systemRegistry.get(name + ".configured")))) {
            return false;
        }
        if (!this.isEqual(confFlag, systemConfFlag)) {
            if (confFlag != null) {
                return confFlag.equalsIgnoreCase("false");
            }
        } else if (confFlag != null) {
            return !confFlag.equalsIgnoreCase("false");
        }
        return false;
    }

    public boolean isInRegistry(String name) {
        String systemConfFlag;
        String confFlag;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Status for " + name + " is " + (Object)((Object)this.getStatus(name)));
        }
        return !this.isNull(confFlag = (String)String.class.cast(this.registry.get(name + ".configured")), systemConfFlag = (String)String.class.cast(this.systemRegistry.get(name + ".configured")));
    }

    protected AddonVersionImpl getOldVersion(AddonVersionImpl newVersion) throws AddonException {
        String newNamePart = newVersion.getNamePart();
        ArrayList<String> al = this.getNames(".configured");
        if (al == null || al.size() < 1) {
            return null;
        }
        for (String str : al) {
            if (!str.startsWith(newNamePart)) continue;
            return new AddonVersionImpl(str);
        }
        return null;
    }

    private ArrayList<String> getNames(String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> e = this.registry.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            if (!str.endsWith(suffix)) continue;
            list.add(str.substring(0, str.length() - suffix.length()));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum status {
        UNCHANGED,
        ENABLE,
        DISABLE,
        UNCONFIGURE,
        CONFIGURE,
        REMOVE,
        UPGRADE;

    }
}

