/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AddOnUtils {
    public static JarFile getAddonJarFile(String addonName, File jarDir, FilenameFilter filter) throws Exception {
        File[] jars;
        if (jarDir == null || addonName == null || filter == null) {
            throw new Exception("invalid input to getAddonJarFile");
        }
        for (File jar : jars = jarDir.listFiles(filter)) {
            String str = jar.getName().split("\\.[j|J][a|A][r|R]")[0];
            if (!str.equals(addonName)) continue;
            return new JarFile(jar);
        }
        return null;
    }

    public static String[] getDependencies(JarFile jar) throws Exception {
        String[] strArr = null;
        if (jar == null) {
            throw new Exception("invalid input to getDependencies");
        }
        Manifest mf = jar.getManifest();
        if (mf == null) {
            return strArr;
        }
        Attributes attrs = mf.getMainAttributes();
        if (attrs == null) {
            return strArr;
        }
        Set<Map.Entry<Object, Object>> mfattrs = attrs.entrySet();
        for (Map.Entry<Object, Object> entry : mfattrs) {
            String key = ((Attributes.Name)entry.getKey()).toString();
            String val = (String)entry.getValue();
            if (!key.equals("Add-On-Dependencies")) continue;
            if (val.contains(",")) {
                strArr = val.split(",");
                continue;
            }
            strArr = new String[]{val};
        }
        return strArr;
    }
}

