/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.alert;

import com.sun.appserv.management.alert.LogDomains;
import com.sun.enterprise.admin.alert.AlertSubscriptionInfo;
import com.sun.enterprise.admin.alert.MBeanRegistrationEventListener;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.serverbeans.AlertService;
import com.sun.enterprise.config.serverbeans.AlertSubscription;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.FilterConfig;
import com.sun.enterprise.config.serverbeans.ListenerConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.logging.LogMBean;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AlertConfigurator {
    private static final String MBEAN_SERVER_DELEGATE_OBJECT_NAME = "JMImplementation:type=MBeanServerDelegate";
    private static final String DEFAULT_FILTER_CLASS_NAME = "com.sun.appserv.management.alert.MailFilter";
    private static final String LOG_MBEAN_NAME = "LogMBean";
    private static final AlertConfigurator instance = new AlertConfigurator();

    public static AlertConfigurator getAlertConfigurator() {
        return instance;
    }

    private AlertConfigurator() {
    }

    private AlertService getAlertService() {
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            if (sc == null) {
                return null;
            }
            return ServerBeansFactory.getConfigBean(sc.getConfigContext()).getAlertService();
        }
        catch (Exception e) {
            new ErrorManager().error("Error In getAlertService  ", e, 0);
            return null;
        }
    }

    public void configure() {
        AlertService alertService;
        Logger logger = LogDomains.getAlertLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AlertConfigurator.configure called..");
        }
        if ((alertService = this.getAlertService()) != null) {
            int count = alertService.sizeAlertSubscription();
            if (count == 0) {
                return;
            }
            ArrayList<AlertSubscriptionInfo> alertSubscriptionList = new ArrayList<AlertSubscriptionInfo>();
            for (int i = 0; i < count; ++i) {
                AlertSubscription subscription = alertService.getAlertSubscription(i);
                NotificationListener listener = this.configureNotificationListener(subscription.getListenerConfig());
                NotificationFilter filter = this.configureNotificationFilter(subscription.getFilterConfig());
                alertSubscriptionList.add(new AlertSubscriptionInfo(subscription.getListenerConfig().getSubscribeListenerWith(), listener, filter));
                String monitorNames = subscription.getListenerConfig().getSubscribeListenerWith();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "AlertConfigurator.configure monitorNames.." + monitorNames);
                }
                StringTokenizer tokenizer = new StringTokenizer(monitorNames, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (!token.equals(LOG_MBEAN_NAME)) continue;
                    LogMBean.getInstance().addNotificationListener(listener, filter, null);
                }
            }
            MBeanRegistrationEventListener registrationListener = new MBeanRegistrationEventListener(alertSubscriptionList);
            this.readyForMBeanRegistrationEvent(registrationListener);
        }
    }

    private NotificationListener configureNotificationListener(ListenerConfig listenerConfig) {
        Logger alertLogger = LogDomains.getAlertLogger();
        if (alertLogger.isLoggable(Level.FINE)) {
            alertLogger.log(Level.FINE, "ConfigureNotificationListener called with className ..." + listenerConfig.getListenerClassName());
        }
        NotificationListener listener = null;
        try {
            listener = (NotificationListener)this.instantiateAndConfigure(listenerConfig.getListenerClassName(), listenerConfig.getElementProperty());
        }
        catch (Exception e) {
            new ErrorManager().error("Error In Notification Listener Config ", e, 0);
        }
        return listener;
    }

    private NotificationFilter configureNotificationFilter(FilterConfig filterConfig) {
        String filterClassName = DEFAULT_FILTER_CLASS_NAME;
        ElementProperty[] properties = null;
        if (filterConfig != null) {
            filterClassName = filterConfig.getFilterClassName();
            properties = filterConfig.getElementProperty();
        }
        NotificationFilter filter = null;
        try {
            filter = (NotificationFilter)this.instantiateAndConfigure(filterClassName, properties);
        }
        catch (Exception e) {
            new ErrorManager().error("Error In Notification Filter Config ", e, 0);
        }
        return filter;
    }

    private void setProperties(Object o, ElementProperty[] properties) {
        if (properties == null) {
            return;
        }
        Method[] methods = null;
        try {
            methods = this.getDeclaredMethods(o.getClass());
            for (int i = 0; i < properties.length; ++i) {
                ElementProperty property = properties[i];
                String propertyName = property.getName().toLowerCase();
                String propertyValue = property.getValue();
                for (int j = 0; j < methods.length; ++j) {
                    String methodName = methods[j].getName().toLowerCase();
                    if (!methodName.startsWith("set") || !methodName.endsWith(propertyName)) continue;
                    Class<?>[] parameterTypes = methods[j].getParameterTypes();
                    if (parameterTypes.length != 1) {
                        new ErrorManager().error("Only one Parameter is allowed for the setter  Method: " + methodName + " has invalid signature", new Exception(), 0);
                    }
                    String parameterType = parameterTypes[0].getName();
                    Object[] parameters = new Object[1];
                    if (parameterType.equals("java.lang.String")) {
                        parameters[0] = propertyValue;
                    } else if (parameterType.equals("byte")) {
                        parameters[0] = new Byte(propertyValue.getBytes()[0]);
                    } else if (parameterType.equals("int")) {
                        parameters[0] = new Integer(propertyValue);
                    } else if (parameterType.equals("float")) {
                        parameters[0] = new Float(propertyValue);
                    } else if (parameterType.equals("double")) {
                        parameters[0] = new Double(propertyValue);
                    } else if (parameterType.equals("char")) {
                        parameters[0] = new Character(propertyValue.charAt(0));
                    } else if (parameterType.equals("boolean")) {
                        parameters[0] = new Boolean(propertyValue);
                    } else if (parameterType.equals("long")) {
                        parameters[0] = new Long(propertyValue);
                    } else if (parameterType.equals("short")) {
                        parameters[0] = new Short(propertyValue);
                    } else {
                        new ErrorManager().error("Only the basic primitive types can be set as properties to NotificationListener and  NotificationFilter ", new Exception(), 0);
                        continue;
                    }
                    methods[j].invoke(o, parameters);
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error While Setting properties to Notification Listener or  Filter ", e, 0);
        }
    }

    private Object instantiateAndConfigure(String className, ElementProperty[] properties) {
        Object o;
        Logger alertLogger = LogDomains.getAlertLogger();
        if (alertLogger.isLoggable(Level.FINE)) {
            alertLogger.log(Level.FINE, "instantiateAndConfigure called with className.." + className);
        }
        if ((o = this.getInstance(className)) != null && properties != null) {
            if (alertLogger.isLoggable(Level.FINE)) {
                alertLogger.log(Level.FINE, "instantiateAndConfigure setting Properties..");
            }
            this.setProperties(o, properties);
        }
        return o;
    }

    private Object getInstance(final String className) {
        if (className == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    return Class.forName(className, true, cl).newInstance();
                }
                catch (Exception e) {
                    new ErrorManager().error("Error In Instantiating Class " + className, e, 0);
                    return null;
                }
            }
        });
    }

    private final Method[] getDeclaredMethods(final Class clz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clz.getDeclaredMethods();
            }
        });
    }

    private void readyForMBeanRegistrationEvent(NotificationListener registrationListener) {
        try {
            MBeanServer mbeanServer = AdminService.getAdminService().getAdminContext().getMBeanServer();
            mbeanServer.addNotificationListener(new ObjectName(MBEAN_SERVER_DELEGATE_OBJECT_NAME), registrationListener, (NotificationFilter)null, (Object)null);
        }
        catch (Exception e) {
            new ErrorManager().error("Error In registerning MBeanServerNotificationListener ", e, 0);
        }
    }
}

