/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.EventKey;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;

public class AdminEvent
extends Notification
implements Cloneable {
    private EventKey eKey = null;
    private static long eventCounter = 0L;
    private String targetDest;
    private String effectiveDest;
    private int hops = 0;
    private static final int MAX_HOPS = 3;
    static final String eventType = AdminEvent.class.getName();
    private transient ConfigContext configContext;
    private transient ConfigContext oldConfigContext;
    private static StringManager localStrings = StringManager.getManager(AdminEvent.class);
    ArrayList configChangeList;
    List dependentChangeList;

    public AdminEvent(String instanceName) {
        this(eventType, instanceName);
    }

    public AdminEvent(String eventType, String instanceName) {
        super(eventType, (Object)instanceName, ++eventCounter, System.currentTimeMillis());
    }

    protected AdminEvent(String type, Object source, long seqNumber, long time) {
        super(type, source, seqNumber, time);
    }

    public Object getSource() {
        return super.getSource();
    }

    public String getInstanceName() {
        return (String)this.getSource();
    }

    void setContext(ConfigContext ctx) {
        this.configContext = ctx;
    }

    void setOldContext(ConfigContext ctx) {
        this.oldConfigContext = ctx;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public ConfigContext getOldConfigContext() {
        return this.oldConfigContext;
    }

    public String toString() {
        int numChg = this.configChangeList == null ? 0 : this.configChangeList.size();
        return this.getClass().getName() + " -- " + this.getInstanceName() + " [" + numChg + " Change(s), Id:" + this.getSequenceNumber() + ", ts:" + this.getTimeStamp() + "]";
    }

    public String getEventInfo() {
        return this.toString() + this.getConfigChangeInfo();
    }

    public String getConfigChangeInfo() {
        StringBuffer buf = new StringBuffer();
        if (this.configChangeList != null) {
            for (ConfigChange change : this.configChangeList) {
                buf.append(change.toString());
            }
        }
        return buf.toString();
    }

    synchronized void addConfigChange(ConfigChange change) {
        this.assertNotNull(change);
        if (this.configChangeList == null) {
            this.configChangeList = new ArrayList();
        }
        this.configChangeList.add(change);
    }

    public synchronized void addConfigChange(ArrayList changeList) {
        if (changeList == null) {
            String msg = localStrings.getString("admin.event.null_configchangelist");
            throw new IllegalArgumentException(msg);
        }
        if (this.configChangeList == null) {
            this.configChangeList = new ArrayList();
        }
        this.configChangeList.addAll(changeList);
    }

    public synchronized void addDependentConfigChange(List list) {
        if (list == null) {
            String msg = localStrings.getString("admin.event.null_configchangelist");
            throw new IllegalArgumentException(msg);
        }
        if (this.dependentChangeList == null) {
            this.dependentChangeList = new ArrayList();
        }
        this.dependentChangeList.addAll(list);
    }

    public List getDependentChangeList() {
        return this.dependentChangeList;
    }

    public ArrayList getConfigChangeList() {
        return this.configChangeList;
    }

    synchronized void removeConfigChange(ConfigChange change) {
        int ndx;
        this.assertNotNull(change);
        if (this.configChangeList != null && (ndx = this.configChangeList.indexOf(change)) != -1) {
            this.configChangeList.remove(ndx);
        }
    }

    boolean isNoOp() {
        return false;
    }

    private void assertNotNull(ConfigChange change) {
        if (change == null) {
            String msg = localStrings.getString("admin.event.null_configchange");
            throw new IllegalArgumentException(msg);
        }
    }

    public String getTargetDestination() {
        return this.targetDest;
    }

    public void setTargetDestination(String tarDest) {
        this.targetDest = tarDest;
    }

    public String getEffectiveDestination() {
        return this.effectiveDest;
    }

    public void setEffectiveDestination(String eDest) {
        this.effectiveDest = eDest;
    }

    public void setEventId(EventKey ek) {
        this.eKey = ek;
    }

    public EventKey getEventId() {
        return this.eKey;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getHopCount() {
        return this.hops;
    }

    public int incrementHopCount() {
        return ++this.hops;
    }

    public boolean isValidHopCount() {
        return this.hops <= 3;
    }

    public int getActionType() {
        return 0;
    }

    private void setAction(int action) {
    }
}

