/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ElementChangeEvent
extends AdminEvent {
    public static final int ACTION_ELEMENT_UNDEFINED = 0;
    public static final int ACTION_ELEMENT_CREATE = 1;
    public static final int ACTION_ELEMENT_DELETE = 2;
    public static final int ACTION_ELEMENT_UPDATE = 3;
    static final String eventType = ElementChangeEvent.class.getName();
    private int change_action = 0;
    private String element_id = null;
    private String element_type = null;
    private String element_path = null;
    private static StringManager localStrings = StringManager.getManager(ElementChangeEvent.class);

    public static ArrayList getEventInstances(String event_type, String instanceName, String elementType, ArrayList changeList, ConfigContext ctx) throws Exception {
        int action = ElementChangeHelper.getActionCodeForChanges(changeList);
        if (action == 0) {
            return null;
        }
        String element_xpath = ElementChangeHelper.getElementXPath(changeList);
        String element_id = ElementChangeHelper.getConfigElementPrimaryKey(element_xpath);
        AdminEvent event = null;
        if (event_type.equals(eventType)) {
            event = new ElementChangeEvent(instanceName, event_type, action, element_id);
        } else {
            try {
                Constructor<?> contr;
                Class<?> cl = Class.forName(event_type);
                try {
                    contr = cl.getConstructor(String.class, Integer.TYPE);
                    event = (AdminEvent)contr.newInstance(instanceName, new Integer(action));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (event == null) {
                    contr = cl.getConstructor(String.class, Integer.TYPE, String.class);
                    event = (AdminEvent)contr.newInstance(instanceName, new Integer(action), element_id);
                }
                if (event != null) {
                    ((AdminEvent)event).addConfigChange(changeList);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (event != null) {
            String targetName = ElementChangeHelper.getConfigElementTargetName(element_xpath, ctx);
            event.setTargetDestination(targetName);
            ArrayList<ElementChangeEvent> events = new ArrayList<ElementChangeEvent>();
            events.add((ElementChangeEvent)event);
            return events;
        }
        return null;
    }

    public ElementChangeEvent(String instance, String evtType, int actionCode, String elementId) {
        super(evtType, instance);
        this.element_id = elementId;
        this.setAction(actionCode);
    }

    public void addConfigChange(ArrayList changeList) {
        if (this.getConfigChangeList() != null) {
            String msg = localStrings.getString("admin.event.wrong_configchange");
            throw new IllegalArgumentException(msg);
        }
        super.addConfigChange(changeList);
    }

    public String getElementXPath() {
        return ElementChangeHelper.getElementXPath(this.getConfigChangeList());
    }

    public String getElementId() {
        return this.element_id;
    }

    public int getActionType() {
        return this.change_action;
    }

    private void setAction(int action) {
        boolean valid = false;
        if (action == 1 || action == 2 || action == 3) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_action", "" + action);
            throw new IllegalArgumentException(msg);
        }
        this.change_action = action;
    }
}

