/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import com.sun.enterprise.admin.jmx.remote.StringManager;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

public class StringManagerFactory {
    private static Hashtable managers = new Hashtable();
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public static IStringManager getServerStringManager(String packageName) {
        String stringMgrClassName = System.getProperty("STRING_MANAGER_CLASS_KEY");
        return StringManagerFactory.getManager(packageName, stringMgrClassName);
    }

    public static IStringManager getClientStringManager(String packageName, Map env) {
        String stringMgrClassName = null;
        if (env != null) {
            stringMgrClassName = (String)env.get("STRING_MANAGER_CLASS_KEY");
        }
        return StringManagerFactory.getManager(packageName, stringMgrClassName);
    }

    public static IStringManager getServerStringManager(Class inputClass) {
        String packageName = inputClass.getPackage().getName();
        String stringMgrClassName = System.getProperty("STRING_MANAGER_CLASS_KEY");
        return StringManagerFactory.getManager(packageName, stringMgrClassName);
    }

    public static IStringManager getClientStringManager(Class inputClass, Map env) {
        String packageName = inputClass.getPackage().getName();
        String stringMgrClassName = null;
        if (env != null) {
            stringMgrClassName = (String)env.get("STRING_MANAGER_CLASS_KEY");
        }
        return StringManagerFactory.getManager(packageName, stringMgrClassName);
    }

    public static IStringManager getManager(String packageName, String stringMgrClassName) {
        IStringManager mgr = (IStringManager)managers.get(packageName);
        if (mgr != null) {
            return mgr;
        }
        if (stringMgrClassName == null) {
            mgr = new StringManager(packageName);
        } else {
            try {
                Class<?> customClass = Class.forName(stringMgrClassName);
                Constructor<?> constructor = customClass.getConstructor(String.class);
                mgr = (IStringManager)constructor.newInstance(packageName);
            }
            catch (Exception e) {
                logger.severe("StringManager could not be configured");
            }
        }
        if (mgr != null) {
            managers.put(packageName, mgr);
        } else {
            logger.severe("Custom StringManager Class could not be instantiated");
        }
        return mgr;
    }
}

