/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.comm;

import com.sun.appserv.management.client.RedirectException;
import com.sun.enterprise.admin.jmx.remote.comm.ConnectionFactory;
import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.comm.IConnection;
import com.sun.enterprise.admin.jmx.remote.comm.ServletConnection;
import com.sun.enterprise.admin.jmx.remote.streams.StreamMBeanServerRequestMessage;
import java.io.IOException;
import java.net.URL;
import javax.management.remote.message.MBeanServerResponseMessage;

public class MBeanServerMessageConductor {
    private IConnection connection;
    private boolean autoRedirect = true;

    public MBeanServerMessageConductor(IConnection connection) {
        this.connection = connection;
        String redirect = System.getProperty("com.sun.jmx.remote.http.redirect.enable");
        if ("false".equalsIgnoreCase(redirect)) {
            this.autoRedirect = false;
        }
    }

    public MBeanServerResponseMessage invoke(int methodId, Object[] params) throws Exception {
        StreamMBeanServerRequestMessage request = new StreamMBeanServerRequestMessage(methodId, params, null);
        this.connection.send(request);
        MBeanServerResponseMessage response = null;
        try {
            response = (MBeanServerResponseMessage)this.connection.receive();
        }
        catch (RedirectException ex) {
            if (!this.autoRedirect) {
                throw ex;
            }
            this.processRedirect(ex);
            response = this.invoke(request);
        }
        return response;
    }

    public MBeanServerResponseMessage invoke(StreamMBeanServerRequestMessage request) throws Exception {
        this.connection.send(request);
        return (MBeanServerResponseMessage)this.connection.receive();
    }

    private void processRedirect(RedirectException ex) throws IOException {
        URL redirect = ex.getRedirectURL();
        if (this.isRedirectionInvalid(redirect, this.connection)) {
            throw new RedirectException(ex.getRedirectURLStr(), "Invalid Redirect. Security cannot be downgraded. Please try with --secure=false");
        }
        this.connection = this.getConnectionWithRedirectedURL(this.connection, redirect);
    }

    private IConnection getConnectionWithRedirectedURL(IConnection connection, URL redirect) throws IOException {
        ServletConnection sc = (ServletConnection)connection;
        HttpConnectorAddress hca = new HttpConnectorAddress(sc.getURL().getHost(), redirect.getPort());
        hca.setPath(sc.getURL().getPath());
        hca.setAuthenticationInfo(sc.getHttpConnectorAddress().getAuthenticationInfo());
        if (redirect.getProtocol().equalsIgnoreCase("https")) {
            hca.setSecure(true);
        } else if (redirect.getProtocol().equalsIgnoreCase("http")) {
            hca.setSecure(false);
        }
        return ConnectionFactory.createConnection(hca);
    }

    private boolean isRedirectionInvalid(URL redirect, IConnection origConn) {
        ServletConnection sc = (ServletConnection)origConn;
        if (redirect == null) {
            return true;
        }
        String redirectedHost = redirect.getHost();
        String origHost = sc.getURL().getHost();
        if (redirectedHost == null) {
            return true;
        }
        if (!redirectedHost.equalsIgnoreCase(origHost)) {
            return true;
        }
        String newProtocol = redirect.getProtocol();
        String origProtocol = sc.getURL().getProtocol();
        return origProtocol.equalsIgnoreCase("https") && newProtocol.equalsIgnoreCase("http");
    }
}

