/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server.notification;

import com.sun.enterprise.admin.jmx.remote.notification.NotificationWrapper;
import com.sun.enterprise.admin.jmx.remote.notification.SimpleQueue;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.util.logging.Logger;

public class NotificationConnection
implements Runnable {
    private SimpleQueue que = new SimpleQueue();
    private int bufsiz = 0;
    private Thread dispatchThr = null;
    private long lastNotifTime = 0L;
    private OutputStream out = null;
    private boolean exiting = false;
    private boolean dispatching = false;
    private boolean isIOException = false;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public NotificationConnection(OutputStream out, int bufsiz) {
        this.out = out;
        this.bufsiz = bufsiz <= 10 ? 50 : bufsiz;
        this.dispatchThr = new Thread(this);
        this.dispatchThr.start();
    }

    public void reinit(OutputStream out) {
        this.out = out;
        this.isIOException = false;
        this.dispatchThr = new Thread(this);
        this.dispatchThr.start();
    }

    public boolean hasIOExceptionOccurred() {
        return this.isIOException;
    }

    private boolean isIdle() {
        boolean ret = System.currentTimeMillis() - this.lastNotifTime >= 10000L;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWaitNotif() {
        if (!this.hasIOExceptionOccurred() && this.que.size() < this.bufsiz && !this.dispatching && this.isIdle()) {
            SimpleQueue simpleQueue = this.que;
            synchronized (simpleQueue) {
                this.que.add(new NotificationWrapper(1, null, null));
                this.que.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotification(NotificationWrapper wrapr) {
        if (this.que.size() < this.bufsiz) {
            SimpleQueue simpleQueue = this.que;
            synchronized (simpleQueue) {
                this.que.add(wrapr);
                this.que.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.exiting = true;
        SimpleQueue simpleQueue = this.que;
        synchronized (simpleQueue) {
            this.que.notify();
        }
        try {
            this.dispatchThr.join();
        }
        catch (InterruptedException intre) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isExiting() {
        return this.exiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isExiting() && !this.hasIOExceptionOccurred()) {
            SimpleQueue simpleQueue = this.que;
            synchronized (simpleQueue) {
                while (this.que.isEmpty() && !this.isExiting() && !this.hasIOExceptionOccurred()) {
                    try {
                        this.que.wait();
                    }
                    catch (InterruptedException intre) {}
                }
            }
            if (this.isExiting() || this.hasIOExceptionOccurred()) break;
            this.dispatching = true;
            while (!(this.que.isEmpty() || this.isExiting() || this.hasIOExceptionOccurred())) {
                NotificationWrapper wrapr = (NotificationWrapper)this.que.remove();
                try {
                    this.sendNotificationMsg(wrapr);
                }
                catch (IOException ioe) {
                    if (this.isExiting() || !this.isDisconnected(ioe)) break;
                    this.isIOException = true;
                    NotificationConnection notificationConnection = this;
                    synchronized (notificationConnection) {
                        this.notify();
                        break;
                    }
                }
            }
            this.lastNotifTime = System.currentTimeMillis();
            this.dispatching = false;
        }
    }

    private boolean isDisconnected(IOException ioe) {
        return ioe instanceof ClosedChannelException || ioe instanceof SocketException || ioe instanceof ConnectException || ioe instanceof ConnectIOException;
    }

    private void sendNotificationMsg(NotificationWrapper wrapr) throws IOException {
        ObjectOutputStream objout = new ObjectOutputStream(this.out);
        objout.writeObject(wrapr);
        objout.flush();
    }
}

